/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.gutter;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.diagram.gutter.ModelDependenciesLineMarkerProviderBase;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public class ModelDependenciesLineMarkerProviderJava
extends ModelDependenciesLineMarkerProviderBase {
    public String getId() {
        return "ModelDependenciesLineMarkerProviderJava";
    }

    @Nullable
    public String getName() {
        return "Model Dependencies Graph (Java)";
    }

    @Override
    protected boolean isRelevantPsiElement(PsiElement psiElement) {
        if (!(psiElement instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement parent = psiElement.getParent();
        return parent instanceof PsiClass && SpringCommonUtils.isConfigurationOrMeta((PsiClass)parent);
    }

    @Override
    @Nullable
    protected LineMarkerInfo doAnnotate(PsiElement element) {
        PsiClass psiClass = (PsiClass)element.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        LocalAnnotationModel localAnnotationModel = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
        if (localAnnotationModel == null) {
            return null;
        }
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        return this.createLineMarkerInfo((PsiElement)identifier);
    }
}

