/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.SpringFrameworkDetector;
import com.intellij.spring.facet.searchers.CodeConfigSearcher;
import com.intellij.spring.facet.searchers.XmlConfigSearcher;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.highlighting.config.SpringFacetCodeInspection;
import com.intellij.spring.model.highlighting.config.SpringFacetInspection;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.config.ConfigFileSearcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SpringUnmappedConfigurationFilesCollector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.facet.validation.SpringUnmappedConfigurationFilesCollector");
    private static final LocalInspectionTool XML_CONFIG_INSPECTION = new SpringFacetInspection();
    private static final LocalInspectionTool CODE_CONFIG_INSPECTION = new SpringFacetCodeInspection();
    private final NullableFunction<VirtualFilePointer, PsiFile> myVirtualFileMapper = new NullableFunction<VirtualFilePointer, PsiFile>(){

        public PsiFile fun(VirtualFilePointer pointer) {
            return pointer.isValid() && pointer.getFile() != null ? SpringUnmappedConfigurationFilesCollector.this.myPsiManager.findFile(pointer.getFile()) : null;
        }
    };
    private final PsiManager myPsiManager;
    private final SpringManager mySpringManager;
    private final DetectionExcludesConfiguration myDetectionExcludesConfiguration;
    private final InspectionProfile myProfile;
    private final boolean myCheckXml;
    private final boolean myCheckCode;
    private final Module[] myModules;
    private final MultiMap<Module, VirtualFilePointer> myNotConfiguredStorage = new LinkedMultiMap();

    SpringUnmappedConfigurationFilesCollector(Module ... modules) {
        this.myModules = modules;
        Project project = modules[0].getProject();
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.mySpringManager = SpringManager.getInstance(project);
        this.myDetectionExcludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)project);
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)project);
        this.myProfile = profileManager.getCurrentProfile();
        this.myCheckXml = this.myProfile.isToolEnabled(HighlightDisplayKey.find((String)XML_CONFIG_INSPECTION.getID()));
        this.myCheckCode = this.myProfile.isToolEnabled(HighlightDisplayKey.find((String)CODE_CONFIG_INSPECTION.getID()));
    }

    boolean isEnabledInProject() {
        return this.myCheckXml || this.myCheckCode;
    }

    void collect() {
        this.collect((ProgressIndicator)new EmptyProgressIndicator());
    }

    void collect(ProgressIndicator indicator) {
        indicator.setText("Checking Spring Configuration");
        SpringFileSetService fileSetService = SpringFileSetService.getInstance();
        long start = System.currentTimeMillis();
        LOG.debug("================= START ============ total modules #" + this.myModules.length);
        HashSet<PsiFile> allKnownConfigurationFiles = new HashSet<PsiFile>();
        for (Module module : this.myModules) {
            indicator.checkCanceled();
            SpringFacet springFacet = SpringFacet.getInstance(module);
            if (springFacet == null) continue;
            for (SpringFileSet fileSet : fileSetService.getAllSets(springFacet)) {
                allKnownConfigurationFiles.addAll(ContainerUtil.mapNotNull(fileSet.getXmlFiles(), this.myVirtualFileMapper));
                allKnownConfigurationFiles.addAll(ContainerUtil.mapNotNull(fileSet.getCodeConfigurationFiles(), this.myVirtualFileMapper));
            }
        }
        LOG.debug("=== collected all known");
        LinkedMultiMap notConfigured = new LinkedMultiMap();
        indicator.setText2("Searching unmapped configuration files...");
        int i = 0;
        for (Module module : this.myModules) {
            List<PsiFile> files;
            indicator.checkCanceled();
            if (this.myCheckXml) {
                files = this.collectNotConfigured(indicator, allKnownConfigurationFiles, new XmlConfigSearcher(module, false), module);
                notConfigured.putValues((Object)module, files);
            }
            if (this.myCheckCode) {
                files = this.collectNotConfigured(indicator, allKnownConfigurationFiles, new CodeConfigSearcher(module, false), module);
                notConfigured.putValues((Object)module, files);
            }
            indicator.setFraction((double)i++ / (double)this.myModules.length);
        }
        LOG.debug("=== collected not configured");
        Set<PsiFile> filesUsedInSpringModels = this.getFilesUsedImplicitlyInSpringModels(indicator, (MultiMap<Module, PsiFile>)notConfigured);
        for (Map.Entry entry : notConfigured.entrySet()) {
            ((Collection)entry.getValue()).removeAll(filesUsedInSpringModels);
        }
        LOG.debug("=== processed implicit spring model");
        Set<PsiFile> filesUsedImplicitlyAsStereotype = SpringUnmappedConfigurationFilesCollector.getFilesUsedImplicitlyAsStereotype(indicator, (MultiMap<Module, PsiFile>)notConfigured);
        for (Map.Entry entry : notConfigured.entrySet()) {
            ((Collection)entry.getValue()).removeAll(filesUsedImplicitlyAsStereotype);
        }
        for (Map.Entry entry : notConfigured.entrySet()) {
            ArrayList<VirtualFilePointer> filePointers = new ArrayList<VirtualFilePointer>(((Collection)entry.getValue()).size());
            for (PsiFile file : (Collection)entry.getValue()) {
                VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(file.getVirtualFile(), (Disposable)file.getProject(), null);
                filePointers.add(pointer);
            }
            this.myNotConfiguredStorage.put(entry.getKey(), filePointers);
        }
        LOG.debug("================= END ============  total time: " + (System.currentTimeMillis() - start));
    }

    public boolean hasResults() {
        return !this.myNotConfiguredStorage.isEmpty();
    }

    public List<Pair<Module, Collection<PsiFile>>> getModulesWithUnmappedFiles() {
        ArrayList<Pair<Module, Collection<PsiFile>>> result = new ArrayList<Pair<Module, Collection<PsiFile>>>();
        for (Map.Entry entry : this.myNotConfiguredStorage.entrySet()) {
            Collection files = (Collection)entry.getValue();
            if (files.isEmpty()) continue;
            result.add((Pair<Module, Collection<PsiFile>>)Pair.create(entry.getKey(), (Object)ContainerUtil.mapNotNull((Collection)files, this.myVirtualFileMapper)));
        }
        return result;
    }

    public Collection<PsiFile> getUnmappedFilesFor(Module module) {
        return ContainerUtil.mapNotNull((Collection)this.myNotConfiguredStorage.get((Object)module), this.myVirtualFileMapper);
    }

    private List<PsiFile> collectNotConfigured(ProgressIndicator indicator, Set<PsiFile> allKnownConfigurationFiles, ConfigFileSearcher searcher, Module module) {
        searcher.search();
        Collection files = searcher.getFilesByModules().get((Object)module);
        SmartList notConfigured = new SmartList();
        for (PsiFile file : files) {
            PsiClass[] classes;
            if (allKnownConfigurationFiles.contains(file)) continue;
            indicator.checkCanceled();
            if (this.myDetectionExcludesConfiguration.isExcludedFromDetection(file.getVirtualFile(), SpringFrameworkDetector.SPRING_FRAMEWORK_TYPE) || file instanceof XmlFile && this.skipConfigInspectionFor((PsiElement)file, XML_CONFIG_INSPECTION) || file instanceof PsiClassOwner && (classes = ((PsiClassOwner)file).getClasses()).length == 1 && this.skipConfigInspectionFor((PsiElement)classes[0], CODE_CONFIG_INSPECTION)) continue;
            notConfigured.add(file);
        }
        return notConfigured;
    }

    private boolean skipConfigInspectionFor(PsiElement place, LocalInspectionTool tool) {
        HighlightDisplayKey toolHighlightDisplayKey = HighlightDisplayKey.find((String)tool.getID());
        return !this.myProfile.isToolEnabled(toolHighlightDisplayKey, place) || SuppressionUtil.inspectionResultSuppressed((PsiElement)place, (LocalInspectionTool)tool);
    }

    private Set<PsiFile> getFilesUsedImplicitlyInSpringModels(ProgressIndicator indicator, MultiMap<Module, PsiFile> notConfigured) {
        Collection allNotConfiguredFiles = notConfigured.values();
        if (allNotConfiguredFiles.isEmpty()) {
            return Collections.emptySet();
        }
        indicator.setText2("Searching for implicit usages...");
        indicator.setFraction(0.0);
        int i = 0;
        int moduleCount = notConfigured.size();
        LOG.debug("=== implicit spring model  modules #" + moduleCount + " total files #" + allNotConfiguredFiles.size());
        int moduleIdx = 0;
        HashSet<PsiFile> found = new HashSet<PsiFile>();
        for (Map.Entry entry : notConfigured.entrySet()) {
            Module module = (Module)entry.getKey();
            Collection notConfiguredFiles = (Collection)entry.getValue();
            LOG.debug("=== processing " + ++moduleIdx + " files #" + notConfiguredFiles.size());
            ModuleUtilCore.visitMeAndDependentModules((Module)module, visitModule -> {
                Set<SpringModel> models = this.mySpringManager.getAllModelsWithoutDependencies(visitModule);
                for (SpringModel model : models) {
                    if (model.getFileSet() == null) continue;
                    indicator.checkCanceled();
                    for (PsiFile configFile : model.getConfigFiles()) {
                        if (!notConfiguredFiles.contains(configFile)) continue;
                        found.add(configFile);
                        if (!found.containsAll(notConfiguredFiles)) continue;
                        return false;
                    }
                }
                return true;
            });
            if (found.containsAll(allNotConfiguredFiles)) {
                LOG.debug("=== early exit");
                return found;
            }
            indicator.setFraction((double)i++ / (double)moduleCount);
        }
        return found;
    }

    private static Set<PsiFile> getFilesUsedImplicitlyAsStereotype(ProgressIndicator indicator, MultiMap<Module, PsiFile> notConfigured) {
        if (notConfigured.isEmpty()) {
            return Collections.emptySet();
        }
        LOG.debug("=== collected implicit stereotype   remaining modules #" + notConfigured.size());
        indicator.setText2("Searching for stereotype usages...");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        int totalNotConfiguredStereoTypes = 0;
        HashMap notConfiguredStereotypes = new HashMap();
        for (Map.Entry entry : notConfigured.entrySet()) {
            Collection configFiles = (Collection)entry.getValue();
            List psiClassOwners = ContainerUtil.findAll((Collection)configFiles, PsiClassOwner.class);
            if (psiClassOwners.isEmpty()) continue;
            notConfiguredStereotypes.put(entry.getKey(), psiClassOwners);
            totalNotConfiguredStereoTypes += psiClassOwners.size();
        }
        int moduleIdx = 0;
        int processed = 0;
        HashSet<PsiFile> foundStereoTypeConfigFiles = new HashSet<PsiFile>();
        for (Map.Entry entry : notConfiguredStereotypes.entrySet()) {
            Module module = (Module)entry.getKey();
            List psiClassOwners = (List)entry.getValue();
            Set<SpringModel> allModels = SpringManager.getInstance(module.getProject()).getAllModels(module);
            LOG.debug("=== processing " + ++moduleIdx + " with " + allModels.size() + " models, PCO #" + psiClassOwners.size());
            for (PsiClassOwner psiClassOwner : psiClassOwners) {
                SpringModelSearchParameters.BeanClass params;
                PsiClass[] classes = psiClassOwner.getClasses();
                if (classes.length == 0) continue;
                PsiClass configClass = classes[0];
                LOG.debug("  " + configClass);
                if (!SpringCommonUtils.isSpringBeanCandidateClass(configClass) || !(params = SpringModelSearchParameters.byClass(configClass)).canSearch()) continue;
                for (CommonSpringModel commonSpringModel : allModels) {
                    LOG.debug("  in " + commonSpringModel);
                    indicator.checkCanceled();
                    if (!SpringModelSearchers.doesBeanExist(commonSpringModel, params)) continue;
                    foundStereoTypeConfigFiles.add((PsiFile)psiClassOwner);
                    break;
                }
                indicator.setFraction((double)processed++ / (double)totalNotConfiguredStereoTypes);
                LOG.debug("   processed: " + processed);
            }
        }
        return foundStereoTypeConfigFiles;
    }
}

