/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiType;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SimpleSpringBeanPointer;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.SpringImplicitBeanWithDefinition;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointerImpl;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomSpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointerImpl;
import com.intellij.spring.model.xml.SpringBeanDomPointerImpl;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BeanServiceImpl
extends BeanService {
    private final Function<CommonSpringBean, SpringBeanPointer> myBeanToPointer = this::createSpringBeanPointer;

    @Override
    @NotNull
    public PsiType[] getEffectiveBeanTypes(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            BeanServiceImpl.$$$reportNull$$$0(0);
        }
        LinkedHashSet effectiveTypes = new LinkedHashSet(1);
        ContainerUtil.addIfNotNull(effectiveTypes, (Object)bean.getBeanType());
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        for (SpringBeanEffectiveTypeProvider provider : (SpringBeanEffectiveTypeProvider[])SpringBeanEffectiveTypeProvider.EP_NAME.getExtensions()) {
            if (!provider.processEffectiveTypes(bean, (Processor<PsiType>)collectProcessor)) break;
        }
        ContainerUtil.addAllNotNull(effectiveTypes, (Iterable)collectProcessor.getResults());
        PsiType[] psiTypeArray = effectiveTypes.toArray(PsiType.EMPTY_ARRAY);
        if (psiTypeArray == null) {
            BeanServiceImpl.$$$reportNull$$$0(1);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public SpringBeanPointer createSpringBeanPointer(@NotNull CommonSpringBean springBean) {
        if (springBean == null) {
            BeanServiceImpl.$$$reportNull$$$0(2);
        }
        if (springBean instanceof DomSpringBean) {
            if (springBean instanceof SpringBean) {
                SpringBeanDomPointerImpl springBeanDomPointerImpl = new SpringBeanDomPointerImpl((SpringBean)springBean);
                if (springBeanDomPointerImpl == null) {
                    BeanServiceImpl.$$$reportNull$$$0(3);
                }
                return springBeanDomPointerImpl;
            }
            DomSpringBeanPointerImpl domSpringBeanPointerImpl = new DomSpringBeanPointerImpl((DomSpringBean)springBean);
            if (domSpringBeanPointerImpl == null) {
                BeanServiceImpl.$$$reportNull$$$0(4);
            }
            return domSpringBeanPointerImpl;
        }
        if (springBean instanceof JamPsiMemberSpringBean) {
            JamSpringBeanPointerImpl jamSpringBeanPointerImpl = new JamSpringBeanPointerImpl((JamPsiMemberSpringBean)springBean);
            if (jamSpringBeanPointerImpl == null) {
                BeanServiceImpl.$$$reportNull$$$0(5);
            }
            return jamSpringBeanPointerImpl;
        }
        if (springBean instanceof CustomBean) {
            CustomSpringBeanPointer customSpringBeanPointer = CustomSpringBeanPointer.createCustomSpringBeanPointer((CustomBean)springBean);
            if (customSpringBeanPointer == null) {
                BeanServiceImpl.$$$reportNull$$$0(6);
            }
            return customSpringBeanPointer;
        }
        if (springBean instanceof SpringImplicitBeanWithDefinition) {
            SimpleSpringBeanPointer<SpringImplicitBeanWithDefinition> simpleSpringBeanPointer = new SimpleSpringBeanPointer<SpringImplicitBeanWithDefinition>((SpringImplicitBeanWithDefinition)springBean);
            if (simpleSpringBeanPointer == null) {
                BeanServiceImpl.$$$reportNull$$$0(7);
            }
            return simpleSpringBeanPointer;
        }
        throw new AssertionError((Object)("Unknown bean type: " + springBean));
    }

    @Override
    @NotNull
    public SpringBeanPsiTarget createSpringBeanPsiTarget(@NotNull CommonSpringBean springBean) {
        if (springBean == null) {
            BeanServiceImpl.$$$reportNull$$$0(8);
        }
        if (springBean instanceof DomSpringBean) {
            SpringBeanPsiTarget springBeanPsiTarget = DomSpringBeanPointerImpl.createSpringBeanPsiTarget((DomSpringBean)springBean);
            if (springBeanPsiTarget == null) {
                BeanServiceImpl.$$$reportNull$$$0(9);
            }
            return springBeanPsiTarget;
        }
        throw new IllegalArgumentException("Unsupported bean type: " + springBean);
    }

    @Override
    @NotNull
    public Set<SpringBeanPointer> mapSpringBeans(@NotNull Collection<? extends CommonSpringBean> beans) {
        if (beans == null) {
            BeanServiceImpl.$$$reportNull$$$0(10);
        }
        if (beans.isEmpty()) {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                BeanServiceImpl.$$$reportNull$$$0(11);
            }
            return set;
        }
        LinkedHashSet<SpringBeanPointer> set = new LinkedHashSet<SpringBeanPointer>(beans.size());
        for (CommonSpringBean commonSpringBean : beans) {
            if (!commonSpringBean.isValid()) continue;
            set.add((SpringBeanPointer)this.myBeanToPointer.fun((Object)commonSpringBean));
        }
        LinkedHashSet<SpringBeanPointer> linkedHashSet = set;
        if (linkedHashSet == null) {
            BeanServiceImpl.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/BeanServiceImpl";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/BeanServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveBeanTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpringBeanPointer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpringBeanPsiTarget";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mapSpringBeans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveBeanTypes";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSpringBeanPointer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSpringBeanPsiTarget";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mapSpringBeans";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

