/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns;

import com.intellij.codeInsight.generation.PatternDescriptor;
import com.intellij.codeInsight.generation.PatternProvider;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.actions.GenerateSpringDomElementAction;
import com.intellij.util.xml.actions.generate.AbstractDomGenerateProvider;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class PatternActionAdapter
extends PatternDescriptor
implements PatternProvider {
    private final String myId;
    private final List<PatternDescriptor> myChildren = new ArrayList<PatternDescriptor>();

    public PatternActionAdapter(String id) {
        this.myId = id;
        this.addMe();
    }

    protected void addMe() {
        this.myChildren.add(this);
    }

    protected void add(final GenerateSpringDomElementAction action) {
        this.myChildren.add(new PatternDescriptor(){

            @NotNull
            public String getParentId() {
                String string = PatternActionAdapter.this.myId;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getName() {
                String string = action.getTemplatePresentation().getText();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public Icon getIcon() {
                return action.getTemplatePresentation().getIcon();
            }

            public Template getTemplate() {
                String mappingId = this.getMappingId();
                return TemplateSettings.getInstance().getTemplateById(mappingId);
            }

            private String getMappingId() {
                return ((AbstractDomGenerateProvider)action.getProvider()).getMappingId();
            }

            public void actionPerformed(DataContext context) {
                UsageTrigger.trigger((String)("spring.GenerateByPattern." + this.getParentId() + "." + this.getMappingId()));
                action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)context));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/spring/model/actions/patterns/PatternActionAdapter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParentId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            PatternActionAdapter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getParentId() {
        if ("root" == null) {
            PatternActionAdapter.$$$reportNull$$$0(1);
        }
        return "root";
    }

    @NotNull
    public String getName() {
        String string = this.getDescription();
        if (string == null) {
            PatternActionAdapter.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Template getTemplate() {
        return null;
    }

    public void actionPerformed(DataContext context) {
    }

    protected abstract String getDescription();

    protected void addSeparator() {
    }

    public List<PatternDescriptor> getChildren() {
        return this.myChildren;
    }

    public final PatternDescriptor[] getDescriptors() {
        List<PatternDescriptor> children = this.getChildren();
        return children.toArray(new PatternDescriptor[0]);
    }

    public final boolean isAvailable(DataContext context) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        return file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/model/actions/patterns/PatternActionAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

