/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks.ui;

import com.intellij.codeInsight.template.Template;
import com.intellij.facet.ui.libraries.LibrariesValidationComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.actions.patterns.frameworks.ui.ChooseTemplatesForm;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChooseTemplatesDialogWrapper
extends DialogWrapper {
    private final ChooseTemplatesForm myTemplatesForm;

    public ChooseTemplatesDialogWrapper(Project project, List<TemplateInfo> infos, LibrariesInfo libInfo, String frameworkTitle) {
        super(project, true);
        this.myTemplatesForm = new ChooseTemplatesForm(infos, libInfo);
        this.myTemplatesForm.getLibrariesValidationComponent().addValidityListener(new LibrariesValidationComponent.ValidityListener(){

            public void valididyChanged(boolean isValid) {
                ChooseTemplatesDialogWrapper.this.setOKActionEnabled(isValid);
            }
        });
        this.setOKActionEnabled(this.myTemplatesForm.getLibrariesValidationComponent().isValid());
        this.setTitle(SpringBundle.message("spring.choose.bean.templates.dialog.title", frameworkTitle));
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            ChooseTemplatesDialogWrapper.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myTemplatesForm.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTemplatesForm.getComponent();
    }

    public ChooseTemplatesForm getTemplatesForm() {
        return this.myTemplatesForm;
    }

    public List<Template> getSelectedTemplates() {
        LinkedList<Template> templates = new LinkedList<Template>();
        for (TemplateInfo info : this.myTemplatesForm.getTemplateInfos()) {
            if (!info.isAccepted()) continue;
            templates.add(info.getTemplate());
        }
        return templates;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myTemplatesForm);
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/patterns/frameworks/ui/ChooseTemplatesDialogWrapper", "createActions"));
    }
}

