/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.converters.ConstructorArgIndexConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorArgIndexConverterImpl
extends ConstructorArgIndexConverter {
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<Integer> index, PsiElement element, ConvertContext context) {
        MyReference ref = new MyReference(element, index, context);
        PsiReference[] psiReferenceArray = new PsiReference[]{ref};
        if (psiReferenceArray == null) {
            ConstructorArgIndexConverterImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiParameter resolve(GenericDomValue<Integer> i, @NotNull SpringBean bean) {
        int index;
        Integer value;
        if (bean == null) {
            ConstructorArgIndexConverterImpl.$$$reportNull$$$0(1);
        }
        if ((value = (Integer)i.getValue()) != null && (index = value.intValue()) >= 0) {
            ResolvedConstructorArgs resolvedArgs = bean.getResolvedConstructorArgs();
            PsiMethod resolvedMethod = resolvedArgs.getResolvedMethod();
            if (resolvedMethod != null) {
                return resolvedArgs.getResolvedArgs(resolvedMethod).get(i.getParent());
            }
            List<PsiMethod> checkedMethods = resolvedArgs.getCheckedMethods();
            for (PsiMethod method : checkedMethods) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() <= index) continue;
                return parameterList.getParameters()[index];
            }
        }
        return null;
    }

    @NotNull
    public static Set<PsiParameter> multiResolve(GenericDomValue<Integer> i, SpringBean bean) {
        int index;
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        Integer value = (Integer)i.getValue();
        if (value != null && (index = value.intValue()) >= 0) {
            ResolvedConstructorArgs resolvedArgs = bean.getResolvedConstructorArgs();
            List<PsiMethod> candidates = resolvedArgs.getCandidates();
            for (PsiMethod method : candidates) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() <= index) continue;
                set.add(parameterList.getParameters()[index]);
            }
        }
        LinkedHashSet linkedHashSet = set;
        if (linkedHashSet == null) {
            ConstructorArgIndexConverterImpl.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final GenericDomValue<Integer> myGenericDomValue;
        private final ConvertContext myContext;

        public MyReference(PsiElement element, GenericDomValue<Integer> index, ConvertContext context) {
            super(element);
            this.myGenericDomValue = index;
            this.myContext = context;
        }

        public PsiParameter resolve() {
            SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean(this.myContext);
            if (bean == null) {
                return null;
            }
            return ConstructorArgIndexConverterImpl.resolve(this.myGenericDomValue, bean);
        }

        public boolean isSoft() {
            return true;
        }

        @NotNull
        public Object[] getVariants() {
            SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean(this.myContext);
            if (bean == null) {
                if (EMPTY_ARRAY == null) {
                    MyReference.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }
            List<PsiMethod> psiMethods = bean.getInstantiationMethods();
            int maxParams = 0;
            for (PsiMethod method : psiMethods) {
                PsiParameterList parameterList = method.getParameterList();
                maxParams = Math.max(maxParams, parameterList.getParametersCount());
            }
            if (maxParams > 0) {
                Object[] objects = new Object[maxParams];
                for (int i = 0; i < maxParams; ++i) {
                    objects[i] = Integer.toString(i);
                }
                if (objects == null) {
                    MyReference.$$$reportNull$$$0(1);
                }
                return objects;
            }
            if (EMPTY_ARRAY == null) {
                MyReference.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            Integer value = (Integer)this.myGenericDomValue.getValue();
            if (value != null) {
                SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean(this.myContext);
                assert (bean != null);
                PsiClass clazz = bean.getInstantiationClass();
                if (clazz != null) {
                    String string = bean.getFactoryMethod().getValue() != null ? SpringBundle.message("cannot.find.factory.method.index", value, clazz.getQualifiedName()) : SpringBundle.message("cannot.find.constructor.arg.index.in.class", value, clazz.getQualifiedName());
                    if (string == null) {
                        MyReference.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                String string = SpringBundle.message("cannot.find.constructor.arg.index", value);
                if (string == null) {
                    MyReference.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = IdeBundle.message((String)"value.should.be.integer", (Object[])new Object[0]);
            if (string == null) {
                MyReference.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/spring/model/converters/ConstructorArgIndexConverterImpl$MyReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

