/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.Function;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringResourceConverter
extends Converter<PsiFileSystemItem>
implements CustomReferenceConverter<PsiFileSystemItem> {
    public PsiFileSystemItem fromString(@Nullable String s, ConvertContext context) {
        GenericAttributeValue attributeValue;
        PsiReference[] references;
        DomElement domElement;
        if (s != null && (domElement = context.getInvocationElement()) instanceof GenericAttributeValue && (references = this.createReferences((PsiElement)(attributeValue = (GenericAttributeValue)domElement).getXmlAttributeValue(), attributeValue.getStringValue(), this.isEndingSlashNotAllowed())).length > 0) {
            for (int i = references.length - 1; i >= 0; --i) {
                PsiElement result;
                PsiReference reference = references[i];
                if (!(reference instanceof FileReference) || !((result = reference.resolve()) instanceof PsiFileSystemItem)) continue;
                return (PsiFileSystemItem)result;
            }
        }
        return null;
    }

    public String toString(@Nullable PsiFileSystemItem psiFile, ConvertContext context) {
        return null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiFileSystemItem> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = this.createReferences(element, genericDomValue.getStringValue(), this.isEndingSlashNotAllowed());
        if (psiReferenceArray == null) {
            SpringResourceConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    protected boolean isEndingSlashNotAllowed() {
        return true;
    }

    protected Condition<PsiFileSystemItem> getCondition() {
        return Conditions.alwaysTrue();
    }

    @Nullable
    protected Function<PsiFile, Collection<PsiFileSystemItem>> getCustomDefaultPathEvaluator(@NotNull PsiElement element, @NotNull String s) {
        if (element == null) {
            SpringResourceConverter.$$$reportNull$$$0(1);
        }
        if (s == null) {
            SpringResourceConverter.$$$reportNull$$$0(2);
        }
        return null;
    }

    @NotNull
    private PsiReference[] createReferences(@Nullable PsiElement element, @Nullable String s, boolean endingSlashNotAllowed) {
        if (s == null || element == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringResourceConverter.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SpringResourcesBuilder builder = SpringResourcesBuilder.create(element, s).fromRoot(StringUtil.startsWithChar((CharSequence)s, (char)'/')).filter(this.getCondition()).endingSlashNotAllowed(endingSlashNotAllowed).customDefaultPathEvaluator(this.getCustomDefaultPathEvaluator(element, s));
        PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(builder);
        if (psiReferenceArray == null) {
            SpringResourceConverter.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringResourceConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringResourceConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDefaultPathEvaluator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Directory
    extends SpringResourceConverter {
        @Override
        protected Condition<PsiFileSystemItem> getCondition() {
            return FileReferenceSet.DIRECTORY_FILTER;
        }
    }

    public static class Allowed
    extends SpringResourceConverter {
        @Override
        protected boolean isEndingSlashNotAllowed() {
            return false;
        }
    }
}

