/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.extensions.myBatis;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMyBatisBeansProvider
extends CustomLocalComponentsDiscoverer {
    @NonNls
    private static final String MAPPER_FACTORY_BEAN = "org.mybatis.spring.mapper.MapperFactoryBean";
    private static final String MAPPER_SCANNER_CONFIGURER = "org.mybatis.spring.mapper.MapperScannerConfigurer";

    @Override
    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel springModel) {
        Module module;
        if (springModel == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(0);
        }
        if ((module = springModel.getModule()) == null || !(springModel instanceof LocalXmlModel) || DumbService.isDumb((Project)module.getProject())) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringMyBatisBeansProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        HashSet myBatisMappers = new HashSet();
        this.collectMappers((LocalXmlModel)springModel, module, (Collection<CommonSpringBean>)myBatisMappers, MAPPER_FACTORY_BEAN);
        this.collectMappers((LocalXmlModel)springModel, module, (Collection<CommonSpringBean>)myBatisMappers, MAPPER_SCANNER_CONFIGURER);
        HashSet hashSet = myBatisMappers;
        if (hashSet == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public void collectMappers(@NotNull LocalXmlModel springModel, Module module, Collection<CommonSpringBean> myBatisMappers, String className) {
        PsiClass mapperFactoryBeanClass;
        if (springModel == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(3);
        }
        if ((mapperFactoryBeanClass = SpringCommonUtils.findLibraryClass(module, className)) == null) {
            return;
        }
        VirtualFile configFile = ((XmlFile)springModel.getConfig()).getVirtualFile();
        if (configFile == null) {
            return;
        }
        Project project = module.getProject();
        SpringBeanSearchParameters.BeanClass params = SpringBeanSearchParameters.byClass(project, SpringModelSearchParameters.byClass(mapperFactoryBeanClass));
        params.setVirtualFile(configFile);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        SpringXmlBeansIndex.processBeansByClass(params, (Processor<SpringBeanPointer>)processor);
        boolean includeTests = ProjectRootsUtil.isInTestSource((VirtualFile)configFile, (Project)project);
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (SpringBeanPointer springBaseBeanPointer : processor.getResults()) {
            SpringMyBatisBeansProvider.processBasePackages(myBatisMappers, facade, scope, springBaseBeanPointer);
            SpringMyBatisBeansProvider.processMarkerInterface(myBatisMappers, facade, scope, springBaseBeanPointer);
            SpringMyBatisBeansProvider.processCustomAnnotations(myBatisMappers, facade, scope, springBaseBeanPointer);
        }
    }

    private static void processMarkerInterface(@NotNull Collection<CommonSpringBean> mappers, @NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @NotNull SpringBeanPointer pointer) {
        if (mappers == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(4);
        }
        if (facade == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(6);
        }
        if (pointer == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(7);
        }
        SpringMyBatisBeansProvider.processMarkerInterface(mappers, facade, scope, SpringPropertyUtils.findPropertyByName(pointer.getSpringBean(), "markerInterface"));
        SpringMyBatisBeansProvider.processMarkerInterface(mappers, facade, scope, SpringPropertyUtils.findPropertyByName(pointer.getSpringBean(), "mapperInterface"));
    }

    private static void processMarkerInterface(@NotNull Collection<CommonSpringBean> mappers, @NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @Nullable SpringPropertyDefinition markerInterface) {
        PsiClass aClass;
        String value;
        if (mappers == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(8);
        }
        if (facade == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(10);
        }
        if (markerInterface != null && (value = markerInterface.getValueAsString()) != null && (aClass = facade.findClass(value, scope)) != null) {
            mappers.add(new CustomSpringComponent(aClass));
            for (PsiClass psiClass : ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true).findAll()) {
                mappers.add(new CustomSpringComponent(psiClass));
            }
        }
    }

    private static void processCustomAnnotations(@NotNull Collection<CommonSpringBean> mappers, @NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @NotNull SpringBeanPointer pointer) {
        PsiClass aClass;
        String value;
        SpringPropertyDefinition annotationClass;
        if (mappers == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(11);
        }
        if (facade == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(13);
        }
        if (pointer == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(14);
        }
        if ((annotationClass = SpringPropertyUtils.findPropertyByName(pointer.getSpringBean(), "annotationClass")) != null && (value = annotationClass.getValueAsString()) != null && (aClass = facade.findClass(value, scope)) != null && aClass.isAnnotationType()) {
            for (PsiClass annotatedClass : AnnotatedElementsSearch.searchPsiClasses((PsiClass)aClass, (SearchScope)scope).findAll()) {
                mappers.add(new CustomSpringComponent(annotatedClass));
            }
        }
    }

    private static void processBasePackages(final @NotNull Collection<CommonSpringBean> myBatisMappers, final @NotNull JavaPsiFacade facade, final @NotNull GlobalSearchScope scope, @NotNull SpringBeanPointer springBaseBeanPointer) {
        String value;
        SpringPropertyDefinition basePackages;
        if (myBatisMappers == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(15);
        }
        if (facade == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(17);
        }
        if (springBaseBeanPointer == null) {
            SpringMyBatisBeansProvider.$$$reportNull$$$0(18);
        }
        if ((basePackages = SpringPropertyUtils.findPropertyByName(springBaseBeanPointer.getSpringBean(), "basePackage")) != null && (value = basePackages.getValueAsString()) != null) {
            new DelimitedListProcessor(" ,"){

                protected void processToken(int start, int end, boolean delimitersOnly) {
                    String packageName = value.substring(start, end);
                    PsiPackage aPackage = facade.findPackage(packageName.trim());
                    if (aPackage != null) {
                        SpringMyBatisBeansProvider.processBasePackage(scope, aPackage, myBatisMappers);
                    }
                }
            }.processText(value);
        }
    }

    private static void processBasePackage(GlobalSearchScope scope, PsiPackage aPackage, Collection<CommonSpringBean> myBatisMappers) {
        for (PsiClass psiClass : aPackage.getClasses(scope)) {
            if (!psiClass.isInterface()) continue;
            myBatisMappers.add(new CustomSpringComponent(psiClass));
        }
        for (PsiClass psiClass : aPackage.getSubPackages(scope)) {
            SpringMyBatisBeansProvider.processBasePackage(scope, (PsiPackage)psiClass, myBatisMappers);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappers";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myBatisMappers";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBaseBeanPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComponents";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectMappers";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processMarkerInterface";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processCustomAnnotations";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processBasePackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

