/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringPlaceholdersInspection
extends BasicDomElementsInspection<Beans> {
    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof GenericDomValue) {
            XmlElement xmlElement;
            GenericDomValue value = (GenericDomValue)element;
            if (PlaceholderUtils.getInstance().isRawTextPlaceholder(value) && (xmlElement = SpringPlaceholdersInspection.getPlaceholderElement(value)) != null) {
                for (PsiReference psiReference : xmlElement.getReferences()) {
                    ResolveResult[] resolve;
                    PlaceholderPropertyReference placeholderPropertyReference;
                    String defaultValue;
                    if (!(psiReference instanceof PlaceholderPropertyReference) || (defaultValue = (placeholderPropertyReference = (PlaceholderPropertyReference)psiReference).getDefaultValue()) != null || (resolve = placeholderPropertyReference.multiResolve(false)).length != 0) continue;
                    holder.createResolveProblem(value, (PsiReference)placeholderPropertyReference);
                }
            }
        }
    }

    @Nullable
    private static XmlElement getPlaceholderElement(@NotNull GenericDomValue value) {
        XmlElement xmlElement;
        if (value == null) {
            SpringPlaceholdersInspection.$$$reportNull$$$0(0);
        }
        if ((xmlElement = value.getXmlElement()) instanceof XmlAttribute) {
            return ((XmlAttribute)xmlElement).getValueElement();
        }
        return xmlElement;
    }

    public SpringPlaceholdersInspection() {
        super(Beans.class, new Class[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringPlaceholdersInspection" == null) {
            SpringPlaceholdersInspection.$$$reportNull$$$0(1);
        }
        return "SpringPlaceholdersInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringPlaceholdersInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringPlaceholdersInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderElement";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

