/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringModelConfigurationFilesRecursivePanel
extends FinderRecursivePanel<SmartPsiElementPointer<NavigatablePsiElement>> {
    @NotNull
    private final Module myModule;

    protected SpringModelConfigurationFilesRecursivePanel(@NotNull FinderRecursivePanel panel, @NotNull Module module) {
        if (panel == null) {
            SpringModelConfigurationFilesRecursivePanel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringModelConfigurationFilesRecursivePanel.$$$reportNull$$$0(1);
        }
        super(panel);
        this.myModule = module;
    }

    @NotNull
    protected List<SmartPsiElementPointer<NavigatablePsiElement>> getListItems() {
        SpringModel model = this.findModel();
        if (model == null) {
            List<SmartPsiElementPointer<NavigatablePsiElement>> list = Collections.emptyList();
            if (list == null) {
                SpringModelConfigurationFilesRecursivePanel.$$$reportNull$$$0(2);
            }
            return list;
        }
        LinkedHashSet configFiles = new LinkedHashSet();
        model.processModels((Processor<CommonSpringModel>)((Processor)commonSpringModel -> {
            if (commonSpringModel instanceof LocalXmlModel) {
                configFiles.add(((LocalXmlModel)commonSpringModel).getConfig());
            }
            if (commonSpringModel instanceof LocalAnnotationModel) {
                configFiles.add(((PsiClass)((LocalAnnotationModel)commonSpringModel).getConfig()).getContainingFile());
            }
            return true;
        }));
        HashSet<NavigatablePsiElement> listItems = new HashSet<NavigatablePsiElement>(ContainerUtil.findAll(configFiles, XmlFile.class));
        for (PsiFile file : configFiles) {
            if (!(file instanceof PsiClassOwner)) continue;
            PsiClassOwner psiClassOwner = (PsiClassOwner)file;
            for (PsiClass topClass : psiClassOwner.getClasses()) {
                listItems.add((NavigatablePsiElement)topClass);
                SpringModelConfigurationFilesRecursivePanel.processInnerConfigurationClasses(listItems, topClass);
            }
        }
        SmartPointerManager instance = SmartPointerManager.getInstance((Project)this.getProject());
        ArrayList<SmartPsiElementPointer<NavigatablePsiElement>> pointers = new ArrayList<SmartPsiElementPointer<NavigatablePsiElement>>(listItems.size());
        for (NavigatablePsiElement item : listItems) {
            pointers.add((SmartPsiElementPointer<NavigatablePsiElement>)instance.createSmartPsiElementPointer((PsiElement)item));
        }
        pointers.sort((o1, o2) -> StringUtil.naturalCompare((String)this.getItemText((SmartPsiElementPointer<NavigatablePsiElement>)o1), (String)this.getItemText((SmartPsiElementPointer<NavigatablePsiElement>)o2)));
        ArrayList<SmartPsiElementPointer<NavigatablePsiElement>> arrayList = pointers;
        if (arrayList == null) {
            SpringModelConfigurationFilesRecursivePanel.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            SpringModelConfigurationFilesRecursivePanel.$$$reportNull$$$0(4);
        }
        return module;
    }

    private static void processInnerConfigurationClasses(Collection<NavigatablePsiElement> listItems, PsiClass psiClass) {
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            if (SpringCommonUtils.isConfigurationOrMeta(innerClass)) {
                listItems.add((NavigatablePsiElement)innerClass);
            }
            SpringModelConfigurationFilesRecursivePanel.processInnerConfigurationClasses(listItems, innerClass);
        }
    }

    @Nullable
    private static NavigatablePsiElement getNavigatable(@Nullable SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        return pointer != null ? (NavigatablePsiElement)pointer.getElement() : null;
    }

    @Nullable
    protected abstract SpringModel findModel();

    protected boolean hasChildren(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        return true;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            NavigatablePsiElement navigatablePsiElement = SpringModelConfigurationFilesRecursivePanel.getNavigatable((SmartPsiElementPointer<NavigatablePsiElement>)((SmartPsiElementPointer)this.getSelectedValue()));
            return navigatablePsiElement != null ? navigatablePsiElement.getContainingFile() : null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return SpringModelConfigurationFilesRecursivePanel.getNavigatable((SmartPsiElementPointer<NavigatablePsiElement>)((SmartPsiElementPointer)this.getSelectedValue()));
        }
        return super.getData(dataId);
    }

    protected AnAction[] getCustomListActions() {
        return new AnAction[]{ActionManager.getInstance().getAction("SpringChangeActiveProfiles")};
    }

    @NotNull
    protected String getItemText(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        NavigatablePsiElement navigatablePsiElement = SpringModelConfigurationFilesRecursivePanel.getNavigatable(pointer);
        if (navigatablePsiElement == null) {
            if ("<invalid>" == null) {
                SpringModelConfigurationFilesRecursivePanel.$$$reportNull$$$0(5);
            }
            return "<invalid>";
        }
        ItemPresentation presentation = navigatablePsiElement.getPresentation();
        String itemText = presentation != null ? presentation.getPresentableText() : navigatablePsiElement.getName();
        String string = StringUtil.notNullize((String)itemText, (String)"<unknown>");
        if (string == null) {
            SpringModelConfigurationFilesRecursivePanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        NavigatablePsiElement navigatablePsiElement = SpringModelConfigurationFilesRecursivePanel.getNavigatable(pointer);
        if (navigatablePsiElement == null) {
            return null;
        }
        if (navigatablePsiElement instanceof PsiClass && SpringCommonUtils.isConfiguration((PsiClass)navigatablePsiElement)) {
            return SpringApiIcons.SpringJavaConfig;
        }
        return navigatablePsiElement.getIcon(0);
    }

    @Nullable
    protected VirtualFile getContainingFile(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        return pointer.getVirtualFile();
    }

    @Nullable
    protected JComponent createRightComponent(SmartPsiElementPointer<NavigatablePsiElement> pointer) {
        NavigatablePsiElement navigatablePsiElement = SpringModelConfigurationFilesRecursivePanel.getNavigatable(pointer);
        if (navigatablePsiElement == null) {
            return null;
        }
        NullableFactory<CommonSpringModel> factory = this.getLocalSpringModel(navigatablePsiElement);
        return new SpringBeanPointerFinderRecursivePanel(this, factory);
    }

    private NullableFactory<CommonSpringModel> getLocalSpringModel(NavigatablePsiElement navigatablePsiElement) {
        return () -> {
            if (!navigatablePsiElement.isValid()) {
                return null;
            }
            if (navigatablePsiElement instanceof XmlFile) {
                return SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel((XmlFile)navigatablePsiElement, this.myModule, Collections.emptySet());
            }
            if (navigatablePsiElement instanceof PsiClass) {
                return SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel((PsiClass)navigatablePsiElement, this.myModule, Collections.emptySet());
            }
            return null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/toolWindow/panels/SpringModelConfigurationFilesRecursivePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/toolWindow/panels/SpringModelConfigurationFilesRecursivePanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

