/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopesCore {
    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(0);
        }
        ProductionScopeFilter productionScopeFilter = new ProductionScopeFilter(project);
        if (productionScopeFilter == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(1);
        }
        return productionScopeFilter;
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(2);
        }
        TestScopeFilter testScopeFilter = new TestScopeFilter(project);
        if (testScopeFilter == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(3);
        }
        return testScopeFilter;
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(4);
        }
        DirectoryScope directoryScope = new DirectoryScope(directory, withSubdirectories);
        if (directoryScope == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(5);
        }
        return directoryScope;
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(6);
        }
        if (directory == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(7);
        }
        DirectoryScope directoryScope = new DirectoryScope(project, directory, withSubdirectories);
        if (directoryScope == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(8);
        }
        return directoryScope;
    }

    @NotNull
    public static GlobalSearchScope directoriesScope(@NotNull Project project, boolean withSubdirectories, VirtualFile ... directories) {
        HashSet dirSet;
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(9);
        }
        if (directories == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(10);
        }
        if ((dirSet = ContainerUtil.newHashSet((Object[])directories)).isEmpty()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScopesCore.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }
        if (dirSet.size() == 1) {
            GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope(project, (VirtualFile)dirSet.iterator().next(), withSubdirectories);
            if (globalSearchScope == null) {
                GlobalSearchScopesCore.$$$reportNull$$$0(12);
            }
            return globalSearchScope;
        }
        DirectoriesScope directoriesScope = new DirectoriesScope(project, withSubdirectories ? Collections.emptySet() : dirSet, withSubdirectories ? dirSet : Collections.emptySet());
        if (directoriesScope == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(13);
        }
        return directoriesScope;
    }

    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(14);
        }
        if (set == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(15);
        }
        return new FilterScopeAdapter(project, set);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "projectProductionScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "projectTestScope";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "directoryScope";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "directoriesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "projectProductionScope";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "projectTestScope";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "directoryScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "directoriesScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class DirectoriesScope
    extends GlobalSearchScope {
        private final Set<VirtualFile> myDirectories;
        private final Set<VirtualFile> myDirectoriesWithSubdirectories;

        private DirectoriesScope(@NotNull Project project, @NotNull Set<VirtualFile> directories, @NotNull Set<VirtualFile> directoriesWithSubdirectories) {
            if (project == null) {
                DirectoriesScope.$$$reportNull$$$0(0);
            }
            if (directories == null) {
                DirectoriesScope.$$$reportNull$$$0(1);
            }
            if (directoriesWithSubdirectories == null) {
                DirectoriesScope.$$$reportNull$$$0(2);
            }
            super(project);
            this.myDirectories = directories;
            this.myDirectoriesWithSubdirectories = directoriesWithSubdirectories;
            if (directories.size() + directoriesWithSubdirectories.size() < 2) {
                throw new IllegalArgumentException("Expected >1 directories, but got: directories " + directories + ", directories with subdirectories " + directoriesWithSubdirectories);
            }
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            VirtualFile parent;
            if (file == null) {
                DirectoriesScope.$$$reportNull$$$0(3);
            }
            return (parent = file.getParent()) != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            if (parent == null) {
                DirectoriesScope.$$$reportNull$$$0(4);
            }
            if (this.myDirectories.contains(parent)) {
                return true;
            }
            return VfsUtilCore.isUnder(parent, this.myDirectoriesWithSubdirectories);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                DirectoriesScope.$$$reportNull$$$0(5);
            }
            if (file2 == null) {
                DirectoriesScope.$$$reportNull$$$0(6);
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                DirectoriesScope.$$$reportNull$$$0(7);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public String toString() {
            return "Directories scope: directories " + this.myDirectories + ", directories with subdirectories " + this.myDirectoriesWithSubdirectories;
        }

        @Override
        public int hashCode() {
            int result2 = this.myDirectories.hashCode();
            result2 = result2 * 31 + this.myDirectoriesWithSubdirectories.hashCode();
            return result2;
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoriesScope && this.myDirectories.equals(((DirectoriesScope)obj).myDirectories) && this.myDirectoriesWithSubdirectories.equals(((DirectoriesScope)obj).myDirectoriesWithSubdirectories);
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                DirectoriesScope.$$$reportNull$$$0(8);
            }
            if (this.equals(scope)) {
                DirectoriesScope directoriesScope = this;
                if (directoriesScope == null) {
                    DirectoriesScope.$$$reportNull$$$0(9);
                }
                return directoriesScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.in(other.myDirectory)) {
                    DirectoriesScope directoriesScope = this;
                    if (directoriesScope == null) {
                        DirectoriesScope.$$$reportNull$$$0(10);
                    }
                    return directoriesScope;
                }
                Set<VirtualFile> directories = this.myDirectories;
                Set<VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (other.myWithSubdirectories) {
                    directoriesWithSubdirectories = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    directoriesWithSubdirectories.add(other.myDirectory);
                } else {
                    directories = new HashSet<VirtualFile>(directories);
                    directories.add(other.myDirectory);
                }
                DirectoriesScope directoriesScope = new DirectoriesScope(this.getProject(), directories, directoriesWithSubdirectories);
                if (directoriesScope == null) {
                    DirectoriesScope.$$$reportNull$$$0(11);
                }
                return directoriesScope;
            }
            if (scope instanceof DirectoriesScope) {
                DirectoriesScope other = (DirectoriesScope)scope;
                Set<VirtualFile> directories = this.myDirectories;
                Set<VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (!other.myDirectories.isEmpty()) {
                    directories = new HashSet<VirtualFile>(directories);
                    directories.addAll(other.myDirectories);
                }
                if (!other.myDirectoriesWithSubdirectories.isEmpty()) {
                    directoriesWithSubdirectories = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    directoriesWithSubdirectories.addAll(other.myDirectoriesWithSubdirectories);
                }
                DirectoriesScope directoriesScope = new DirectoriesScope(this.getProject(), directories, directoriesWithSubdirectories);
                if (directoriesScope == null) {
                    DirectoriesScope.$$$reportNull$$$0(12);
                }
                return directoriesScope;
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                DirectoriesScope.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = super.getProject();
            if (project == null) {
                DirectoriesScope.$$$reportNull$$$0(14);
            }
            return project;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDirectories.size() + this.myDirectoriesWithSubdirectories.size() == 1) {
                Set<VirtualFile> dirs = this.myDirectories.size() == 1 ? this.myDirectories : this.myDirectoriesWithSubdirectories;
                VirtualFile root = (VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem(dirs));
                String string = "Directory '" + root.getName() + "'";
                if (string == null) {
                    DirectoriesScope.$$$reportNull$$$0(15);
                }
                return string;
            }
            Iterable allDirs = ContainerUtil.concat((Iterable[])new Iterable[]{this.myDirectories, this.myDirectoriesWithSubdirectories});
            String string = "Directories " + StringUtil.join((Iterable)allDirs, file -> "'" + file.getName() + "'", (String)", ");
            if (string == null) {
                DirectoriesScope.$$$reportNull$$$0(16);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directoriesWithSubdirectories";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "in";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory psiDirectory, boolean withSubdirectories) {
            if (psiDirectory == null) {
                DirectoryScope.$$$reportNull$$$0(0);
            }
            super(psiDirectory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = psiDirectory.getVirtualFile();
        }

        private DirectoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
            if (project == null) {
                DirectoryScope.$$$reportNull$$$0(1);
            }
            if (directory == null) {
                DirectoryScope.$$$reportNull$$$0(2);
            }
            super(project);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            VirtualFile parent;
            if (file == null) {
                DirectoryScope.$$$reportNull$$$0(3);
            }
            return (parent = file.getParent()) != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            if (parent == null) {
                DirectoryScope.$$$reportNull$$$0(4);
            }
            return this.myWithSubdirectories ? VfsUtilCore.isAncestor(this.myDirectory, parent, false) : this.myDirectory.equals(parent);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                DirectoryScope.$$$reportNull$$$0(5);
            }
            if (file2 == null) {
                DirectoryScope.$$$reportNull$$$0(6);
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                DirectoryScope.$$$reportNull$$$0(7);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }

        @Override
        public int hashCode() {
            return this.myDirectory.hashCode() * 31 + (this.myWithSubdirectories ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoryScope && this.myDirectory.equals(((DirectoryScope)obj).myDirectory) && this.myWithSubdirectories == ((DirectoryScope)obj).myWithSubdirectories;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                DirectoryScope.$$$reportNull$$$0(8);
            }
            if (this.equals(scope)) {
                DirectoryScope directoryScope = this;
                if (directoryScope == null) {
                    DirectoryScope.$$$reportNull$$$0(9);
                }
                return directoryScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.in(other.myDirectory)) {
                    DirectoryScope directoryScope = this;
                    if (directoryScope == null) {
                        DirectoryScope.$$$reportNull$$$0(10);
                    }
                    return directoryScope;
                }
                if (other.in(this.myDirectory)) {
                    DirectoryScope directoryScope = other;
                    if (directoryScope == null) {
                        DirectoryScope.$$$reportNull$$$0(11);
                    }
                    return directoryScope;
                }
                DirectoriesScope directoriesScope = new DirectoriesScope(this.getProject(), DirectoryScope.union(!this.myWithSubdirectories, this.myDirectory, !other.myWithSubdirectories, other.myDirectory), DirectoryScope.union(this.myWithSubdirectories, this.myDirectory, other.myWithSubdirectories, other.myDirectory));
                if (directoriesScope == null) {
                    DirectoryScope.$$$reportNull$$$0(12);
                }
                return directoriesScope;
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                DirectoryScope.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }

        private static Set<VirtualFile> union(boolean addDir1, @NotNull VirtualFile dir1, boolean addDir2, @NotNull VirtualFile dir2) {
            if (dir1 == null) {
                DirectoryScope.$$$reportNull$$$0(14);
            }
            if (dir2 == null) {
                DirectoryScope.$$$reportNull$$$0(15);
            }
            if (addDir1 && addDir2) {
                return ContainerUtil.newHashSet((Object[])new VirtualFile[]{dir1, dir2});
            }
            if (addDir1) {
                return Collections.singleton(dir1);
            }
            if (addDir2) {
                return Collections.singleton(dir2);
            }
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = super.getProject();
            if (project == null) {
                DirectoryScope.$$$reportNull$$$0(16);
            }
            return project;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = "Directory '" + this.myDirectory.getName() + "'";
            if (string == null) {
                DirectoryScope.$$$reportNull$$$0(17);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir1";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "in";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: {
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "union";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TestScopeFilter
    extends GlobalSearchScope {
        private TestScopeFilter(@NotNull Project project) {
            if (project == null) {
                TestScopeFilter.$$$reportNull$$$0(0);
            }
            super(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                TestScopeFilter.$$$reportNull$$$0(1);
            }
            return TestSourcesFilter.isTestSources(file, (Project)ObjectUtils.assertNotNull((Object)this.getProject()));
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                TestScopeFilter.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                TestScopeFilter.$$$reportNull$$$0(3);
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                TestScopeFilter.$$$reportNull$$$0(4);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                TestScopeFilter.$$$reportNull$$$0(5);
            }
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = PsiBundle.message("psi.search.scope.test.files", new Object[0]);
            if (string == null) {
                TestScopeFilter.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project) {
            if (project == null) {
                ProductionScopeFilter.$$$reportNull$$$0(0);
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                ProductionScopeFilter.$$$reportNull$$$0(1);
            }
            return this.myFileIndex.isInSourceContent(file) && !TestSourcesFilter.isTestSources(file, (Project)ObjectUtils.assertNotNull((Object)this.getProject()));
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                ProductionScopeFilter.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                ProductionScopeFilter.$$$reportNull$$$0(3);
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ProductionScopeFilter.$$$reportNull$$$0(4);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                ProductionScopeFilter.$$$reportNull$$$0(5);
            }
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            return ModuleManager.getInstance((Project)ObjectUtils.assertNotNull((Object)this.getProject())).getUnloadedModuleDescriptions();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = PsiBundle.message("psi.search.scope.production.files", new Object[0]);
            if (string == null) {
                ProductionScopeFilter.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;

        private FilterScopeAdapter(@NotNull Project project, @NotNull NamedScope set) {
            if (project == null) {
                FilterScopeAdapter.$$$reportNull$$$0(0);
            }
            if (set == null) {
                FilterScopeAdapter.$$$reportNull$$$0(1);
            }
            super(project);
            this.mySet = set;
            this.myManager = PsiManager.getInstance(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                FilterScopeAdapter.$$$reportNull$$$0(2);
            }
            Project project = this.getProject();
            NamedScopeManager holder = NamedScopeManager.getInstance(project);
            PackageSet packageSet = this.mySet.getValue();
            if (packageSet != null) {
                if (packageSet instanceof PackageSetBase) {
                    return ((PackageSetBase)packageSet).contains(file, project, holder);
                }
                PsiFile psiFile = this.myManager.findFile(file);
                return psiFile != null && packageSet.contains(psiFile, holder);
            }
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.mySet.getName();
            if (string == null) {
                FilterScopeAdapter.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = super.getProject();
            if (project == null) {
                FilterScopeAdapter.$$$reportNull$$$0(4);
            }
            return project;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(5);
            }
            if (file2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(6);
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FilterScopeAdapter.$$$reportNull$$$0(7);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

