/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Processor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.tools.AndroidApt;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPackagingStateStorage;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidResourcePackagingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidResourcePackagingBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidResourcePackagingBuildTarget> {
    @NonNls
    private static final String BUILDER_NAME = "Android Resource Packaging";

    protected AndroidResourcePackagingBuilder() {
        super(Collections.singletonList(AndroidResourcePackagingBuildTarget.MyTargetType.INSTANCE));
    }

    @Override
    protected void buildTarget(@NotNull AndroidResourcePackagingBuildTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, AndroidResourcePackagingBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        AndroidPackagingStateStorage.MyState savedState;
        if (target == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(3);
        }
        boolean releaseBuild = AndroidJpsUtil.isReleaseBuild(context);
        AndroidPackagingStateStorage packagingStateStorage = (AndroidPackagingStateStorage)context.getProjectDescriptor().dataManager.getStorage((BuildTarget)target, (StorageProvider)AndroidPackagingStateStorage.Provider.INSTANCE);
        if (!holder.hasDirtyFiles() && !holder.hasRemovedFiles() && (savedState = packagingStateStorage.read()) != null && savedState.isRelease() == releaseBuild) {
            return;
        }
        assert (!AndroidJpsUtil.isLightBuild(context));
        if (!AndroidResourcePackagingBuilder.packageResources(target, context, outputConsumer, releaseBuild)) {
            throw new StopBuildException();
        }
        packagingStateStorage.saveState(new AndroidPackagingStateStorage.MyState(releaseBuild));
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(4);
        }
        return BUILDER_NAME;
    }

    private static boolean packageResources(@NotNull AndroidResourcePackagingBuildTarget target, @NotNull CompileContext context, @NotNull BuildOutputConsumer outputConsumer, boolean releaseBuild) {
        if (target == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(5);
        }
        if (context == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(6);
        }
        if (outputConsumer == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(7);
        }
        JpsModule module = target.getModule();
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        assert (extension != null && !extension.isLibrary());
        context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.packaging.resources", module.getName())));
        File manifestFile = AndroidJpsUtil.getPreprocessedManifestFile(extension, context.getProjectDescriptor().dataManager.getDataPaths());
        if (manifestFile == null || !manifestFile.exists()) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.manifest.not.found", module.getName())));
            return false;
        }
        ArrayList<String> assetsDirPaths = new ArrayList<String>();
        AndroidResourcePackagingBuildTarget.collectAssetDirs(extension, assetsDirPaths, true);
        String outputFilePath = target.getOutputFile(context).getPath();
        File outputDir = new File(outputFilePath).getParentFile();
        assert (outputDir != null);
        if ((outputDir = AndroidJpsUtil.createDirIfNotExist(outputDir, context, BUILDER_NAME)) == null) {
            return false;
        }
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, BUILDER_NAME);
        if (platform == null) {
            return false;
        }
        IAndroidTarget androidTarget = platform.getTarget();
        String[] resourceDirPaths = AndroidJpsUtil.collectResourceDirsForCompilation(extension, true, context, true);
        String customManifestPackage = extension.isUseCustomManifestPackage() ? extension.getCustomManifestPackage() : null;
        String additionalParameters = extension.getAdditionalPackagingCommandLineParameters();
        return AndroidResourcePackagingBuilder.doPackageResources(context, manifestFile, androidTarget, resourceDirPaths, ArrayUtil.toStringArray(assetsDirPaths), outputFilePath, releaseBuild, module.getName(), outputConsumer, customManifestPackage, additionalParameters);
    }

    private static boolean doPackageResources(@NotNull CompileContext context, @NotNull File manifestFile, @NotNull IAndroidTarget target, @NotNull String[] resourceDirPaths, @NotNull String[] assetsDirPaths, @NotNull String outputPath, boolean releasePackage, @NotNull String moduleName, @NotNull BuildOutputConsumer outputConsumer, @Nullable String customManifestPackage, @Nullable String additionalParameters) {
        if (context == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(8);
        }
        if (manifestFile == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(9);
        }
        if (target == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(10);
        }
        if (resourceDirPaths == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(11);
        }
        if (assetsDirPaths == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(12);
        }
        if (outputPath == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(13);
        }
        if (moduleName == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(14);
        }
        if (outputConsumer == null) {
            AndroidResourcePackagingBuilder.$$$reportNull$$$0(15);
        }
        try {
            final IgnoredFileIndex ignoredFileIndex = context.getProjectDescriptor().getIgnoredFileIndex();
            Map messages = AndroidApt.packageResources((IAndroidTarget)target, (int)-1, (String)manifestFile.getPath(), (String[])resourceDirPaths, (String[])assetsDirPaths, (String)outputPath, null, (!releasePackage ? 1 : 0) != 0, (int)0, (String)customManifestPackage, (String)additionalParameters, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !ignoredFileIndex.isIgnored(PathUtilRt.getFileName((String)pathname.getPath()));
                }
            });
            AndroidJpsUtil.addMessages(context, messages, BUILDER_NAME, moduleName);
            boolean success = ((List)messages.get(AndroidCompilerMessageKind.ERROR)).isEmpty();
            if (success) {
                ArrayList<String> srcFiles = new ArrayList<String>();
                srcFiles.add(manifestFile.getPath());
                AndroidResourcePackagingBuilder.fillRecursively(resourceDirPaths, srcFiles);
                AndroidResourcePackagingBuilder.fillRecursively(assetsDirPaths, srcFiles);
                outputConsumer.registerOutputFile(new File(outputPath), srcFiles);
            }
            return success;
        }
        catch (IOException e) {
            AndroidJpsUtil.reportExceptionError(context, null, e, BUILDER_NAME);
            return false;
        }
    }

    private static void fillRecursively(String[] roots, final List<String> result) {
        for (String root : roots) {
            FileUtil.processFilesRecursively((File)new File(root), (Processor)new Processor<File>(){

                public boolean process(File file) {
                    if (file.isFile()) {
                        result.add(file.getPath());
                    }
                    return true;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/AndroidResourcePackagingBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirPaths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assetsDirPaths";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/AndroidResourcePackagingBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTarget";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "packageResources";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doPackageResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

