/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.psi.css.CssBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssDialect {
    public static final ExtensionPointName<CssDialect> EP_NAME = ExtensionPointName.create((String)"com.intellij.css.dialect");
    public static final CssDialect CLASSIC = new CssDialect(){

        @Override
        @NotNull
        public String getName() {
            if ("CLASSIC" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "CLASSIC";
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = CssBundle.message("css.w3c.dialect.name", new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isDefault(@NotNull Module module) {
            if (module == null) {
                1.$$$reportNull$$$0(2);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/css/CssDialect$1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/css/CssDialect$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isDefault";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getDisplayName();

    public abstract boolean isDefault(@NotNull Module var1);

    @Nullable
    @Contract(value="null -> null")
    public static CssDialect getDefaultDialect(@Nullable Module module) {
        if (module != null) {
            for (CssDialect dialect : (CssDialect[])Extensions.getExtensions(EP_NAME)) {
                if (!dialect.isDefault(module)) continue;
                return dialect;
            }
            return CLASSIC;
        }
        return null;
    }

    public static List<CssDialect> getAvailableDialects() {
        ArrayList<CssDialect> results = new ArrayList<CssDialect>();
        Collections.addAll(results, Extensions.getExtensions(EP_NAME));
        results.add(CLASSIC);
        return results;
    }

    public static List<CssDialect> getCustomDialects() {
        ArrayList<CssDialect> results = new ArrayList<CssDialect>();
        Collections.addAll(results, Extensions.getExtensions(EP_NAME));
        return results;
    }
}

