/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder;

import com.android.tools.pixelprobe.ColorMode;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.util.Strings;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

public abstract class Decoder {
    private final Set<String> formats = new HashSet<String>();

    public Decoder(String ... formats) {
        for (String format : formats) {
            this.formats.add(format.toLowerCase(Locale.ROOT));
        }
    }

    public boolean accept(String format) {
        return this.formats.contains(format.toLowerCase(Locale.ROOT));
    }

    public abstract boolean accept(InputStream var1);

    public Image decode(InputStream in, Options options) throws IOException {
        BufferedImage image;
        ImageInputStream stream = ImageIO.createImageInputStream(in);
        ImageReader reader = Decoder.getImageReader(stream);
        ImageReadParam parameters = reader.getDefaultReadParam();
        reader.setInput(stream, true, false);
        try {
            image = reader.read(0, parameters);
        }
        catch (IIOException e) {
            throw new IOException(e);
        }
        ColorModel colorModel = image.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        Image.Builder builder = new Image.Builder().format(reader.getFormatName()).dimensions(image.getWidth(), image.getHeight()).mergedImage(image).colorMode(Decoder.getColorMode(colorSpace)).colorSpace(colorSpace).depth(colorModel.getComponentSize(0));
        IIOMetadata metadata = reader.getImageMetadata(0);
        if (metadata != null) {
            this.decodeMetadata(builder, metadata);
        }
        reader.dispose();
        stream.close();
        return builder.build();
    }

    protected void decodeMetadata(Image.Builder builder, IIOMetadata metadata) {
    }

    private static ImageReader getImageReader(ImageInputStream stream) throws IOException {
        Iterator<ImageReader> readerIterator = ImageIO.getImageReaders(stream);
        if (!readerIterator.hasNext()) {
            throw new IOException("Unknown image format");
        }
        return readerIterator.next();
    }

    private static ColorMode getColorMode(ColorSpace colorSpace) {
        switch (colorSpace.getType()) {
            case 9: {
                return ColorMode.CMYK;
            }
            case 6: {
                return ColorMode.GRAYSCALE;
            }
            case 1: {
                return ColorMode.LAB;
            }
            case 5: {
                return ColorMode.RGB;
            }
        }
        return ColorMode.UNKNOWN;
    }

    public String toString() {
        return "Decoder{formats={" + Strings.join(this.formats, ",") + '}' + '}';
    }

    public static final class Options {
        private boolean decodeLayers = true;
        private boolean decodeLayerImageData = true;
        private boolean decodeLayerAdjustmentData = true;
        private boolean decodeLayerShapeData = true;
        private boolean decodeLayerTextData = true;
        private boolean decodeLayerEffects = true;
        private boolean decodeThumbnail = false;
        private boolean decodeGuides = true;
        public static final Options IMAGE_ONLY = new Options().decodeLayers(false).decodeGuides(false);
        public static final Options LAYER_METADATA_ONLY = new Options().decodeLayerImageData(false).decodeLayerShapeData(false).decodeLayerTextData(false).decodeLayerAdjustmentData(false).decodeLayerEffects(false);

        public boolean decodeLayers() {
            return this.decodeLayers;
        }

        public Options decodeLayers(boolean decodeLayers) {
            this.decodeLayers = decodeLayers;
            return this;
        }

        public boolean decodeLayerEffects() {
            return this.decodeLayerEffects;
        }

        public Options decodeLayerEffects(boolean decodeLayerEffects) {
            this.decodeLayerEffects = decodeLayerEffects;
            return this;
        }

        public boolean decodeLayerImageData() {
            return this.decodeLayerImageData;
        }

        public Options decodeLayerImageData(boolean decodeLayerImageData) {
            this.decodeLayerImageData = decodeLayerImageData;
            return this;
        }

        public boolean decodeLayerShapeData() {
            return this.decodeLayerShapeData;
        }

        public Options decodeLayerShapeData(boolean decodeLayerShapeData) {
            this.decodeLayerShapeData = decodeLayerShapeData;
            return this;
        }

        public boolean decodeLayerTextData() {
            return this.decodeLayerTextData;
        }

        public Options decodeLayerTextData(boolean decodeLayerTextData) {
            this.decodeLayerTextData = decodeLayerTextData;
            return this;
        }

        public boolean decodeLayerAdjustmentData() {
            return this.decodeLayerAdjustmentData;
        }

        public Options decodeLayerAdjustmentData(boolean decodeLayerAdjustmentData) {
            this.decodeLayerAdjustmentData = decodeLayerAdjustmentData;
            return this;
        }

        public boolean decodeThumbnail() {
            return this.decodeThumbnail;
        }

        public Options decodeThumbnail(boolean decodeThumbnail) {
            this.decodeThumbnail = decodeThumbnail;
            return this;
        }

        public boolean decodeGuides() {
            return this.decodeGuides;
        }

        public Options decodeGuides(boolean decodeGuides) {
            this.decodeGuides = decodeGuides;
            return this;
        }
    }
}

