/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder.psd;

import com.android.tools.pixelprobe.BlendMode;
import com.android.tools.pixelprobe.ColorMode;
import com.android.tools.pixelprobe.Effects;
import com.android.tools.pixelprobe.Guide;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.Layer;
import com.android.tools.pixelprobe.ShapeInfo;
import com.android.tools.pixelprobe.TextInfo;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.android.tools.pixelprobe.decoder.psd.PsdFile;
import com.android.tools.pixelprobe.decoder.psd.PsdUtils;
import com.android.tools.pixelprobe.decoder.psd.TextEngine;
import com.android.tools.pixelprobe.effect.Shadow;
import com.android.tools.pixelprobe.util.Bytes;
import com.android.tools.pixelprobe.util.Images;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

final class PsdImage {
    private static final String[] alignments = new String[]{"LEFT", "RIGHT", "CENTER", "JUSTIFY"};
    private static final Map<String, Integer> strokeCapsJoins = new HashMap<String, Integer>();
    private static final Map<String, ShapeInfo.Alignment> strokeAlignments;

    private PsdImage() {
    }

    static Image from(PsdFile psd, Decoder.Options options) {
        Image.Builder image = new Image.Builder();
        image.format("PSD");
        PsdImage.extractHeaderData(image, psd.header);
        PsdImage.resolveBlocks(image, psd.resources, options);
        if (options.decodeLayers()) {
            PsdImage.extractLayers(image, psd, options);
        }
        PsdImage.decodeImageData(image, psd);
        return image.build();
    }

    private static PsdFile.LayersList getLayers(PsdFile psd) {
        switch (psd.header.depth) {
            case 16: {
                PsdFile.LayerProperty property = psd.layersInfo.extras.get("Lr16");
                return property == null ? null : (PsdFile.LayersList)property.data;
            }
            case 32: {
                PsdFile.LayerProperty property = psd.layersInfo.extras.get("Lr32");
                return property == null ? null : (PsdFile.LayersList)property.data;
            }
        }
        return psd.layersInfo.layers;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void extractLayers(Image.Builder image, PsdFile psd, Decoder.Options options) {
        PsdFile.LayersList layersList = PsdImage.getLayers(psd);
        if (layersList == null) {
            return;
        }
        List<PsdFile.RawLayer> rawLayers = layersList.layers;
        LinkedList<Layer.Builder> stack = new LinkedList<Layer.Builder>();
        int[] unnamedCounts = new int[Layer.Type.values().length];
        Arrays.fill(unnamedCounts, 1);
        int i = Math.abs(layersList.count) - 1;
        while (true) {
            block22: {
                BlendMode blendMode;
                boolean isOpen;
                Layer.Type type;
                Map<String, PsdFile.LayerProperty> properties;
                PsdFile.RawLayer rawLayer;
                block24: {
                    block23: {
                        if (i < 0) {
                            return;
                        }
                        rawLayer = rawLayers.get(i);
                        properties = rawLayer.extras.properties;
                        PsdFile.LayerProperty sectionProperty = properties.get("lsct");
                        type = Layer.Type.IMAGE;
                        isOpen = true;
                        if (sectionProperty == null) break block23;
                        PsdFile.LayerSection section = (PsdFile.LayerSection)sectionProperty.data;
                        PsdFile.LayerSection.Type groupType = section.type;
                        switch (groupType) {
                            case OTHER: {
                                break block22;
                            }
                            case GROUP_CLOSED: {
                                isOpen = false;
                            }
                            case GROUP_OPENED: {
                                type = Layer.Type.GROUP;
                                break;
                            }
                            case BOUNDING: {
                                Layer.Builder group = (Layer.Builder)stack.pollFirst();
                                Layer.Builder parent = (Layer.Builder)stack.peekFirst();
                                if (parent == null) {
                                    image.addLayer(group.build());
                                    break block22;
                                } else {
                                    parent.addLayer(group.build());
                                }
                                break block22;
                            }
                        }
                        blendMode = PsdUtils.getBlendMode(section.blendMode);
                        break block24;
                    }
                    blendMode = PsdUtils.getBlendMode(rawLayer.blendMode);
                    type = PsdImage.getLayerType(rawLayer);
                }
                String name = PsdImage.getLayerName(rawLayer, type, unnamedCounts);
                Layer.Builder layer = new Layer.Builder(name, type);
                layer.bounds(rawLayer.left, rawLayer.top, rawLayer.right - rawLayer.left, rawLayer.bottom - rawLayer.top).opacity((float)rawLayer.opacity / 255.0f).blendMode(blendMode).clipBase(rawLayer.clipping == 0).open(isOpen).visible((rawLayer.flags & 2) == 0);
                Layer.Builder parent = (Layer.Builder)stack.peekFirst();
                switch (type) {
                    case ADJUSTMENT: {
                        break;
                    }
                    case IMAGE: {
                        if (!options.decodeLayerImageData()) break;
                        PsdImage.decodeLayerImageData(image, layer, rawLayer, layersList.channels.get(i));
                        break;
                    }
                    case GROUP: {
                        stack.offerFirst(layer);
                        break;
                    }
                    case SHAPE: {
                        if (!options.decodeLayerShapeData()) break;
                        PsdImage.decodeShapeData(image, layer, properties);
                        break;
                    }
                    case TEXT: {
                        if (!options.decodeLayerTextData()) break;
                        PsdImage.decodeTextData(image, layer, properties.get("TySh"));
                        break;
                    }
                }
                if (options.decodeLayerEffects()) {
                    PsdImage.extractLayerEffects(image, layer, rawLayer);
                }
                if (type != Layer.Type.GROUP) {
                    if (parent == null) {
                        image.addLayer(layer.build());
                    } else {
                        parent.addLayer(layer.build());
                    }
                }
            }
            --i;
        }
    }

    private static Layer.Type getLayerType(PsdFile.RawLayer rawLayer) {
        Map<String, PsdFile.LayerProperty> properties = rawLayer.extras.properties;
        Layer.Type type = Layer.Type.IMAGE;
        PsdFile.LayerProperty textProperty = properties.get("TySh");
        if (textProperty != null) {
            type = Layer.Type.TEXT;
        } else {
            PsdFile.LayerProperty vectorMask = properties.get("vmsk");
            PsdFile.LayerProperty shapeMask = properties.get("vsms");
            if (vectorMask != null || shapeMask != null) {
                type = Layer.Type.SHAPE;
            } else {
                for (String key : PsdUtils.getAdjustmentLayerKeys()) {
                    if (!properties.containsKey(key)) continue;
                    type = Layer.Type.ADJUSTMENT;
                    break;
                }
            }
        }
        return type;
    }

    private static String getLayerName(PsdFile.RawLayer rawLayer, Layer.Type type, int[] unnamedCounts) {
        Map<String, PsdFile.LayerProperty> properties = rawLayer.extras.properties;
        PsdFile.LayerProperty nameProperty = properties.get("luni");
        String name = nameProperty != null ? ((PsdFile.UnicodeString)nameProperty.data).value : rawLayer.extras.name;
        if (name.trim().isEmpty()) {
            int n = type.ordinal();
            int n2 = unnamedCounts[n];
            unnamedCounts[n] = n2 + 1;
            name = "<" + PsdImage.getNameForType(type) + " " + n2 + ">";
        }
        return name;
    }

    private static String getNameForType(Layer.Type type) {
        switch (type) {
            case ADJUSTMENT: {
                return "Adjustment";
            }
            case IMAGE: {
                return "Layer";
            }
            case GROUP: {
                return "Group";
            }
            case SHAPE: {
                return "Shape";
            }
            case TEXT: {
                return "Text";
            }
        }
        return "Unnamed";
    }

    private static void extractLayerEffects(Image.Builder image, Layer.Builder layer, PsdFile.RawLayer rawLayer) {
        Map<String, PsdFile.LayerProperty> properties = rawLayer.extras.properties;
        PsdFile.LayerProperty property = properties.get("lmfx");
        if (property == null && (property = properties.get("lfx2")) == null) {
            return;
        }
        PsdFile.LayerEffects layerEffects = (PsdFile.LayerEffects)property.data;
        Effects.Builder effects = new Effects.Builder();
        boolean effectsEnabled = (Boolean)PsdUtils.get(layerEffects.effects, "masterFXSwitch");
        if (effectsEnabled) {
            PsdImage.extractShadowEffects(image, effects, layerEffects, LayerShadow.INNER);
            PsdImage.extractShadowEffects(image, effects, layerEffects, LayerShadow.OUTER);
        }
        layer.effects(effects.build());
    }

    private static void extractShadowEffects(Image.Builder image, Effects.Builder effects, PsdFile.LayerEffects layerEffects, LayerShadow shadowType) {
        PsdFile.DescriptorItem.ValueList list;
        PsdFile.Descriptor descriptor = (PsdFile.Descriptor)PsdUtils.get(layerEffects.effects, shadowType.getName());
        if (descriptor != null) {
            PsdImage.addShadowEffect(image, effects, descriptor, shadowType);
        }
        if ((list = (PsdFile.DescriptorItem.ValueList)PsdUtils.get(layerEffects.effects, shadowType.getMultiName())) != null) {
            for (int i = 0; i < list.count; ++i) {
                descriptor = (PsdFile.Descriptor)list.items.get((int)i).data;
                if (!shadowType.getName().equals(descriptor.classId.toString())) continue;
                PsdImage.addShadowEffect(image, effects, descriptor, shadowType);
            }
        }
    }

    private static void addShadowEffect(Image.Builder image, Effects.Builder effects, PsdFile.Descriptor descriptor, LayerShadow type) {
        if (!PsdUtils.getBoolean(descriptor, "enab") || !PsdUtils.getBoolean(descriptor, "present")) {
            return;
        }
        Shadow.Type shadowType = Shadow.Type.INNER;
        if (type == LayerShadow.OUTER) {
            shadowType = Shadow.Type.OUTER;
        }
        float scale = image.verticalResolution();
        Shadow shadow = new Shadow.Builder(shadowType).blur(PsdUtils.getUnitFloat(descriptor, "blur", scale)).angle(PsdUtils.getUnitFloat(descriptor, "lagl", scale) * 360.0f).distance(PsdUtils.getUnitFloat(descriptor, "Dstn", scale)).opacity(PsdUtils.getUnitFloat(descriptor, "Opct", scale)).blendMode(PsdUtils.getBlendMode((String)PsdUtils.get(descriptor, "Md  "))).color(PsdUtils.getColor(descriptor)).build();
        effects.addShadow(shadow);
    }

    private static void decodeTextData(Image.Builder image, Layer.Builder layer, PsdFile.LayerProperty property) {
        TextEngine.MapProperty sheet;
        TextEngine.MapProperty style;
        int i;
        PsdFile.TypeToolObject typeTool = (PsdFile.TypeToolObject)property.data;
        TextInfo.Builder info = new TextInfo.Builder();
        info.text(((String)PsdUtils.get(typeTool.text, "Txt ")).replace('\r', '\n'));
        AffineTransform transform = new AffineTransform(typeTool.xx, typeTool.yx, typeTool.xy, typeTool.yy, typeTool.tx, typeTool.ty);
        info.transform(transform);
        float resolution = image.verticalResolution();
        PsdFile.DescriptorItem.UnitDouble left = (PsdFile.DescriptorItem.UnitDouble)PsdUtils.get(typeTool.text, "boundingBox.Left");
        PsdFile.DescriptorItem.UnitDouble top = (PsdFile.DescriptorItem.UnitDouble)PsdUtils.get(typeTool.text, "boundingBox.Top ");
        PsdFile.DescriptorItem.UnitDouble right = (PsdFile.DescriptorItem.UnitDouble)PsdUtils.get(typeTool.text, "boundingBox.Rght");
        PsdFile.DescriptorItem.UnitDouble bottom = (PsdFile.DescriptorItem.UnitDouble)PsdUtils.get(typeTool.text, "boundingBox.Btom");
        if (left != null && top != null && right != null && bottom != null) {
            info.bounds(PsdUtils.resolveUnit(left, resolution), PsdUtils.resolveUnit(top, resolution), PsdUtils.resolveUnit(right, resolution), PsdUtils.resolveUnit(bottom, resolution));
        }
        byte[] data = (byte[])PsdUtils.get(typeTool.text, "EngineData");
        TextEngine parser = new TextEngine();
        TextEngine.MapProperty properties = parser.parse(data);
        Object fontProperties = ((TextEngine.ListProperty)properties.get("ResourceDict.FontSet")).getValue();
        ArrayList fonts = new ArrayList(fontProperties.size());
        fonts.addAll(fontProperties.stream().map(element -> ((TextEngine.MapProperty)element).get("Name").toString()).collect(Collectors.toList()));
        int defaultSheetIndex = ((TextEngine.IntProperty)properties.get("ResourceDict.TheNormalStyleSheet")).getValue();
        TextEngine.MapProperty defaultSheet = (TextEngine.MapProperty)properties.get("ResourceDict.StyleSheetSet[" + defaultSheetIndex + "].StyleSheetData");
        int pos = 0;
        int[] runs = ((TextEngine.ListProperty)properties.get("EngineDict.StyleRun.RunLengthArray")).toIntArray();
        Object styles = ((TextEngine.ListProperty)properties.get("EngineDict.StyleRun.RunArray")).getValue();
        for (i = 0; i < runs.length; ++i) {
            style = (TextEngine.MapProperty)styles.get(i);
            sheet = (TextEngine.MapProperty)style.get("StyleSheet.StyleSheetData");
            int index = ((TextEngine.IntProperty)PsdImage.getFromMap(sheet, defaultSheet, "Font")).getValue();
            float size = ((TextEngine.FloatProperty)PsdImage.getFromMap(sheet, defaultSheet, "FontSize")).getValue().floatValue() / (resolution / 72.0f);
            float[] rgb = ((TextEngine.ListProperty)PsdImage.getFromMap(sheet, defaultSheet, "FillColor.Values")).toFloatArray();
            int tracking = ((TextEngine.IntProperty)PsdImage.getFromMap(sheet, defaultSheet, "Tracking")).getValue();
            int start = pos;
            int end = pos += runs[i];
            if (i == runs.length - 1) {
                --end;
            }
            TextInfo.StyleRun run = new TextInfo.StyleRun.Builder(start, end).font((String)fonts.get(index)).fontSize(size).paint(new Color(rgb[1], rgb[2], rgb[3], rgb[0])).tracking((float)tracking / 1000.0f).build();
            info.addStyleRun(run);
        }
        defaultSheetIndex = ((TextEngine.IntProperty)properties.get("ResourceDict.TheNormalParagraphSheet")).getValue();
        defaultSheet = (TextEngine.MapProperty)properties.get("ResourceDict.ParagraphSheetSet[" + defaultSheetIndex + "].Properties");
        pos = 0;
        runs = ((TextEngine.ListProperty)properties.get("EngineDict.ParagraphRun.RunLengthArray")).toIntArray();
        styles = ((TextEngine.ListProperty)properties.get("EngineDict.ParagraphRun.RunArray")).getValue();
        for (i = 0; i < runs.length; ++i) {
            style = (TextEngine.MapProperty)styles.get(i);
            sheet = (TextEngine.MapProperty)style.get("ParagraphSheet.Properties");
            int justification = ((TextEngine.IntProperty)PsdImage.getFromMap(sheet, defaultSheet, "Justification")).getValue();
            TextInfo.ParagraphRun run = new TextInfo.ParagraphRun.Builder(pos, pos += runs[i]).alignment(TextInfo.Alignment.valueOf(alignments[justification])).build();
            info.addParagraphRun(run);
        }
        layer.textInfo(info.build());
    }

    private static TextEngine.Property<?> getFromMap(TextEngine.MapProperty map, TextEngine.MapProperty defaultMap, String name) {
        TextEngine.Property<?> property = map.get(name);
        if (property == null) {
            property = defaultMap.get(name);
        }
        return property;
    }

    private static void decodeShapeData(Image.Builder image, Layer.Builder layer, Map<String, PsdFile.LayerProperty> properties) {
        PsdFile.LayerProperty property = properties.get("vmsk");
        if (property == null) {
            property = properties.get("vsms");
        }
        PsdFile.ShapeMask mask = (PsdFile.ShapeMask)property.data;
        Rectangle2D bounds = layer.bounds();
        AffineTransform transform = new AffineTransform();
        transform.translate(-bounds.getX(), -bounds.getY());
        transform.scale(image.width(), image.height());
        ShapeInfo.Builder shapeInfo = new ShapeInfo.Builder();
        PsdUtils.createPaths(mask, shapeInfo, transform);
        PsdImage.extractShapeStroke(shapeInfo, properties);
        PsdImage.extractShapeFill(shapeInfo, properties, property);
        layer.shapeInfo(shapeInfo.build());
    }

    private static void extractShapeFill(ShapeInfo.Builder shapeInfo, Map<String, PsdFile.LayerProperty> properties, PsdFile.LayerProperty property) {
        int alpha = 255;
        PsdFile.LayerProperty fillOpacity = properties.get("iOpa");
        if (fillOpacity != null) {
            alpha = (Byte)fillOpacity.data & 0xFF;
        }
        Color paint = Color.BLACK;
        PsdFile.Descriptor descriptor = null;
        if ("vsms".equals(property.key)) {
            PsdFile.LayerProperty shapeGraphics = properties.get("vscg");
            if (shapeGraphics != null) {
                PsdFile.ShapeGraphics graphics = (PsdFile.ShapeGraphics)shapeGraphics.data;
                if ("SoCo".equals(graphics.key)) {
                    descriptor = graphics.graphics;
                }
            }
        } else {
            PsdFile.LayerProperty solidColor = properties.get("SoCo");
            if (solidColor != null) {
                descriptor = ((PsdFile.SolidColorAdjustment)solidColor.data).solidColor;
            }
        }
        if (descriptor != null) {
            paint = PsdUtils.getColor(descriptor);
        }
        shapeInfo.fillPaint(paint).fillOpacity((float)alpha / 255.0f);
    }

    private static void extractShapeStroke(ShapeInfo.Builder shapeInfo, Map<String, PsdFile.LayerProperty> properties) {
        PsdFile.LayerProperty property = properties.get("vstk");
        if (property != null) {
            PsdFile.Descriptor descriptor = ((PsdFile.ShapeStroke)property.data).stroke;
            boolean fillEnabled = PsdUtils.getBoolean(descriptor, "fillEnabled");
            boolean strokeEnabled = PsdUtils.getBoolean(descriptor, "strokeEnabled");
            ShapeInfo.Style style = ShapeInfo.Style.from(fillEnabled, strokeEnabled);
            float resolution = PsdUtils.getFloat(descriptor, "strokeStyleResolution", 72.0f);
            float opacity = PsdUtils.getUnitFloat(descriptor, "strokeStyleOpacity", resolution);
            float width = PsdUtils.getUnitFloat(descriptor, "strokeStyleLineWidth", resolution);
            BlendMode blendMode = PsdUtils.getBlendMode((String)PsdUtils.get(descriptor, "strokeStyleBlendMode"));
            int cap = strokeCapsJoins.get(PsdUtils.get(descriptor, "strokeStyleLineCapType"));
            int join = strokeCapsJoins.get(PsdUtils.get(descriptor, "strokeStyleLineJoinType"));
            float miterLimit = PsdUtils.getFloat(descriptor, "strokeStyleMiterLimit");
            float dashOffset = PsdUtils.getUnitFloat(descriptor, "strokeStyleLineDashOffset", resolution);
            ShapeInfo.Alignment alignment = strokeAlignments.get(PsdUtils.get(descriptor, "strokeStyleLineAlignment"));
            float[] dash = null;
            PsdFile.DescriptorItem.ValueList dashSet = (PsdFile.DescriptorItem.ValueList)PsdUtils.get(descriptor, "strokeStyleLineDashSet");
            if (dashSet != null && dashSet.count > 0) {
                dash = new float[dashSet.count];
                for (int i = 0; i < dashSet.count; ++i) {
                    PsdFile.DescriptorItem.UnitDouble v = (PsdFile.DescriptorItem.UnitDouble)dashSet.items.get((int)i).data;
                    dash[i] = "#Nne".equals(v.unit) ? (float)(v.value * (double)width) : (float)PsdUtils.resolveUnit(v, resolution);
                }
            }
            BasicStroke stroke = new BasicStroke(width, cap, join, miterLimit, dash, dashOffset);
            Color paint = Color.BLACK;
            PsdFile.Descriptor colorLayer = (PsdFile.Descriptor)PsdUtils.get(descriptor, "strokeStyleContent.solidColorLayer");
            if (colorLayer != null) {
                paint = PsdUtils.getColor(colorLayer);
            }
            shapeInfo.style(style).stroke(stroke).strokePaint(paint).strokeOpacity(opacity).strokeBlendMode(blendMode).strokeAlignment(alignment);
        } else {
            shapeInfo.style(ShapeInfo.Style.FILL);
        }
    }

    private static void decodeLayerImageData(Image.Builder image, Layer.Builder layer, PsdFile.RawLayer rawLayer, PsdFile.ChannelsContainer channelsList) {
        Rectangle2D bounds = layer.bounds();
        if (bounds.isEmpty()) {
            return;
        }
        int channels = rawLayer.channels;
        switch (image.colorMode()) {
            case BITMAP: 
            case INDEXED: {
                break;
            }
            case GRAYSCALE: {
                channels = Math.min(channels, 2);
                break;
            }
            case RGB: {
                channels = Math.min(channels, 4);
                break;
            }
            case CMYK: {
                channels = Math.min(channels, 5);
                break;
            }
            case UNKNOWN: 
            case NONE: 
            case MULTI_CHANNEL: {
                break;
            }
            case DUOTONE: {
                channels = Math.min(channels, 2);
                break;
            }
            case LAB: {
                channels = Math.min(channels, 4);
            }
        }
        ColorSpace colorSpace = image.colorSpace();
        BufferedImage bitmap = Images.create((int)bounds.getWidth(), (int)bounds.getHeight(), image.colorMode(), channels, colorSpace, image.depth());
        block13: for (int i = 0; i < rawLayer.channelsInfo.size(); ++i) {
            PsdFile.ChannelInformation info = rawLayer.channelsInfo.get(i);
            if (info.id < -1) continue;
            PsdFile.ChannelImageData imageData = channelsList.imageData.get(i);
            switch (imageData.compression) {
                case RAW: {
                    Images.decodeChannelRaw(imageData.data, 0, info.id, bitmap, image.depth());
                    continue block13;
                }
                case RLE: {
                    int offset = (int)(bounds.getHeight() * 2.0);
                    Images.decodeChannelRLE(imageData.data, offset, info.id, bitmap);
                    continue block13;
                }
            }
        }
        layer.image(PsdImage.fixBitmap(image, bitmap));
    }

    private static void extractHeaderData(Image.Builder image, PsdFile.Header header) {
        image.dimensions(header.width, header.height).colorMode(header.colorMode).depth(header.depth);
    }

    private static void resolveBlocks(Image.Builder image, PsdFile.ImageResources resources, Decoder.Options options) {
        PsdImage.extractResolution(image, (PsdFile.ResolutionInfoBlock)PsdUtils.get(resources, 1005));
        PsdImage.extractColorProfile(image, (PsdFile.ColorProfileBlock)PsdUtils.get(resources, 1039));
        if (options.decodeGuides()) {
            PsdImage.extractGuides(image, (PsdFile.GuidesResourceBlock)PsdUtils.get(resources, 1032));
        }
        if (options.decodeThumbnail()) {
            PsdImage.extractThumbnail(image, (PsdFile.ThumbnailResourceBlock)PsdUtils.get(resources, 1036));
        }
    }

    private static void extractColorProfile(Image.Builder image, PsdFile.ColorProfileBlock colorProfileBlock) {
        image.colorSpace(PsdUtils.createColorSpace(colorProfileBlock));
    }

    private static void extractResolution(Image.Builder image, PsdFile.ResolutionInfoBlock resolutionBlock) {
        if (resolutionBlock == null) {
            return;
        }
        float hRes = Bytes.fixed16_16ToFloat(resolutionBlock.horizontalResolution);
        if (resolutionBlock.horizontalUnit == PsdFile.ResolutionUnit.PIXEL_PER_CM) {
            hRes /= 0.39370078f;
        }
        float vRes = Bytes.fixed16_16ToFloat(resolutionBlock.verticalResolution);
        if (resolutionBlock.verticalUnit == PsdFile.ResolutionUnit.PIXEL_PER_CM) {
            vRes /= 0.39370078f;
        }
        image.resolution(hRes, vRes);
    }

    private static void extractThumbnail(Image.Builder image, PsdFile.ThumbnailResourceBlock thumbnailBlock) {
        if (thumbnailBlock == null) {
            return;
        }
        try {
            image.thumbnail(ImageIO.read(new ByteArrayInputStream(thumbnailBlock.thumbnail)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void extractGuides(Image.Builder image, PsdFile.GuidesResourceBlock guidesBlock) {
        if (guidesBlock == null) {
            return;
        }
        for (PsdFile.GuideBlock block : guidesBlock.guides) {
            Guide guide = new Guide.Builder().orientation(Guide.Orientation.values()[block.orientation.ordinal()]).position((float)block.location / 32.0f).build();
            image.addGuide(guide);
        }
    }

    private static void decodeImageData(Image.Builder image, PsdFile psd) {
        int channels = psd.header.channels;
        int alphaChannel = 0;
        PsdFile.LayersList layers = PsdImage.getLayers(psd);
        if (layers != null && layers.count < 0) {
            alphaChannel = 1;
        }
        switch (image.colorMode()) {
            case BITMAP: 
            case INDEXED: {
                PsdImage.decodeIndexedImageData(image, psd);
                return;
            }
            case GRAYSCALE: {
                channels = Math.min(channels, 1 + alphaChannel);
                break;
            }
            case RGB: {
                channels = Math.min(channels, 3 + alphaChannel);
                break;
            }
            case CMYK: {
                channels = Math.min(channels, 4 + alphaChannel);
                break;
            }
            case UNKNOWN: 
            case NONE: 
            case MULTI_CHANNEL: {
                break;
            }
            case DUOTONE: {
                channels = Math.min(channels, 1 + alphaChannel);
                break;
            }
            case LAB: {
                channels = Math.min(channels, 3 + alphaChannel);
            }
        }
        ColorSpace colorSpace = image.colorSpace();
        BufferedImage bitmap = null;
        switch (psd.imageData.compression) {
            case RAW: {
                bitmap = Images.decodeRaw(psd.imageData.data, 0, image.width(), image.height(), image.colorMode(), channels, colorSpace, psd.header.depth);
                break;
            }
            case RLE: {
                int offset = image.height() * psd.header.channels * 2;
                bitmap = Images.decodeRLE(psd.imageData.data, offset, image.width(), image.height(), image.colorMode(), channels, colorSpace, psd.header.depth);
                break;
            }
        }
        image.mergedImage(PsdImage.fixBitmap(image, bitmap));
    }

    private static void decodeIndexedImageData(Image.Builder image, PsdFile psd) {
        ColorSpace colorSpace = image.colorSpace();
        PsdFile.UnsignedShortBlock block = (PsdFile.UnsignedShortBlock)PsdUtils.get(psd.resources, 1046);
        int size = block == null ? 256 : block.data;
        block = (PsdFile.UnsignedShortBlock)PsdUtils.get(psd.resources, 1047);
        int transparency = block == null ? -1 : block.data;
        BufferedImage bitmap = null;
        switch (psd.imageData.compression) {
            case RAW: {
                bitmap = Images.decodeIndexedRaw(psd.imageData.data, 0, image.width(), image.height(), image.colorMode(), colorSpace, size, psd.colorData.data, transparency);
                break;
            }
            case RLE: {
                int offset = image.height() * psd.header.channels * 2;
                bitmap = Images.decodeIndexedRLE(psd.imageData.data, offset, image.width(), image.height(), image.colorMode(), colorSpace, size, psd.colorData.data, transparency);
                break;
            }
        }
        image.mergedImage(PsdImage.fixBitmap(image, bitmap));
    }

    private static BufferedImage fixBitmap(Image.Builder image, BufferedImage bitmap) {
        if (image.colorMode() == ColorMode.CMYK) {
            bitmap = Images.invert(bitmap);
        }
        return bitmap;
    }

    static {
        strokeCapsJoins.put("strokeStyleButtCap", 0);
        strokeCapsJoins.put("strokeStyleRoundCap", 1);
        strokeCapsJoins.put("strokeStyleSquareCap", 2);
        strokeCapsJoins.put("strokeStyleMiterJoin", 0);
        strokeCapsJoins.put("strokeStyleBevelJoin", 2);
        strokeCapsJoins.put("strokeStyleRoundJoin", 1);
        strokeAlignments = new HashMap<String, ShapeInfo.Alignment>();
        strokeAlignments.put("strokeStyleAlignInside", ShapeInfo.Alignment.INSIDE);
        strokeAlignments.put("strokeStyleAlignCenter", ShapeInfo.Alignment.CENTER);
        strokeAlignments.put("strokeStyleAlignOutside", ShapeInfo.Alignment.OUTSIDE);
    }

    private static enum LayerShadow {
        INNER("IrSh", "innerShadowMulti"),
        OUTER("DrSh", "dropShadowMulti");

        private final String mMultiName;
        private final String mName;

        private LayerShadow(String name, String multiName) {
            this.mName = name;
            this.mMultiName = multiName;
        }

        String getMultiName() {
            return this.mMultiName;
        }

        String getName() {
            return this.mName;
        }
    }
}

