/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.model.xml.BvField;
import com.intellij.beanValidation.model.xml.BvGetter;
import com.intellij.beanValidation.model.xml.Constraint;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBvXmlNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BeanNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.ConstraintNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.List;

public class BeanMemberNode
extends AbstractBvXmlNode {
    private final PsiMember myMember;
    private final XmlAttributeValue myAttrValue;
    private final DomElement myParentDomElement;

    public BeanMemberNode(GenericAttributeValue<PsiMember> name, BeanNode beanNode) {
        super(beanNode, (PsiElement)name.getValue(), (XmlElement)name.getXmlAttributeValue());
        this.myMember = (PsiMember)name.getValue();
        this.myParentDomElement = name.getParent();
        this.myAttrValue = name.getXmlAttributeValue();
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        if (this.myMember != null) {
            presentation.addText(this.myMember.getName(), this.getPlainAttributes());
            presentation.setIcon(this.myMember.getIcon(0));
        } else if (this.myAttrValue != null) {
            presentation.addText(this.myAttrValue.getText(), this.getErrorAttributes());
        }
    }

    @Override
    public SimpleNode[] getChildren() {
        List<Constraint> constraints = this.myParentDomElement instanceof BvField ? ((BvField)this.myParentDomElement).getConstraints() : (this.myParentDomElement instanceof BvGetter ? ((BvGetter)this.myParentDomElement).getConstraints() : new ArrayList<Constraint>());
        ArrayList<ConstraintNode> nodes = new ArrayList<ConstraintNode>();
        for (Constraint constraint : constraints) {
            nodes.add(new ConstraintNode(this, constraint));
        }
        return nodes.toArray(new SimpleNode[0]);
    }
}

