/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiExtensionBeanDescriptor
implements CdiBeanDescriptor<PsiMethodCallExpression> {
    private final PsiMethodCallExpression myExpression;

    public static CdiExtensionBeanDescriptor create(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            CdiExtensionBeanDescriptor.$$$reportNull$$$0(0);
        }
        return new CdiExtensionBeanDescriptor(expression);
    }

    protected CdiExtensionBeanDescriptor(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            CdiExtensionBeanDescriptor.$$$reportNull$$$0(1);
        }
        this.myExpression = expression;
    }

    @Override
    @Nullable
    public PsiType getType() {
        Set<PsiType> supportedTypes = this.getSupportedTypes();
        return supportedTypes.size() > 0 ? supportedTypes.iterator().next() : null;
    }

    @NotNull
    public Set<PsiType> getSupportedTypes() {
        Set<PsiType> types = CdiExtensionBeanDescriptor.getArgumentExpressionsTypes(CdiExtensionBeanDescriptor.findMethodCallExpression(this.myExpression, "createWith"));
        if (types.size() > 0) {
            Set<PsiType> set = types;
            if (set == null) {
                CdiExtensionBeanDescriptor.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<PsiType> set = CdiExtensionBeanDescriptor.getArgumentExpressionsTypes(CdiExtensionBeanDescriptor.findMethodCallExpression(this.myExpression, "types"));
        if (set == null) {
            CdiExtensionBeanDescriptor.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static Set<PsiType> getArgumentExpressionsTypes(@Nullable PsiMethodCallExpression methodCallExpression) {
        HashSet types = ContainerUtil.newHashSet();
        if (methodCallExpression != null && methodCallExpression.isValid()) {
            PsiExpression[] expressions;
            for (PsiExpression expression : expressions = methodCallExpression.getArgumentList().getExpressions()) {
                if (expression instanceof PsiLambdaExpression) {
                    ContainerUtil.addIfNotNull((Collection)types, (Object)CdiExtensionBeanDescriptor.getLambdaValueType((PsiLambdaExpression)expression));
                }
                if (!(expression instanceof PsiClassObjectAccessExpression)) continue;
                PsiTypeElement operandType = ((PsiClassObjectAccessExpression)expression).getOperand();
                ContainerUtil.addIfNotNull((Collection)types, (Object)operandType.getType());
            }
        }
        HashSet hashSet = types;
        if (hashSet == null) {
            CdiExtensionBeanDescriptor.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Nullable
    private static PsiType getLambdaValueType(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiElement body;
        if (lambdaExpression == null) {
            CdiExtensionBeanDescriptor.$$$reportNull$$$0(5);
        }
        if ((body = lambdaExpression.getBody()) instanceof PsiExpression) {
            return ((PsiExpression)body).getType();
        }
        if (body instanceof PsiCodeBlock) {
            for (PsiStatement statement : ((PsiCodeBlock)body).getStatements()) {
                PsiExpression returnValue;
                if (!(statement instanceof PsiReturnStatement) || (returnValue = ((PsiReturnStatement)statement).getReturnValue()) == null) continue;
                return returnValue.getType();
            }
        }
        return null;
    }

    @Nullable
    private static PsiMethodCallExpression findMethodCallExpression(@NotNull PsiMethodCallExpression expression, @NotNull String methodName) {
        PsiStatement psiStatement;
        if (expression == null) {
            CdiExtensionBeanDescriptor.$$$reportNull$$$0(6);
        }
        if (methodName == null) {
            CdiExtensionBeanDescriptor.$$$reportNull$$$0(7);
        }
        if ((psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class)) != null) {
            for (PsiMethodCallExpression psiMethodCallExpression : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)psiStatement, PsiMethodCallExpression.class)) {
                if (!methodName.equals(psiMethodCallExpression.getMethodExpression().getReferenceName())) continue;
                return psiMethodCallExpression;
            }
        }
        for (PsiElement parent = expression.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof PsiReferenceExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiMethodCallExpression) {
                if (!methodName.equals(((PsiMethodCallExpression)parent).getMethodExpression().getReferenceName())) continue;
                return (PsiMethodCallExpression)parent;
            }
            return null;
        }
        return null;
    }

    @Override
    public Set<PsiClass> getQualifiers() {
        return null;
    }

    @Override
    @Nullable
    public PsiClass getScopeType() {
        return null;
    }

    @Override
    @Nullable
    public PsiClass getDeploymentType() {
        return null;
    }

    @Override
    @NotNull
    public Set<PsiClass> getStereotypes() {
        Set<PsiClass> set = Collections.emptySet();
        if (set == null) {
            CdiExtensionBeanDescriptor.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Override
    public PsiMethodCallExpression getIdentifyingElement() {
        return this.myExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CdiExtensionBeanDescriptor)) {
            return false;
        }
        CdiExtensionBeanDescriptor that = (CdiExtensionBeanDescriptor)o;
        return Objects.equals(this.myExpression, that.myExpression);
    }

    public int hashCode() {
        return Objects.hash(this.myExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/beans/CdiExtensionBeanDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/beans/CdiExtensionBeanDescriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentExpressionsTypes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStereotypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaValueType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMethodCallExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

