/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.dependencies.edges;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.dependencies.edges.CdiEdge;
import com.intellij.cdi.dependencies.edges.CdiEdgeType;
import com.intellij.cdi.dependencies.nodes.CdiNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;

public class CdiInjectionPointEdge
implements CdiEdge {
    private final CdiNode mySource;
    private final CdiNode myTarget;
    private final InjectionPointDescriptor myInjectionPointDescriptor;
    private final boolean myUnresolved;

    public CdiInjectionPointEdge(CdiNode source, CdiNode target, InjectionPointDescriptor injectionPointDescriptor) {
        this(source, target, injectionPointDescriptor, false);
    }

    public CdiInjectionPointEdge(CdiNode source, CdiNode target, InjectionPointDescriptor injectionPointDescriptor, boolean unresolved) {
        this.mySource = source;
        this.myTarget = target;
        this.myInjectionPointDescriptor = injectionPointDescriptor;
        this.myUnresolved = unresolved;
    }

    @Override
    public CdiNode getSource() {
        return this.mySource;
    }

    @Override
    public CdiNode getTarget() {
        return this.myTarget;
    }

    public PsiElement getIdentifyingElement() {
        return this.myInjectionPointDescriptor.getOwner();
    }

    @Override
    public String getName() {
        PsiAnnotation[] psiAnnotations = this.myInjectionPointDescriptor.getQualifierAnnotations();
        StringBuffer buffer = new StringBuffer();
        for (PsiAnnotation psiAnnotation : psiAnnotations) {
            String fqName = psiAnnotation.getQualifiedName();
            if (fqName == null) continue;
            buffer.append("@");
            buffer.append(StringUtil.getShortName((String)fqName));
            buffer.append(" ");
        }
        return buffer.toString();
    }

    @Override
    public CdiEdgeType getType() {
        return CdiEdgeType.INJECTED;
    }

    @Override
    public boolean isValidDependency() {
        return !this.myUnresolved;
    }
}

