/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiInjectionPointsInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(0);
        }
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(psiClass);
        for (InjectionPointDescriptor injectionPoint : injectionPoints) {
            if (!CdiInjectionPointsInspection.isInjectionPointDefinedInClass(psiClass, injectionPoint)) continue;
            CdiInjectionPointsInspection.checkInjectionPointAmbiguousDependency(psiClass, injectionPoint, holder);
            CdiInjectionPointsInspection.checkNewAnnotationInjectionPoint(injectionPoint, holder);
        }
    }

    private static boolean isInjectionPointDefinedInClass(@NotNull PsiClass psiClass, @NotNull InjectionPointDescriptor ip) {
        if (psiClass == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(1);
        }
        if (ip == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(2);
        }
        PsiModifierListOwner owner = ip.getOwner();
        return psiClass.equals(PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class));
    }

    private static void checkNewAnnotationInjectionPoint(InjectionPointDescriptor injectionPoint, ProblemsHolder holder) {
        PsiAnnotation newAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)injectionPoint.getOwner(), (String[])new String[]{"javax.enterprise.inject.New"});
        if (newAnnotation != null) {
            for (PsiAnnotation psiAnnotation : injectionPoint.getQualifierAnnotations()) {
                String s = psiAnnotation.getQualifiedName();
                if ("javax.inject.Named".equals(s) || "javax.enterprise.inject.New".equals(s)) continue;
                holder.registerProblem((PsiElement)newAnnotation, CdiInspectionBundle.message("CdiInspectionPointsInspection.new.annotion.with.other.qualifiers", new Object[0]), new LocalQuickFix[0]);
                break;
            }
        }
    }

    private static void checkInjectionPointAmbiguousDependency(@NotNull PsiClass psiClass, @NotNull InjectionPointDescriptor injectionPoint, ProblemsHolder holder) {
        PsiType type;
        if (psiClass == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(3);
        }
        if (injectionPoint == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(4);
        }
        if ((type = injectionPoint.getType()) != null) {
            String typeCanonicalText = type.getCanonicalText();
            if (typeCanonicalText.startsWith("javax.enterprise.event.Event")) {
                return;
            }
            if (typeCanonicalText.startsWith("javax.enterprise.inject.spi.InjectionPoint") && injectionPoint.getQualifierAnnotations().length == 0) {
                return;
            }
            for (String className : CdiManager.BUILD_IN_CLASSES) {
                if (!typeCanonicalText.equals(className)) continue;
                return;
            }
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"javax.enterprise.inject.Instance")) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"javax.enterprise.inject.spi.InterceptionFactory")) {
            return;
        }
        PsiModifierListOwner owner = injectionPoint.getOwner();
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"javax.decorator.Delegate", (int)1)) {
            return;
        }
        Set<CdiBeanDescriptor> injectedBeans = CdiInjectionUtils.getInjectedBeans(injectionPoint);
        if (owner instanceof PsiVariable) {
            owner = ((PsiVariable)owner).getNameIdentifier();
        }
        if (owner == null) {
            return;
        }
        if (injectedBeans.size() == 0) {
            holder.registerProblem((PsiElement)owner, CdiInspectionBundle.message("CdiInspectionPointsInspection.unsatisfied.dependency", new Object[0]), new LocalQuickFix[0]);
        } else if (injectedBeans.size() > 1) {
            holder.registerProblem((PsiElement)owner, CdiInspectionBundle.message("CdiInspectionPointsInspection.ambiguous.dependency", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.ambiguous.dependencies", new Object[0]);
        if (string == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiInjectionPointsInspection" == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(6);
        }
        return "CdiInjectionPointsInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(7);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ip";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPoint";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiInjectionPointsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiInjectionPointsInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInjectionPointDefinedInClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkInjectionPointAmbiguousDependency";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

