/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.JavaDuplicatesMatcher;
import com.intellij.dupLocator.JavaDuplocatorSettingsEditor;
import com.intellij.dupLocator.index.DuplicatesInspection;
import com.intellij.dupLocator.resultUI.BaseDuplicatesView;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.resultUI.MethodBodyType;
import com.intellij.dupLocator.resultUI.TextFragmentType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractDuplicatesProcessor;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.JavaDuplicatesExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDuplicatesPresentation
implements DuplicatesPresentation {
    private static final Logger LOG = Logger.getInstance(JavaDuplicatesPresentation.class);
    private final JavaLanguage myLanguage = (JavaLanguage)Language.findInstance(JavaLanguage.class);
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"refactoring.extract.method.from.duplicate.code");

    @Override
    @NotNull
    public DuplicatesProfile getProfile() {
        DuplicatesProfile duplicatesProfile = DuplicatesProfile.findProfileForLanguage((Language)this.myLanguage);
        if (duplicatesProfile == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(0);
        }
        return duplicatesProfile;
    }

    @Nullable
    private static PsiClass getContainingClass(@NotNull CodeNode node) throws InvalidatedException {
        PsiFile file;
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(1);
        }
        if ((file = PsiManager.getInstance((Project)node.getProject()).findFile(node.getVirtualFile())) == null) {
            return null;
        }
        PsiElement psiElement = file.findElementAt(node.getRangeMarker().getStartOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        while (psiClass instanceof PsiAnonymousClass) {
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        }
        return psiClass;
    }

    @Nullable
    public static PsiElement getEnclosingElement(@NotNull CodeNode node) throws InvalidatedException {
        VirtualFile virtualFile;
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(2);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile(node.getRangeMarker().getDocument())) == null || !virtualFile.isValid()) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)node.getProject()).findFile(virtualFile);
        return file != null ? PsiUtil.getElementInclusiveRange((PsiElement)file, (TextRange)node.getTextRange()) : null;
    }

    @Override
    @Nullable
    public CodeFragmentType getType(@NotNull CodeNode node) throws InvalidatedException {
        PsiElement element;
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(3);
        }
        if ((element = JavaDuplicatesPresentation.getEnclosingElement(node)) == null) {
            return null;
        }
        RangeMarker rangeMarker = node.getRangeMarker();
        if (!element.getTextRange().equals((Object)node.getTextRange())) {
            return new TextFragmentType(JavaDuplicatesPresentation.getContainingClass(node), rangeMarker);
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            return new MethodBodyType((PsiMethod)parent);
        }
        return new TextFragmentType(JavaDuplicatesPresentation.getContainingClass(node), rangeMarker);
    }

    @Override
    public boolean isFixAbilityProvided() {
        return true;
    }

    @Override
    public boolean isFixAvailable(@NotNull CodeNode node) {
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(4);
        }
        try {
            PsiElement enclosingElement = JavaDuplicatesPresentation.getEnclosingElement(node);
            if (enclosingElement != null) {
                JavaDuplicatesExtractMethodProcessor processor = JavaDuplicatesPresentation.getProcessor(node.getTextRange(), enclosingElement, false);
                if (processor != null) {
                    processor.applyDefaults("newMethod", "private");
                    Set<VirtualFile> files = node.getParent().getAffectedFiles();
                    if (processor.hasDuplicates(files)) {
                        return true;
                    }
                } else {
                    PsiElement element = enclosingElement.getParent();
                    if (element instanceof PsiMethod) {
                        PsiMethod psiMethod = (PsiMethod)element;
                        if (psiMethod.getBody() == null) {
                            return false;
                        }
                        PsiManager psiManager = PsiManager.getInstance((Project)node.getProject());
                        Set<VirtualFile> files = node.getParent().getAffectedFiles();
                        for (VirtualFile virtualFile : files) {
                            if (MethodDuplicatesHandler.hasDuplicates((PsiFile)psiManager.findFile(virtualFile), (PsiMember)psiMethod).isEmpty()) continue;
                            return true;
                        }
                    }
                }
            }
        }
        catch (InvalidatedException invalidatedException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void applyFix(@NotNull CodeNode node) {
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(5);
        }
        try {
            PsiMethod psiMethod;
            Project project = node.getProject();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            GroupNode groupNode = node.getParent();
            PsiElement enclosingElement = JavaDuplicatesPresentation.getEnclosingElement(node);
            LOG.assertTrue(enclosingElement != null);
            PsiFile file = enclosingElement.getContainingFile();
            PsiElement parent = enclosingElement.getParent();
            Set<VirtualFile> affectedFiles = groupNode.getAffectedFiles();
            if (parent instanceof PsiMethod) {
                psiMethod = (PsiMethod)parent;
            } else {
                JavaDuplicatesExtractMethodProcessor processor = JavaDuplicatesPresentation.getProcessor(node.getTextRange(), enclosingElement, true);
                LOG.assertTrue(processor != null);
                if (!ExtractMethodHandler.invokeOnElements((Project)project, (ExtractMethodProcessor)processor, (PsiFile)file, (boolean)false)) {
                    return;
                }
                psiMethod = processor.getExtractedMethod();
                affectedFiles.remove(file.getVirtualFile());
            }
            if (!affectedFiles.isEmpty()) {
                MethodDuplicatesHandler.invokeOnScope((Project)project, (PsiMember)psiMethod, (AnalysisScope)new AnalysisScope(project, affectedFiles));
            }
        }
        catch (InvalidatedException e1) {
            LOG.error((Throwable)e1);
        }
    }

    @Override
    @NotNull
    public DuplicatesView createView(@NotNull Project project) {
        if (project == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(6);
        }
        BaseDuplicatesView baseDuplicatesView = new BaseDuplicatesView(project);
        if (baseDuplicatesView == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(7);
        }
        return baseDuplicatesView;
    }

    @Nullable
    private static JavaDuplicatesExtractMethodProcessor getProcessor(@NotNull TextRange textRange, @NotNull PsiElement enclosingElement, boolean interactive) {
        PsiFile file;
        PsiElement[] elements;
        if (textRange == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(8);
        }
        if (enclosingElement == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(9);
        }
        if ((elements = ExtractDuplicatesProcessor.getSegmentElements((Segment)textRange, (PsiFile)(file = enclosingElement.getContainingFile()))).length == 0) {
            return null;
        }
        Editor editor = interactive ? ExtractMethodHandler.openEditor((PsiFile)file) : null;
        JavaDuplicatesExtractMethodProcessor processor = new JavaDuplicatesExtractMethodProcessor(elements, editor, REFACTORING_NAME);
        if (processor.prepare(interactive)) {
            return processor;
        }
        return null;
    }

    @Override
    @NotNull
    public DuplocatorSettingsEditor createEditor(@NotNull DuplocatorState state) {
        if (state == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(10);
        }
        JavaDuplocatorSettingsEditor javaDuplocatorSettingsEditor = new JavaDuplocatorSettingsEditor();
        if (javaDuplocatorSettingsEditor == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(11);
        }
        return javaDuplocatorSettingsEditor;
    }

    @Override
    public LocalQuickFix createExtractMethodFix(@NotNull PsiElement targetElement, @Nullable TextRange rangeInElement, int hash, int hash2) {
        List<PsiElement[]> duplicateElements;
        JavaDuplicatesMatcher matcher;
        List<UsageInfo> duplicates;
        FileRange fileRange;
        if (targetElement == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(12);
        }
        if ((fileRange = FileRange.create(targetElement, rangeInElement)) != null && !fileRange.isEmpty() && fileRange.isExtractable() && !(duplicates = JavaDuplicatesPresentation.findDuplicates(hash, hash2, fileRange)).isEmpty() && (matcher = new JavaDuplicatesMatcher(fileRange.myElements, duplicateElements = JavaDuplicatesPresentation.getDuplicateElements(duplicates))).compare()) {
            return new ExtractMethodFix(duplicates);
        }
        return null;
    }

    @NotNull
    private static List<PsiElement[]> getDuplicateElements(List<UsageInfo> duplicates) {
        List list = StreamEx.of(duplicates).map(ExtractDuplicatesProcessor::getUsageInfoElements).nonNull().toList();
        if (list == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static List<UsageInfo> findDuplicates(int hash, int hash2, @NotNull FileRange fileRange) {
        if (fileRange == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(14);
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        Project project = fileRange.myFile.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        DuplicatesInspection.DupeUsageSearcher searcher = new DuplicatesInspection.DupeUsageSearcher(scope, hash, hash2, project);
        searcher.generate((Processor<Usage>)((Processor)usage -> {
            if (fileRange == null) {
                JavaDuplicatesPresentation.$$$reportNull$$$0(16);
            }
            UsageInfo info = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            PsiFile file = info.getFile();
            Segment segment = info.getSegment();
            if (file != null && file.isValid() && file.isWritable() && segment != null && !fileRange.equalsToRange(file, segment)) {
                usages.add(info);
            }
            return true;
        }));
        ArrayList<UsageInfo> arrayList = usages;
        if (arrayList == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/JavaDuplicatesPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/JavaDuplicatesPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicateElements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findDuplicates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFixAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createView";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProcessor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createExtractMethodFix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicates";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDuplicates$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileRange {
        final PsiFile myFile;
        final TextRange myRange;
        final PsiElement[] myElements;

        public FileRange(@NotNull PsiFile file, @NotNull TextRange range, @NotNull PsiElement[] elements) {
            if (file == null) {
                FileRange.$$$reportNull$$$0(0);
            }
            if (range == null) {
                FileRange.$$$reportNull$$$0(1);
            }
            if (elements == null) {
                FileRange.$$$reportNull$$$0(2);
            }
            this.myFile = file;
            this.myRange = range;
            this.myElements = elements;
        }

        boolean isEmpty() {
            return this.myElements.length == 0;
        }

        boolean isExtractable() {
            ExtractMethodProcessor processor = ExtractMethodHandler.getProcessor((Project)this.myFile.getProject(), (PsiElement[])this.myElements, (PsiFile)this.myFile, (boolean)false);
            if (processor != null) {
                processor.setShowErrorDialogs(false);
                try {
                    return processor.prepare();
                }
                catch (PrepareFailedException prepareFailedException) {
                    // empty catch block
                }
            }
            return false;
        }

        boolean equalsToRange(PsiFile file, Segment segment) {
            return this.myFile.equals(file) && this.myRange.equalsToRange(segment.getStartOffset(), segment.getEndOffset());
        }

        @Nullable
        static FileRange create(@NotNull PsiElement targetElement, @Nullable TextRange rangeInElement) {
            TextRange range;
            PsiFile file;
            if (targetElement == null) {
                FileRange.$$$reportNull$$$0(3);
            }
            if (targetElement instanceof PsiFile) {
                file = (PsiFile)targetElement;
                range = rangeInElement;
            } else {
                file = targetElement.getContainingFile();
                TextRange targetElementRange = targetElement.getTextRange();
                TextRange textRange = range = rangeInElement != null ? rangeInElement.shiftRight(targetElementRange.getStartOffset()) : targetElementRange;
            }
            if (file != null && range != null) {
                PsiElement[] elements = ExtractDuplicatesProcessor.getSegmentElements((Segment)range, (PsiFile)file);
                return new FileRange(file, range, elements);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dupLocator/JavaDuplicatesPresentation$FileRange";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ExtractMethodFix
    implements LocalQuickFix {
        private final List<UsageInfo> myDuplicates;

        public ExtractMethodFix(List<UsageInfo> duplicates) {
            this.myDuplicates = duplicates;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = REFACTORING_NAME;
            if (string == null) {
                ExtractMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ExtractMethodFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ExtractMethodFix.$$$reportNull$$$0(2);
            }
            PsiElement targetElement = descriptor.getPsiElement();
            TextRange rangeInElement = descriptor.getTextRangeInElement();
            if (targetElement == null) {
                return;
            }
            FileRange fileRange = FileRange.create(targetElement, rangeInElement);
            if (fileRange != null && !fileRange.isEmpty()) {
                List duplicateElements = JavaDuplicatesPresentation.getDuplicateElements(this.myDuplicates);
                List prepareForWrite = StreamEx.of((Collection)duplicateElements).append((Object)fileRange.myElements).map(elements -> elements[0]).toList();
                if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)prepareForWrite)) {
                    return;
                }
                JavaDuplicatesMatcher matcher = new JavaDuplicatesMatcher(fileRange.myElements, duplicateElements);
                if (matcher.compare()) {
                    matcher.extract();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/JavaDuplicatesPresentation$ExtractMethodFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/JavaDuplicatesPresentation$ExtractMethodFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

