/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenEditorTabTitleUpdater
extends MavenSimpleProjectComponent
implements BaseComponent {
    public MavenEditorTabTitleUpdater(Project project) {
        super(project);
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        MavenProjectsManager.getInstance(this.myProject).addProjectsTreeListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
                MavenEditorTabTitleUpdater.this.updateTabName(MavenUtil.collectFirsts(updated));
            }
        });
    }

    private void updateTabName(List<MavenProject> projects) {
        MavenUtil.invokeLater(this.myProject, () -> {
            for (MavenProject each : projects) {
                FileEditorManagerEx.getInstanceEx((Project)this.myProject).updateFilePresentation(each.getFile());
            }
        });
    }
}

