/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<PsiComment> VTLVARIABLE_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(VtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@vtlvariable "));
    public static final PsiElementPattern.Capture<PsiComment> VTLMACROLIBRARY_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(VtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@vtlmacrolibrary "));
    public static final PsiElementPattern.Capture<PsiComment> VELOCITY_PROPERTIES_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(VtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@velocityproperties "));

    static boolean isSpecialComment(PsiComment comment) {
        return VTLVARIABLE_COMMENT.accepts((Object)comment) || VTLMACROLIBRARY_COMMENT.accepts((Object)comment) || VELOCITY_PROPERTIES_COMMENT.accepts((Object)comment);
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            VtlReferenceContributor.$$$reportNull$$$0(0);
        }
        this.registerImplicitVariableProvider(registrar);
        this.registerExternalMacroLibraryProvider(registrar);
        this.registerVelocityPropertiesProvider(registrar);
    }

    private void registerImplicitVariableProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(VTLVARIABLE_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = VtlReferenceContributor.getReferencesToJavaTypes(element);
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/velocity/VtlReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/velocity/VtlReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        registrar.registerReferenceProvider(VTLVARIABLE_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                String text;
                TextRange range;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((range = PsiUtil.findRange(text = element.getText(), "name=\"", "\"")) == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String name = range.substring(text);
                TextRange filePathRange = PsiUtil.findRange(text, "file=\"", "\"");
                String scopeFilePath = filePathRange == null ? null : filePathRange.substring(text);
                final VtlImplicitVariable variable = ((VtlFile)element.getContainingFile()).findImplicitVariable(name, scopeFilePath);
                if (variable == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReferenceBase<PsiComment> ref = new PsiReferenceBase<PsiComment>((PsiComment)element, TextRange.from((int)range.getStartOffset(), (int)name.length())){

                    public PsiElement resolve() {
                        return variable;
                    }

                    @NotNull
                    public Object[] getVariants() {
                        if (EMPTY_ARRAY == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return EMPTY_ARRAY;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlReferenceContributor$2$1", "getVariants"));
                    }
                };
                SmartList result = new SmartList();
                result.add(ref);
                VtlReferenceContributor.findAndAddReferencesByElement(element, "file=\"", "\"", (Collection)result);
                PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/velocity/VtlReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/velocity/VtlReferenceContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private void registerExternalMacroLibraryProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(VTLMACROLIBRARY_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                SmartList result;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (VtlReferenceContributor.findAndAddReferencesByElement(element, "path=\"", "\"", (Collection)(result = new SmartList()))) {
                    VtlReferenceContributor.findAndAddReferencesByElement(element, "file=\"", "\"", (Collection)result);
                }
                PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/velocity/VtlReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/velocity/VtlReferenceContributor$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private void registerVelocityPropertiesProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(VELOCITY_PROPERTIES_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                SmartList result;
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (VtlReferenceContributor.findAndAddReferencesByElement(element, "path=\"", "\"", (Collection)(result = new SmartList()))) {
                    VtlReferenceContributor.findAndAddReferencesByElement(element, "runtime_root=\"", "\"", (Collection)result);
                    VtlReferenceContributor.findAndAddReferencesByElement(element, "file=\"", "\"", (Collection)result);
                }
                PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    4.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/velocity/VtlReferenceContributor$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/velocity/VtlReferenceContributor$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean findAndAddReferencesByElement(@NotNull PsiElement element, @NotNull String startMarker, @NotNull String endMarker, @NotNull Collection<PsiReference> collection) {
        String text;
        TextRange range;
        if (element == null) {
            VtlReferenceContributor.$$$reportNull$$$0(1);
        }
        if (startMarker == null) {
            VtlReferenceContributor.$$$reportNull$$$0(2);
        }
        if (endMarker == null) {
            VtlReferenceContributor.$$$reportNull$$$0(3);
        }
        if (collection == null) {
            VtlReferenceContributor.$$$reportNull$$$0(4);
        }
        if ((range = PsiUtil.findRange(text = element.getText(), startMarker, endMarker)) == null) {
            return false;
        }
        String filePath = range.substring(text);
        FileReference[] fileReferences = PsiUtil.getFileReferences(filePath, element, range.getStartOffset(), false);
        return collection.addAll(Arrays.asList(fileReferences));
    }

    public static PsiReference[] getReferencesToJavaTypes(PsiElement element) {
        String text = element.getText();
        TextRange range = VtlReferenceContributor.findTypeNameRange(text);
        if (range == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        return provider.getReferencesByString(range.substring(text), element, range.getStartOffset());
    }

    @Nullable
    public static TextRange findTypeNameRange(@NotNull String text) {
        if (text == null) {
            VtlReferenceContributor.$$$reportNull$$$0(5);
        }
        return PsiUtil.findRange(text, "type=\"", "\"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startMarker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endMarker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/VtlReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndAddReferencesByElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findTypeNameRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

