/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.DbOperationDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.containers.JBIterable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolActions {
    @NotNull
    public static JBIterable<PsiElement> getSelectedElements(@NotNull DataContext dataContext) {
        PsiElement element;
        if (dataContext == null) {
            ToolActions.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiReference ref = editor == null || file == null ? null : file.findReferenceAt(editor.getCaretModel().getOffset());
        PsiElement psiElement = element = ref != null && ref.getElement() instanceof SqlElement ? ref.resolve() : null;
        if (element != null) {
            JBIterable jBIterable = JBIterable.of((Object)element);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)));
        if (jBIterable == null) {
            ToolActions.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ToolActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ToolActions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RefreshMatViewAction
    extends ToolActionBase {
        public RefreshMatViewAction() {
            super("Refresh Materialized View", "_Refresh Materialized View", "Refresh selected materialized views", AllIcons.Actions.ForceRefresh);
        }

        @Override
        protected boolean isSupported(@NotNull DatabaseDialectEx dialect) {
            if (dialect == null) {
                RefreshMatViewAction.$$$reportNull$$$0(0);
            }
            return RefreshMatViewAction.hasOperation(dialect, DasDdlOperations.REFRESH_MATERIALIZED_VIEW);
        }

        @Override
        @NotNull
        protected JBIterable<? extends DbElement> getObjects(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshMatViewAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = super.getObjects(e).filter(DbElement.class).filter(DasUtil.byKind((ObjectKind)ObjectKind.MAT_VIEW));
            if (jBIterable == null) {
                RefreshMatViewAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected DbOperationDialog createDialog(@NotNull DatabaseEditorContext context, @NotNull JBIterable<? extends DbElement> selection) {
            if (context == null) {
                RefreshMatViewAction.$$$reportNull$$$0(3);
            }
            if (selection == null) {
                RefreshMatViewAction.$$$reportNull$$$0(4);
            }
            DbOperationDialog dbOperationDialog = DbOperationDialog.createDialog(context, selection, new DdlOperation[]{DasDdlOperations.REFRESH_MATERIALIZED_VIEW});
            if (dbOperationDialog == null) {
                RefreshMatViewAction.$$$reportNull$$$0(5);
            }
            return dbOperationDialog;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ToolActions$RefreshMatViewAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ToolActions$RefreshMatViewAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjects";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDialog";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TruncateTablesAction
    extends ToolActionBase {
        public TruncateTablesAction() {
            super("Truncate Table", "_Truncate", "Truncate selected tables", AllIcons.Actions.GC);
        }

        @Override
        protected boolean isSupported(@NotNull DatabaseDialectEx dialect) {
            if (dialect == null) {
                TruncateTablesAction.$$$reportNull$$$0(0);
            }
            return TruncateTablesAction.hasOperation(dialect, DasDdlOperations.TRUNCATE_TABLE);
        }

        @Override
        @NotNull
        protected JBIterable<? extends DbElement> getObjects(@NotNull AnActionEvent e) {
            if (e == null) {
                TruncateTablesAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = super.getObjects(e).filter(DbTable.class).filter(DasUtil.byKind((ObjectKind)ObjectKind.TABLE));
            if (jBIterable == null) {
                TruncateTablesAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected DbOperationDialog createDialog(@NotNull DatabaseEditorContext context, @NotNull JBIterable<? extends DbElement> selection) {
            if (context == null) {
                TruncateTablesAction.$$$reportNull$$$0(3);
            }
            if (selection == null) {
                TruncateTablesAction.$$$reportNull$$$0(4);
            }
            DbOperationDialog dbOperationDialog = DbOperationDialog.createDialog(context, selection, new DdlOperation[]{DasDdlOperations.TRUNCATE_TABLE});
            if (dbOperationDialog == null) {
                TruncateTablesAction.$$$reportNull$$$0(5);
            }
            return dbOperationDialog;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ToolActions$TruncateTablesAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ToolActions$TruncateTablesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjects";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDialog";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ToolActionBase
    extends DumbAwareAction {
        private final String myTitle;

        public ToolActionBase(@NotNull String title, @Nullable String text, @Nullable String description, @Nullable Icon icon) {
            if (title == null) {
                ToolActionBase.$$$reportNull$$$0(0);
            }
            super(text, description, icon);
            this.myTitle = title;
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<? extends DbElement> objects;
            DbElement selected;
            if (e == null) {
                ToolActionBase.$$$reportNull$$$0(1);
            }
            boolean visible = (selected = (DbElement)(objects = this.getObjects(e)).first()) != null && DbImplUtil.canConnectTo(selected) && this.isSupported(DbImplUtil.getDatabaseDialect(selected));
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify(selected));
        }

        protected abstract boolean isSupported(@NotNull DatabaseDialectEx var1);

        protected static boolean hasOperation(@NotNull DatabaseDialectEx dialect, @NotNull DdlOperation op) {
            if (dialect == null) {
                ToolActionBase.$$$reportNull$$$0(2);
            }
            if (op == null) {
                ToolActionBase.$$$reportNull$$$0(3);
            }
            return dialect.getSchemaEditor().getDdlOperations().get(op) != null;
        }

        @NotNull
        protected JBIterable<? extends DbElement> getObjects(@NotNull AnActionEvent e) {
            if (e == null) {
                ToolActionBase.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = ToolActions.getSelectedElements(e.getDataContext()).filter(DbElement.class);
            if (jBIterable == null) {
                ToolActionBase.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable<? extends DbElement> selection;
            DbElement first;
            if (e == null) {
                ToolActionBase.$$$reportNull$$$0(6);
            }
            if ((first = (DbElement)(selection = this.getObjects(e)).first()) == null) {
                return;
            }
            DatabaseEditorContext context = new DatabaseEditorContext(first, null);
            DbOperationDialog dialog = this.createDialog(context, selection);
            dialog.setTitle(this.myTitle);
            dialog.show();
        }

        @NotNull
        protected abstract DbOperationDialog createDialog(@NotNull DatabaseEditorContext var1, @NotNull JBIterable<? extends DbElement> var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "op";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ToolActions$ToolActionBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ToolActions$ToolActionBase";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "hasOperation";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjects";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

