/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DownloadedDriversHolder;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcDriversMappings {
    private static final Map<String, JdbcMapping> ourClassMappings = ContainerUtil.newHashMap();
    public static final SqliteMapping SQLITE = new SqliteMapping();
    public static final MysqlMapping MYSQL = new MysqlMapping();
    public static final PostgresqlMapping POSTGRES = new PostgresqlMapping();
    public static final H2Mapping H2 = new H2Mapping();
    public static final OracleMapping ORACLE = new OracleMapping();
    public static final SqlServerMapping SQL_SERVER = new SqlServerMapping();

    private JdbcDriversMappings() {
    }

    @Nullable
    public static JdbcMapping findMappingByDatabaseName(@NotNull String databaseName) {
        if (databaseName == null) {
            JdbcDriversMappings.$$$reportNull$$$0(0);
        }
        for (JdbcMapping mapping : ourClassMappings.values()) {
            String mappingName = mapping.getClass().getSimpleName();
            if (!StringUtil.startsWithIgnoreCase((String)mappingName, (String)databaseName)) continue;
            return mapping;
        }
        return null;
    }

    @Nullable
    public static JdbcMapping findMappingByConnectionInfo(RawConnectionConfig info) {
        String[] split;
        JdbcMapping mapping;
        String driverClass = info.getDriverClass();
        if (!StringUtil.isEmptyOrSpaces((String)driverClass) && (mapping = ourClassMappings.get(driverClass)) != null) {
            return mapping;
        }
        String url = info.getUrl();
        if (!StringUtil.isEmptyOrSpaces((String)url) && (split = url.split(":")).length > 2) {
            return JdbcDriversMappings.findMappingByDatabaseName(split[1]);
        }
        return null;
    }

    public static String replaceLocalhost(@NotNull Object host) {
        String hostname;
        if (host == null) {
            JdbcDriversMappings.$$$reportNull$$$0(1);
        }
        return "localhost".equals(hostname = host.toString()) ? "127.0.0.1" : hostname;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/autoconfig/JdbcDriversMappings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMappingByDatabaseName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceLocalhost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class H2Mapping
    extends FileBasedMapping {
        private H2Mapping() {
        }

        @Override
        @NotNull
        public String getDriverClass() {
            if ("org.h2.Driver" == null) {
                H2Mapping.$$$reportNull$$$0(0);
            }
            return "org.h2.Driver";
        }

        @Override
        public String getArtifactName() {
            return "H2 JDBC";
        }

        @Override
        protected String composeJdbcUrl(File dbFile) {
            return "jdbc:h2:" + StringUtil.trimEnd((String)dbFile.getPath(), (String)".h2.db");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/autoconfig/JdbcDriversMappings$H2Mapping", "getDriverClass"));
        }
    }

    private static class SqliteMapping
    extends FileBasedMapping {
        private SqliteMapping() {
        }

        @Override
        @NotNull
        public String getDriverClass() {
            if ("org.sqlite.JDBC" == null) {
                SqliteMapping.$$$reportNull$$$0(0);
            }
            return "org.sqlite.JDBC";
        }

        @Override
        public String getArtifactName() {
            return "Xerial SQLiteJDBC";
        }

        @Override
        public boolean isUpToDate(VirtualFile file) {
            return !StringUtil.containsIgnoreCase((String)file.getName(), (String)"zentus");
        }

        @Override
        protected String composeJdbcUrl(File dbFile) {
            return "jdbc:sqlite:" + dbFile.getPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/autoconfig/JdbcDriversMappings$SqliteMapping", "getDriverClass"));
        }
    }

    private static abstract class FileBasedMapping
    extends JdbcMapping {
        private FileBasedMapping() {
        }

        @Override
        public void createDataSource(PsiElement origin, String type, String key2, DataSourceConfiguration configuration, DataSourceDetector.Builder builder) {
            VirtualFile root2;
            String database = configuration.getDatabase();
            if (database == null) {
                return;
            }
            File dbFile = new File(database);
            if (!dbFile.exists() && (root2 = configuration.getApplicationRoot()) != null) {
                dbFile = new File(root2.getPath(), database);
            }
            if (dbFile.isFile()) {
                this.createSource(origin, type, key2, builder, this.composeJdbcUrl(dbFile), "", "");
            }
        }

        protected abstract String composeJdbcUrl(File var1);
    }

    private static class SqlServerMapping
    extends JdbcMapping {
        private SqlServerMapping() {
        }

        @Override
        @NotNull
        public String getDriverClass() {
            if ("com.microsoft.sqlserver.jdbc.SQLServerDriver" == null) {
                SqlServerMapping.$$$reportNull$$$0(0);
            }
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }

        @Override
        public String getArtifactName() {
            return "SQL Server";
        }

        @Override
        public void createDataSource(PsiElement origin, String type, String key2, DataSourceConfiguration configuration, DataSourceDetector.Builder builder) {
            String database = configuration.getDatabase();
            String host = configuration.getHost();
            String port = configuration.getPort();
            String userName = configuration.getUserName();
            String password = configuration.getPassword();
            if (database != null) {
                host = host != null ? host : "localhost";
                String url = "jdbc:sqlserver://" + JdbcDriversMappings.replaceLocalhost(host);
                if (port != null && !StringUtil.isEmpty((String)port)) {
                    url = url + ":" + port;
                }
                url = url + "/" + database;
                this.createSource(origin, type, key2, builder, url, userName, password);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/autoconfig/JdbcDriversMappings$SqlServerMapping", "getDriverClass"));
        }
    }

    private static class MysqlMapping
    extends JdbcMapping {
        private MysqlMapping() {
        }

        @Override
        @NotNull
        public String getDriverClass() {
            if ("com.mysql.jdbc.Driver" == null) {
                MysqlMapping.$$$reportNull$$$0(0);
            }
            return "com.mysql.jdbc.Driver";
        }

        @Override
        public String getArtifactName() {
            return "MySQL Connector/J";
        }

        @Override
        public void createDataSource(PsiElement origin, String type, String key2, DataSourceConfiguration configuration, DataSourceDetector.Builder builder) {
            String database = configuration.getDatabase();
            String host = configuration.getHost();
            String socket = configuration.getOption("socket");
            String port = configuration.getPort();
            String userName = configuration.getUserName();
            String password = configuration.getPassword();
            if (database != null && (host != null || socket == null)) {
                host = host != null ? host : "localhost";
                String url = "jdbc:mysql://" + JdbcDriversMappings.replaceLocalhost(host);
                if (port != null && !StringUtil.isEmpty((String)port)) {
                    url = url + ":" + port;
                }
                url = url + "/" + database;
                this.createSource(origin, type, key2, builder, url, userName, password);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/autoconfig/JdbcDriversMappings$MysqlMapping", "getDriverClass"));
        }
    }

    private static class OracleMapping
    extends JdbcMapping {
        private OracleMapping() {
        }

        @Override
        @NotNull
        public String getDriverClass() {
            if ("oracle.jdbc.OracleDriver" == null) {
                OracleMapping.$$$reportNull$$$0(0);
            }
            return "oracle.jdbc.OracleDriver";
        }

        @Override
        public String getArtifactName() {
            return "Oracle";
        }

        @Override
        public void createDataSource(PsiElement origin, String type, String databaseName, DataSourceConfiguration configuration, DataSourceDetector.Builder builder) {
            String database = configuration.getDatabase();
            String host = configuration.getHost();
            String port = configuration.getPort();
            String userName = configuration.getUserName();
            String password = configuration.getPassword();
            if (database != null) {
                StringBuilder url = new StringBuilder("jdbc:oracle:thin:@");
                if (!StringUtil.isEmpty((String)host) || !StringUtil.isEmpty((String)port)) {
                    url.append("//");
                    host = host != null ? host : "localhost";
                    url.append(JdbcDriversMappings.replaceLocalhost(host));
                    if (port != null && !StringUtil.isEmpty((String)port)) {
                        url.append(":").append(port);
                    }
                    url.append("/");
                }
                url.append(database);
                this.createSource(origin, type, databaseName, builder, url.toString(), userName, password);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/autoconfig/JdbcDriversMappings$OracleMapping", "getDriverClass"));
        }
    }

    private static class PostgresqlMapping
    extends JdbcMapping {
        private PostgresqlMapping() {
        }

        @Override
        @NotNull
        public String getDriverClass() {
            if ("org.postgresql.Driver" == null) {
                PostgresqlMapping.$$$reportNull$$$0(0);
            }
            return "org.postgresql.Driver";
        }

        @Override
        public String getArtifactName() {
            return "PostgreSQL";
        }

        @Override
        public void createDataSource(PsiElement origin, String type, String databaseName, DataSourceConfiguration configuration, DataSourceDetector.Builder builder) {
            String database = configuration.getDatabase();
            String host = configuration.getHost();
            String port = configuration.getPort();
            String userName = configuration.getUserName();
            String password = configuration.getPassword();
            if (database != null) {
                StringBuilder url = new StringBuilder("jdbc:postgresql:");
                if (!StringUtil.isEmpty((String)host) || !StringUtil.isEmpty((String)port)) {
                    url.append("//");
                    host = host != null ? host : "localhost";
                    url.append(JdbcDriversMappings.replaceLocalhost(host));
                    if (port != null && !StringUtil.isEmpty((String)port)) {
                        url.append(":").append(port);
                    }
                    url.append("/");
                }
                url.append(database);
                this.createSource(origin, type, databaseName, builder, url.toString(), userName, password);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/autoconfig/JdbcDriversMappings$PostgresqlMapping", "getDriverClass"));
        }
    }

    public static abstract class JdbcMapping {
        protected JdbcMapping() {
            ourClassMappings.put(this.getDriverClass(), this);
        }

        @NotNull
        public abstract String getDriverClass();

        public abstract String getArtifactName();

        public boolean isUpToDate(VirtualFile file) {
            return true;
        }

        public abstract void createDataSource(PsiElement var1, String var2, String var3, DataSourceConfiguration var4, DataSourceDetector.Builder var5);

        protected void createSource(PsiElement origin, String type, String databaseName, DataSourceDetector.Builder builder, String url, String userName, String password) {
            builder.withName(databaseName).withDriverClass(this.getDriverClass()).withUser(userName).withPassword(password).withUrl(url);
            DownloadedDriversHolder driversHolder = DownloadedDriversHolder.getInstance();
            if (driversHolder.isDownloaded(this)) {
                String[] driverFileUrls;
                for (String driverFileUrl : driverFileUrls = driversHolder.getDownloaded(this.getDriverClass())) {
                    VirtualFile vFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(driverFileUrl);
                    if (vFile == null || vFile.getFileSystem() instanceof JarFileSystem && (vFile = JarFileSystem.getInstance().getVirtualFileForJar(vFile)) == null) continue;
                    builder.withDriverPath(vFile.getPath());
                }
            }
            builder.commit(type, (Object)origin);
        }
    }
}

