/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.dump.mysql;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.MysqlConfigurationBase;
import com.intellij.database.cli.dump.mysql.MysqldumpArguments;
import com.intellij.database.cli.dump.mysql.MysqldumpArgumentsGroup;
import com.intellij.database.cli.dump.mysql.MysqldumpDialogValidator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqldumpConfiguration
extends MysqlConfigurationBase {
    public static final MysqldumpConfiguration INSTANCE = new MysqldumpConfiguration();

    private MysqldumpConfiguration() {
        super(MysqldumpArgumentsGroup.values(), MysqldumpArguments.RESULT_FILE, "MYSQL_PROPERTIES", "mysqldump");
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        String path = super.getDefaultSearchPath();
        return path == null ? null : path + "/mysqldump";
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(0);
        }
        List<String> result2 = super.tweakAutocompletion(variants);
        ContainerUtil.removeAll(result2, (Object[])new String[]{"--databases="});
        ContainerUtil.addAll(result2, (Iterable)ContainerUtil.filter((Object[])MysqldumpArguments.DATABASES, s -> !s.endsWith("=")));
        List<String> list = result2;
        if (list == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public String sanitizeArguments(@NotNull Collection<DbElement> elements, @NotNull String text) {
        List tables;
        if (elements == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(2);
        }
        if (text == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(3);
        }
        List databases = ContainerUtil.filter(elements, (Condition)DasUtil.byClass(DbNamespaceImpl.class));
        String sanitized = super.sanitizeArguments(elements, text);
        List<CliLexeme> lexemes = MysqldumpConfiguration.removeAll(DbCliUtil.rawLexemes(sanitized), MysqldumpArguments.ALL_DATABASES);
        if (ContainerUtil.getFirstItem(elements) instanceof DbDataSource) {
            lexemes = MysqldumpConfiguration.removeAll(lexemes, "--tables");
            lexemes = MysqldumpConfiguration.removeAll(lexemes, MysqldumpArguments.DATABASES);
            lexemes = MysqldumpConfiguration.addAll(lexemes, sanitized, DbCliUtil.extractNonParameterizable(MysqldumpArguments.ALL_DATABASES));
            String string = MysqldumpConfiguration.getCommand(lexemes);
            if (string == null) {
                MysqldumpConfiguration.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (databases.size() > 1) {
            lexemes = MysqldumpConfiguration.removeAll(lexemes, "--tables");
            lexemes = MysqldumpConfiguration.removeAll(lexemes, MysqldumpArguments.DATABASES);
            lexemes = MysqldumpConfiguration.addAll(lexemes, sanitized, DbCliUtil.extractNonParameterizable(MysqldumpArguments.DATABASES));
        }
        if ((tables = ContainerUtil.filter(elements, (Condition)DasUtil.byClass(DbTable.class))).size() > 0 && ContainerUtil.find(lexemes, DbCliUtil.lexemeFinder(MysqldumpArguments.DATABASES)) != null) {
            lexemes = MysqldumpConfiguration.removeAll(lexemes, "--tables");
            lexemes = MysqldumpConfiguration.addAll(lexemes, sanitized, "--tables");
        }
        String string = MysqldumpConfiguration.getCommand(lexemes);
        if (string == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getCommand(List<CliLexeme> lexemes) {
        String string = StringUtil.join(lexemes, CliLexeme::getText, (String)"");
        if (string == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = super.getObjectsPreparer().mapAppend((Function<DbElement, DbElement>)((Function)e -> (DbElement)DasUtil.getParentOfKind((DasObject)e, (ObjectKind)ObjectKind.SCHEMA, (boolean)false))).mapAppend((Function<DbElement, DbElement>)((Function)e -> (DbElement)DasUtil.getParentOfKind((DasObject)e, (ObjectKind)ObjectKind.DATABASE, (boolean)false))).onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).filter(ObjectKind.DATABASE).finish().endIf().onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).filter(ObjectKind.SCHEMA).finish().endIf().finish();
        if (databaseObjectsPreparer == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(7);
        }
        return databaseObjectsPreparer;
    }

    @Override
    @NotNull
    public CliConfiguration.Operation getOperation() {
        CliConfiguration.Operation operation = CliConfiguration.Operation.DUMP;
        if (operation == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(8);
        }
        return operation;
    }

    @Override
    @NotNull
    public CliDialogValidator getValidator() {
        MysqldumpDialogValidator mysqldumpDialogValidator = new MysqldumpDialogValidator();
        if (mysqldumpDialogValidator == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(9);
        }
        return mysqldumpDialogValidator;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List list = ContainerUtil.concat((List)ContainerUtil.list((Object[])new String[]{"-T", "w", "-r", "-S"}), super.getParameterizableArguments());
        if (list == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public String getPartOfValidationOut() {
        if ("mysqldump" == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(11);
        }
        return "mysqldump";
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        Map<String, String> map = super.getInfoMap();
        MysqldumpConfiguration.put(map, "Add DROP DATABASE statements", "--add-drop-database");
        MysqldumpConfiguration.put(map, "Add DROP TABLE statements", "--add-drop-table");
        MysqldumpConfiguration.put(map, "Add DROP TRIGGER statements", "--add-drop-trigger");
        MysqldumpConfiguration.put(map, "Add LOCK/UNLOCK TABLES statements", "--add-locks");
        MysqldumpConfiguration.put(map, "Dump all databases", MysqldumpArguments.ALL_DATABASES);
        MysqldumpConfiguration.put(map, "Add statements for NDBCLUSTER table", MysqldumpArguments.ALL_TABLESPACES);
        MysqldumpConfiguration.put(map, "Permit keywords column names", "--allow-keywords");
        MysqldumpConfiguration.put(map, "For dump produced with --dump-slave", "--apply-slave-statements");
        MysqldumpConfiguration.put(map, "Directory with character sets", MysqldumpArguments.CHAR_SETS_DIR);
        MysqldumpConfiguration.put(map, "Produce more compact output", "--compact");
        MysqldumpConfiguration.put(map, "Produce more other databases compatible output", MysqldumpArguments.COMPATIBLE);
        MysqldumpConfiguration.put(map, "Inserts with column names", MysqldumpArguments.INSERTS_WITH_COLUMNS);
        MysqldumpConfiguration.put(map, "The shared-memory name to use", MysqldumpArguments.SHARED_MEMORY_NAME);
        MysqldumpConfiguration.put(map, "Sets default_character_set", "--set-charset");
        MysqldumpConfiguration.put(map, "CREATE TABLE statements with options", MysqldumpArguments.CREATE_OPTIONS);
        MysqldumpConfiguration.put(map, "Dump several databases", MysqldumpArguments.DATABASES);
        MysqldumpConfiguration.put(map, "Use charset_name as the default character set", MysqldumpArguments.DEFAULT_CHAR_SET);
        MysqldumpConfiguration.put(map, "Second options file", MysqldumpArguments.DEFAULT_EXTRA_FILE);
        MysqldumpConfiguration.put(map, "INSERT DELAYED statements", "--delayed-insert");
        MysqldumpConfiguration.put(map, "PURGE BINARY LOGS statement after dump", "--delete-master-logs");
        MysqldumpConfiguration.put(map, "Disable keys before insert", MysqldumpArguments.DISABLE_KEYS);
        MysqldumpConfiguration.put(map, "Comment with date at the end of the dump", "--dump-date");
        MysqldumpConfiguration.put(map, "Uses a replication slave server", MysqldumpArguments.DUMP_SLAVE);
        MysqldumpConfiguration.put(map, "Include Event Scheduler events", MysqldumpArguments.EVENTS);
        MysqldumpConfiguration.put(map, "Multiple-row inserts", MysqldumpArguments.EXTENDED_INSERTS);
        MysqldumpConfiguration.put(map, "Fields enclose string", MysqldumpArguments.FIELDS_ENCLOSED_BY);
        MysqldumpConfiguration.put(map, "Fields escape string", MysqldumpArguments.FIELDS_ESCAPED_BY);
        MysqldumpConfiguration.put(map, "Optionally fields enclose string", MysqldumpArguments.FIELDS_OPT_ENCLOSED_BY);
        MysqldumpConfiguration.put(map, "Fields separator", MysqldumpArguments.FIELDS_TERMINATED_BY);
        MysqldumpConfiguration.put(map, "Lock all tables (Deprecated)", "--first-slave");
        MysqldumpConfiguration.put(map, "Flush server log files before dump", MysqldumpArguments.FLUSH_LOGS);
        MysqldumpConfiguration.put(map, "Add a FLUSH PRIVILEGES statement", "--flush-privileges");
        MysqldumpConfiguration.put(map, "Hexadecimal notation for blobs", "--hex-blob");
        MysqldumpConfiguration.put(map, "For the CHANGE MASTER TO statement in a slave dump", "--include-master-host-port");
        MysqldumpConfiguration.put(map, "Do not dump the given table", MysqldumpArguments.IGNORE_TABLE);
        MysqldumpConfiguration.put(map, "INSERT IGNORE statements", MysqldumpArguments.INSERT_IGNORE);
        MysqldumpConfiguration.put(map, "Line separator", MysqldumpArguments.LINES_TERMINATED_BY);
        MysqldumpConfiguration.put(map, "Lock all tables", MysqldumpArguments.LOCK_ALL_TABLES);
        MysqldumpConfiguration.put(map, "Lock all tables to be dumped", MysqldumpArguments.LOCK_TABLES);
        MysqldumpConfiguration.put(map, "Log warnings and errors", MysqldumpArguments.LOG_ERROR);
        MysqldumpConfiguration.put(map, "Dump a master replication server", MysqldumpArguments.MASTER_DATA);
        MysqldumpConfiguration.put(map, "Turn off autocommit and add COMMIT statements", "--no-autocommit");
        MysqldumpConfiguration.put(map, "Suppress the CREATE DATABASE statements", MysqldumpArguments.NO_CREATE_DB);
        MysqldumpConfiguration.put(map, "Do not write CREATE TABLE statements", MysqldumpArguments.NO_CREATE_INFO);
        MysqldumpConfiguration.put(map, "Do not dump table contents", MysqldumpArguments.NO_DATA);
        MysqldumpConfiguration.put(map, "Write SET NAMES default_character_set to the output", MysqldumpArguments.NO_SET_NAMES);
        MysqldumpConfiguration.put(map, "Exclude CREATE LOGFILE GROUP and CREATE TABLESPACE", MysqldumpArguments.NO_TABLESPACES);
        MysqldumpConfiguration.put(map, "Shortcut for default options", "--opt");
        MysqldumpConfiguration.put(map, "Sort rows by its primary key or first unique index", "--order-by-primary");
        MysqldumpConfiguration.put(map, "Connect to the server using a named pipe (Windows)", MysqldumpArguments.PIPE);
        MysqldumpConfiguration.put(map, "Quote identifiers", MysqldumpArguments.QUOTE_NAMES);
        MysqldumpConfiguration.put(map, "REPLACE statements", "--replace");
        MysqldumpConfiguration.put(map, "Direct output to the named file", MysqldumpArguments.RESULT_FILE);
        MysqldumpConfiguration.put(map, "Include stored routines", MysqldumpArguments.ROUTINES);
        MysqldumpConfiguration.put(map, "Set REPEATABLE READ isolation mode", "--single-transaction");
        MysqldumpConfiguration.put(map, "Write host, program and server version", "--skip-comments");
        MysqldumpConfiguration.put(map, "Dump only selected by WHERE condition rows", MysqldumpArguments.WHERE);
        MysqldumpConfiguration.put(map, "Disable --opt option", "--skip-opt");
        MysqldumpConfiguration.put(map, "Directory for tab-separated files", MysqldumpArguments.TAB);
        MysqldumpConfiguration.put(map, "Override --databases option", "--tables");
        MysqldumpConfiguration.put(map, "Include triggers", "--triggers");
        MysqldumpConfiguration.put(map, "Set connection time zone to UTC", "--tz-utc");
        MysqldumpConfiguration.put(map, "Add 'SET @@GLOBAL.GTID_PURGED' to the output", MysqldumpArguments.SET_GTID_PURGED);
        MysqldumpConfiguration.put(map, "Disable --add-drop-table", MysqldumpArguments.SKIP_ADD_DROP_TABLE);
        MysqldumpConfiguration.put(map, "Disable --add-locks", MysqldumpArguments.SKIP_ADD_LOCKS);
        MysqldumpConfiguration.put(map, "Disable --create-options", MysqldumpArguments.SKIP_CREATE_OPTIONS);
        MysqldumpConfiguration.put(map, "Disable --disable-keys", MysqldumpArguments.SKIP_DISABLE_KEYS);
        MysqldumpConfiguration.put(map, "Disable --dump-date", MysqldumpArguments.SKIP_DUMP_DATE);
        MysqldumpConfiguration.put(map, "Disable --extended-inserts", MysqldumpArguments.SKIP_EXTENDED_INSERTS);
        MysqldumpConfiguration.put(map, "Disable --lock-tables", MysqldumpArguments.SKIP_LOCK_TABLES);
        MysqldumpConfiguration.put(map, "Disable --quote-names", MysqldumpArguments.SKIP_QUOTE_NAMES);
        MysqldumpConfiguration.put(map, "Disable --set-charset", MysqldumpArguments.SKIP_SET_CHARSET);
        MysqldumpConfiguration.put(map, "Disable --triggers", MysqldumpArguments.SKIP_TRIGGERS);
        MysqldumpConfiguration.put(map, "Disable --tz-utc", MysqldumpArguments.SKIP_TZ_UTC);
        MysqldumpConfiguration.put(map, "Error numbers to be ignored", MysqldumpArguments.IGNORE_ERROR);
        Map<String, String> map2 = map;
        if (map2 == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(12);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/dump/mysql/MysqldumpConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/dump/mysql/MysqldumpConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakAutocompletion";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeArguments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsPreparer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizableArguments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartOfValidationOut";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tweakAutocompletion";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

