/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.run.session.BaseJdbcSession;
import com.intellij.database.run.session.Session;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SessionHolder<S extends BaseJdbcSession<?>, P extends Parameters> {
    private final Class<S> myClazz;

    protected SessionHolder(@NotNull Class<S> clazz) {
        if (clazz == null) {
            SessionHolder.$$$reportNull$$$0(0);
        }
        this.myClazz = clazz;
    }

    @Nullable
    public S getSession(@NotNull AnActionEvent e) {
        Session session;
        if (e == null) {
            SessionHolder.$$$reportNull$$$0(1);
        }
        if ((session = (Session)e.getData(Session.SESSION_KEY)) != null) {
            return (S)(this.myClazz.isInstance(session) ? (BaseJdbcSession)session : null);
        }
        return this.getSession(e.getProject(), (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
    }

    @Nullable
    public S getSession(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        for (BaseJdbcSession session : this.getActiveSessions(project)) {
            if (!Comparing.equal((Object)session.getVirtualFile(), (Object)file)) continue;
            return (S)session;
        }
        return null;
    }

    @NotNull
    protected abstract List<S> getActiveSessions(@NotNull Project var1);

    protected abstract void register(@NotNull Project var1, @NotNull S var2);

    @NotNull
    public S openSession(@NotNull P parameters) {
        if (parameters == null) {
            SessionHolder.$$$reportNull$$$0(2);
        }
        S session = this.getSessionInner(parameters);
        this.register(((Parameters)parameters).project, session);
        S s = session;
        if (s == null) {
            SessionHolder.$$$reportNull$$$0(3);
        }
        return s;
    }

    @NotNull
    protected abstract S getSessionInner(@NotNull P var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/SessionHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/SessionHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "openSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSession";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openSession";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Parameters {
        public final Project project;
        public final DataBus.Consuming messageBus;

        protected Parameters(@NotNull Project project, @NotNull DataBus.Consuming messageBus) {
            if (project == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            if (messageBus == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            this.project = project;
            this.messageBus = messageBus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageBus";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/SessionHolder$Parameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

