/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IdentityDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.H2Dialect;
import org.jetbrains.annotations.NotNull;

public class H2Domains
extends DomainRegistry {
    private static final int TS_FRACTION = 9;

    public H2Domains() {
        super(H2Dialect.INSTANCE);
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
        this.add(new Number2Domain("dec", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
        this.add(new Number2Domain("number", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
        this.add(new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, Integer.MAX_VALUE, -1L, true));
        this.add(new BinaryDomain("tinyblob", ConversionPoint.BINARY, Integer.MAX_VALUE, -1L, true));
        this.add(new BinaryDomain("mediumblob", ConversionPoint.BINARY, Integer.MAX_VALUE, -1L, true));
        this.add(new BinaryDomain("longblob", ConversionPoint.BINARY, Integer.MAX_VALUE, -1L, true));
        this.add(new BinaryDomain("oid", ConversionPoint.BINARY_ID, Integer.MAX_VALUE, -1L, true));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, Integer.MAX_VALUE, -1L, true));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE, -1L, true));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add(new BooleanDomain("bit", ConversionPoint.BOOLEAN));
        this.add(new BooleanDomain("bool", ConversionPoint.BOOLEAN));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("int4", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("signed", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("mediumint", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("int2", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("year", ConversionPoint.YEAR, -32768.0, 32767.0));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("int8", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new MyIdentityDomain(new IntegerDomain("identity", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18)));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FloatDomain("float8", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add(new FloatDomain("float4", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 9));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 9));
        this.add(new FractionDomain("smalldatetime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 9));
        this.add(new TextDomain("tinytext", ConversionPoint.TEXT, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("mediumtext", ConversionPoint.TEXT, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("ntext", ConversionPoint.NTEXT, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("nclob", ConversionPoint.NTEXT, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("longvarchar", ConversionPoint.TEXT, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("varchar2", ConversionPoint.VARCHAR, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("varchar_ignorecase", ConversionPoint.VARCHAR, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("nvarchar", ConversionPoint.NVARCHAR, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("nvarchar2", ConversionPoint.NVARCHAR, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("char", ConversionPoint.CHAR, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("nchar", ConversionPoint.NCHAR, Integer.MAX_VALUE, -1L, true));
        this.add(new BinaryDomain("image", ConversionPoint.GRAPHIC, Integer.MAX_VALUE, -1L, true));
    }

    private static class MyIdentityDomain
    extends IdentityDomain {
        MyIdentityDomain(@NotNull Domain domain) {
            if (domain == null) {
                MyIdentityDomain.$$$reportNull$$$0(0);
            }
            super(domain);
        }

        @Override
        @NotNull
        public String name() {
            String string = this.unwrap().name();
            if (string == null) {
                MyIdentityDomain.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
            if (descriptor == null) {
                MyIdentityDomain.$$$reportNull$$$0(2);
            }
            return this.unwrap().isSuitable(descriptor);
        }

        @Override
        @NotNull
        protected IdentityDomain createDomain(@NotNull Domain domain) {
            if (domain == null) {
                MyIdentityDomain.$$$reportNull$$$0(3);
            }
            MyIdentityDomain myIdentityDomain = new MyIdentityDomain(domain);
            if (myIdentityDomain == null) {
                MyIdentityDomain.$$$reportNull$$$0(4);
            }
            return myIdentityDomain;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/registry/H2Domains$MyIdentityDomain";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/registry/H2Domains$MyIdentityDomain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuitable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDomain";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

