/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.vendors.oracle.tns.TnsNamesExtractor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TnsNamesParamEditor
extends ParamEditorBase<TextFieldWithAutoCompletion<String>> {
    public static final String TNSADMIN_DIR = "TNSADMIN_DIR";
    private static final String ORACLE_REG_ROOT = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE";
    private final ActionGroup myContextMenu;

    public TnsNamesParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(1);
        }
        this(label, interchange, new OraCompletionProvider(interchange));
    }

    private TnsNamesParamEditor(@NotNull String label, @NotNull DataInterchange interchange, @NotNull OraCompletionProvider comp) {
        if (label == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(2);
        }
        if (interchange == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(3);
        }
        if (comp == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(4);
        }
        super(new TextFieldWithAutoCompletion(interchange.getProject(), (TextFieldWithAutoCompletionListProvider)comp, false, null), interchange, TypesRegistry.ParamEditor.FieldSize.MEDIUM, label, new AnAction[0]);
        this.myContextMenu = new DefaultActionGroup(new AnAction[]{new DumbAwareAction("Reparse", "Reparse tnsnames.ora", AllIcons.Actions.Refresh){

            public void update(AnActionEvent e) {
                String tnsadmin = TnsNamesParamEditor.this.getInterchange().getProperty(TnsNamesParamEditor.TNSADMIN_DIR);
                e.getPresentation().setEnabled(tnsadmin != null && TnsNamesParamEditor.hasTnsNamesOra(tnsadmin));
            }

            public void actionPerformed(AnActionEvent e) {
                TnsNamesParamEditor.this.getInterchange().forceUpdateProperty(TnsNamesParamEditor.TNSADMIN_DIR);
            }
        }});
        comp.init(this);
        interchange.addPersistentProperty(TNSADMIN_DIR);
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).ensureWillComputePreferredSize();
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                TnsNamesParamEditor.this.fireChanged();
            }
        });
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).addSettingsProvider(editor -> editor.addEditorMouseListener((EditorMouseListener)EditorActionUtil.createEditorPopupHandler((ActionGroup)this.myContextMenu)));
    }

    private static boolean hasTnsNamesOra(@Nullable String path) {
        return path != null && new File(path, "tnsnames.ora").exists();
    }

    @Nullable
    private static String getEnvTnsAdminPath() {
        return System.getenv("TNS_ADMIN");
    }

    @Nullable
    private static String getEnvOracleHomePath() {
        String res = System.getenv("ORACLE_HOME");
        return res == null ? null : FileUtil.join((String[])new String[]{res, "network", "admin"});
    }

    @Nullable
    private static String checkRegDefaultHome(@NotNull String defaultHomePath, @NotNull String defaultHomeKey, Function<String, String> ... homeCheckers) {
        String defaultHome;
        if (defaultHomePath == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(5);
        }
        if (defaultHomeKey == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(6);
        }
        if (homeCheckers == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(7);
        }
        if ((defaultHome = WindowsRegistryUtil.readRegistryValue((String)defaultHomePath, (String)defaultHomeKey)) == null) {
            return null;
        }
        for (Function<String, String> checker : homeCheckers) {
            String res = (String)checker.fun((Object)("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\" + defaultHome));
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Nullable
    private static String checkRegOracleHomes(Function<String, String> ... homeCheckers) {
        String res;
        if (homeCheckers == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(8);
        }
        if ((res = TnsNamesParamEditor.checkRegDefaultHome("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\ALL_HOMES", "DEFAULT_HOME", homeCheckers)) != null) {
            return res;
        }
        res = TnsNamesParamEditor.checkRegDefaultHome(ORACLE_REG_ROOT, "DEFAULT_HOME", homeCheckers);
        if (res != null) {
            return res;
        }
        List possibleHomes = WindowsRegistryUtil.readRegistryBranch((String)ORACLE_REG_ROOT);
        for (Function<String, String> checker : homeCheckers) {
            for (String possibleHome : possibleHomes) {
                res = (String)checker.fun((Object)("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\" + possibleHome));
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    @Nullable
    private static String getRegOraclePath() {
        return TnsNamesParamEditor.checkRegOracleHomes(new Function[]{new Function.Mono<String>(){

            public String fun(String homePath) {
                String res = WindowsRegistryUtil.readRegistryValue((String)homePath, (String)"TNS_ADMIN");
                return TnsNamesParamEditor.hasTnsNamesOra(res) ? res : null;
            }
        }, new Function.Mono<String>(){

            public String fun(String homePath) {
                String res = WindowsRegistryUtil.readRegistryValue((String)homePath, (String)"ORACLE_HOME");
                return res != null && TnsNamesParamEditor.hasTnsNamesOra(FileUtil.join((String[])new String[]{res, "network", "admin"})) ? res : null;
            }
        }});
    }

    @Nullable
    private static String findDirectoryWithTnsNamesOra() {
        String res = TnsNamesParamEditor.getEnvTnsAdminPath();
        if (TnsNamesParamEditor.hasTnsNamesOra(res)) {
            return res;
        }
        if (SystemInfo.isWindows) {
            res = TnsNamesParamEditor.getRegOraclePath();
            if (TnsNamesParamEditor.hasTnsNamesOra(res)) {
                return res;
            }
        } else if (SystemInfo.isSolaris) {
            res = "/var/opt/oracle";
            if (TnsNamesParamEditor.hasTnsNamesOra("/var/opt/oracle")) {
                return res;
            }
        } else {
            res = "/etc";
            if (TnsNamesParamEditor.hasTnsNamesOra("/etc")) {
                return res;
            }
        }
        if (TnsNamesParamEditor.hasTnsNamesOra(res = TnsNamesParamEditor.getEnvOracleHomePath())) {
            return res;
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = ((TextFieldWithAutoCompletion)this.getEditorComponent()).getText();
        if (string == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text) {
        if (text == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(10);
        }
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).setText(text);
    }

    @Override
    public void setActive(boolean active) {
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).setBackground(TnsNamesParamEditor.getBackground(active));
    }

    public static Collection<TypesRegistry.ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
        if (interchange == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(11);
        }
        return Collections.singletonList(new MyTnsAdminField(interchange));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHomePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHomeKey";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeCheckers";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/TnsNamesParamEditor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/TnsNamesParamEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRegDefaultHome";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkRegOracleHomes";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSatellites";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class OraCompletionProvider
    extends TextFieldWithAutoCompletion.StringsCompletionProvider
    implements PropertyChangeListener {
        @NotNull
        private final DataInterchange myInterchange;
        private String myTnsAdminDir;
        private boolean myComputed;

        public OraCompletionProvider(@NotNull DataInterchange interchange) {
            if (interchange == null) {
                OraCompletionProvider.$$$reportNull$$$0(0);
            }
            super(null, null);
            this.myComputed = false;
            this.myInterchange = interchange;
            this.setTnsAdminDir(this.myInterchange.getProperty(TnsNamesParamEditor.TNSADMIN_DIR));
        }

        void init(@NotNull Disposable parent) {
            if (parent == null) {
                OraCompletionProvider.$$$reportNull$$$0(1);
            }
            this.myInterchange.addPropertyChangeListener(TnsNamesParamEditor.TNSADMIN_DIR, this, parent);
        }

        public void setTnsAdminDir(@Nullable String tnsAdminDir) {
            this.myTnsAdminDir = tnsAdminDir;
            this.reset();
        }

        public void reset() {
            this.myComputed = false;
            this.setItems(null);
        }

        @NotNull
        public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            if (!this.myComputed) {
                ArrayList items = ContainerUtil.newArrayList();
                if (this.myTnsAdminDir != null) {
                    try {
                        TnsNamesExtractor.extract(FileUtil.loadFile((File)new File(this.myTnsAdminDir, "tnsnames.ora")), (Consumer<String>)((Consumer)s -> items.add(s)));
                    }
                    catch (IOException e) {
                        this.myInterchange.putProperty("TNSADMIN_ERROR", e.getMessage());
                    }
                }
                this.setItems(items);
                this.myComputed = true;
            }
            Collection collection = super.getItems(prefix, cached, parameters);
            if (collection == null) {
                OraCompletionProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setTnsAdminDir((String)evt.getNewValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/ui/TnsNamesParamEditor$OraCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/ui/TnsNamesParamEditor$OraCompletionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "init";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTnsAdminField
    extends TextParamEditor
    implements PropertyChangeListener {
        private static final String TNSADMIN_ERROR = "TNSADMIN_ERROR";
        private final ActionGroup myContextMenu;

        public MyTnsAdminField(final @NotNull DataInterchange interchange) {
            if (interchange == null) {
                MyTnsAdminField.$$$reportNull$$$0(0);
            }
            super(interchange, "TNSADMIN:", TypesRegistry.ParamEditor.FieldSize.LARGE, new AnAction[0]);
            this.myContextMenu = new DefaultActionGroup(new AnAction[]{new DumbAwareAction("Detect", "Detect one of standard directories, containing tnsnames.ora", AllIcons.Actions.Refresh){

                public void actionPerformed(AnActionEvent e) {
                    String dir = TnsNamesParamEditor.findDirectoryWithTnsNamesOra();
                    if (dir == null) {
                        JBPopupFactory.getInstance().createBalloonBuilder(HintUtil.createErrorLabel((String)"tnsnames.ora not found")).setFadeoutTime(5000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint((Component)this.getComponent(), new Point()), Balloon.Position.above);
                        return;
                    }
                    this.getInterchange().putProperty(TnsNamesParamEditor.TNSADMIN_DIR, dir);
                }
            }});
            interchange.addPropertyChangeListener(TnsNamesParamEditor.TNSADMIN_DIR, this, this);
            interchange.addPropertyChangeListener(TNSADMIN_ERROR, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() == null) {
                        return;
                    }
                    interchange.putProperty(MyTnsAdminField.TNSADMIN_ERROR, null);
                    GuiUtils.invokeLaterIfNeeded(() -> JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JBLabel((String)evt.getNewValue())).setFadeoutTime(5000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint((Component)this.getComponent(), new Point()), Balloon.Position.above), (ModalityState)ModalityState.defaultModalityState());
                }
            }, this);
            FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
            descriptor.setHideIgnored(false);
            descriptor.setTitle("Choose TNSADMIN Directory Location");
            this.addButton((AnAction)new ParamEditorBase.FMChooseAction(descriptor));
            DbUIUtil.invokeLater(() -> this.updateTnsAdmin());
            PopupHandler.installUnknownPopupHandler(this.getEditorComponent(), (ActionGroup)this.myContextMenu, (ActionManager)ActionManager.getInstance());
        }

        private void updateTnsAdmin() {
            String val = this.getInterchange().getProperty(TnsNamesParamEditor.TNSADMIN_DIR);
            boolean newVal = false;
            if (StringUtil.isEmpty((String)val)) {
                val = TnsNamesParamEditor.findDirectoryWithTnsNamesOra();
                boolean bl = newVal = !StringUtil.isEmpty((String)val);
            }
            if (newVal) {
                this.getInterchange().putProperty(TnsNamesParamEditor.TNSADMIN_DIR, val);
            } else {
                this.getInterchange().forceUpdateProperty(TnsNamesParamEditor.TNSADMIN_DIR);
            }
        }

        @Override
        protected void fireChanged() {
            this.getInterchange().putProperty(TnsNamesParamEditor.TNSADMIN_DIR, StringUtil.nullize((String)this.getText()));
            super.fireChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String text = StringUtil.notNullize((String)((String)evt.getNewValue()));
            if (!this.getText().equals(text)) {
                this.setText(text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/TnsNamesParamEditor$MyTnsAdminField", "<init>"));
        }
    }
}

