/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.console.BaseJdbcSessionView;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.audit.JdbcSessionLogger;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.BaseJdbcSession;
import com.intellij.database.run.session.SessionStateWatcher;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DataGridSession
extends DatabaseTableGridDataHookUp
implements BaseJdbcSession<BaseJdbcSessionView<?>> {
    private final BaseJdbcSessionView<?> myView;
    private final SessionStateWatcher myStateWatcher;

    DataGridSession(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull VirtualFile file) {
        if (project == null) {
            DataGridSession.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            DataGridSession.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DataGridSession.$$$reportNull$$$0(2);
        }
        super(project, messageBus, file);
        this.myView = this.createView();
        Disposer.register((Disposable)this, this.myView);
        this.myStateWatcher = new SessionStateWatcher(this);
    }

    @Override
    @NotNull
    public BaseJdbcSessionView<?> getView() {
        BaseJdbcSessionView<?> baseJdbcSessionView = this.myView;
        if (baseJdbcSessionView == null) {
            DataGridSession.$$$reportNull$$$0(3);
        }
        return baseJdbcSessionView;
    }

    @Override
    public boolean isValid() {
        return JdbcConsole.isDataSourceValid(DbPsiFacade.getInstance((Project)this.getProject()), this.getTarget()) && this.myView.isValid();
    }

    @Override
    public boolean isIdle() {
        return this.myStateWatcher.isIdle();
    }

    @Override
    @NotNull
    public LocalDataSource getTarget() {
        LocalDataSource localDataSource = DbImplUtil.getLocalDataSource((DatabaseSystem)this.getDataSource());
        if (localDataSource == null) {
            DataGridSession.$$$reportNull$$$0(4);
        }
        return localDataSource;
    }

    @NotNull
    private BaseJdbcSessionView<?> createView() {
        Project project = this.getProject();
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((DbElement)this.getDataSource());
        LanguageConsoleImpl console = new LanguageConsoleImpl(project, EditorTabbedContainer.calcTabTitle((Project)project, (VirtualFile)this.myFile), (Language)dialect);
        GridSessionView gridSessionView = new GridSessionView(console, this);
        if (gridSessionView == null) {
            DataGridSession.$$$reportNull$$$0(5);
        }
        return gridSessionView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataGridSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataGridSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GridSessionLogger
    extends JdbcSessionLogger {
        GridSessionLogger(@NotNull BaseJdbcSessionView<?> view) {
            if (view == null) {
                GridSessionLogger.$$$reportNull$$$0(0);
            }
            super(view);
        }

        @Override
        protected boolean shouldActivate() {
            String toolWindowId = this.myView.getToolWindowId();
            ToolWindowManager twManager = ToolWindowManager.getInstance((Project)this.myView.getProject());
            ToolWindow window = twManager.getToolWindow(toolWindowId);
            if (window == null || window.isVisible() || !(twManager instanceof ToolWindowManagerEx)) {
                return true;
            }
            ToolWindowManagerEx twManagerEx = (ToolWindowManagerEx)twManager;
            ToolWindowAnchor anchor = window.getAnchor();
            List sameAnchorIds = anchor == null ? ContainerUtil.emptyList() : twManagerEx.getIdsOn(anchor);
            for (String id : sameAnchorIds) {
                if (!twManagerEx.getToolWindow(id).isVisible()) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/datagrid/DataGridSession$GridSessionLogger", "<init>"));
        }
    }

    private static class GridSessionView
    extends BaseJdbcSessionView<DataGridSession> {
        GridSessionView(@NotNull LanguageConsoleImpl console, @NotNull DataGridSession session) {
            if (console == null) {
                GridSessionView.$$$reportNull$$$0(0);
            }
            if (session == null) {
                GridSessionView.$$$reportNull$$$0(1);
            }
            super((LanguageConsoleView)console, session, session.getMessageBus());
        }

        @Override
        public void dispose() {
            try {
                super.dispose();
            }
            finally {
                FileEditorManager.getInstance((Project)this.getProject()).closeFile(((DataGridSession)this.getSession()).getVirtualFile());
            }
        }

        @Override
        @NotNull
        protected SessionLogger createAuditor() {
            GridSessionLogger gridSessionLogger = new GridSessionLogger(this);
            if (gridSessionLogger == null) {
                GridSessionView.$$$reportNull$$$0(2);
            }
            return gridSessionLogger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataGridSession$GridSessionView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataGridSession$GridSessionView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAuditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

