/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseMutatorImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.TxIsolationAuditor;
import com.intellij.database.run.TxMarkerAuditor;
import com.intellij.database.run.audit.AuditorChain;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseGridDataHookUp
extends DataBusGridDataHookUp
implements DataRequest.TxIsolationOwner {
    private final DatabaseMutatorImpl myMutator;
    private volatile int myIsolation;
    private DasTable myDatabaseTable;
    private DbDataSource myDataSource;
    private SqlTableType myTableType;
    private boolean myReadOnly;

    DatabaseGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus) {
        if (project == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(1);
        }
        super(project, messageBus);
        this.myMutator = new DatabaseMutatorImpl(this.getModel(), this);
        this.myIsolation = -1;
    }

    @Nullable
    public DatabaseMutatorImpl getMutator() {
        return this.myMutator;
    }

    @Override
    @NotNull
    protected DatabaseLoader createLoader() {
        DatabaseLoader databaseLoader = new DatabaseLoader();
        if (databaseLoader == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(2);
        }
        return databaseLoader;
    }

    @Override
    @NotNull
    protected DataAuditor createAuditor() {
        AuditorChain auditorChain = new AuditorChain(new TxMarkerAuditor(this), new TxIsolationAuditor(this), new DataBusGridDataHookUp.BusAuditor());
        if (auditorChain == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(3);
        }
        return auditorChain;
    }

    @Override
    public boolean isReadOnly() {
        if (this.myReadOnly) {
            return true;
        }
        DbDataSource dataSource = this.getDataSource();
        if (dataSource == null || !dataSource.isWritable()) {
            return true;
        }
        ObjectKind kind = this.myDatabaseTable != null ? this.myDatabaseTable.getKind() : null;
        return !DbImplUtil.isEditableTable(this.getDatabaseDialect().getFamilyId(), kind);
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.myIsolation = isolation;
    }

    @Override
    public int getTxIsolation() {
        return this.myIsolation;
    }

    @Nullable
    public DasTable getDatabaseTable() {
        if (this.myDatabaseTable instanceof DbElement) {
            return ((DbElement)this.myDatabaseTable).isValid() ? this.myDatabaseTable : null;
        }
        return this.myDatabaseTable;
    }

    public void setDatabaseTable(@Nullable DasTable databaseTable) {
        this.myDatabaseTable = databaseTable;
    }

    @Nullable
    public DbDataSource getDataSource() {
        if (this.myDataSource != null && this.myDataSource.isValid()) {
            return this.myDataSource;
        }
        DasTable dbTable = this.getDatabaseTable();
        return dbTable instanceof DbElement ? ((DbElement)dbTable).getDataSource() : null;
    }

    public void setDataSource(@Nullable DbDataSource dataSource) {
        this.myDataSource = dataSource;
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        DbDataSource dataSource = this.getDataSource();
        DatabaseDialectEx databaseDialectEx = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource) : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(4);
        }
        return databaseDialectEx;
    }

    @Nullable
    public DasColumn getDatabaseColumn(@Nullable DataConsumer.Column column2) {
        if (column2 == null) {
            return null;
        }
        DasTable dasTable = this.getDatabaseTable();
        return dasTable != null ? (DasColumn)JBIterable.from((Iterable)DasUtil.getColumns((DasObject)dasTable)).filter(DasUtil.byName((String)column2.name)).first() : null;
    }

    @Nullable
    public SqlTableType getTableType() {
        if (this.myTableType == null || this.myTableType.getColumnCount() != this.myModel.getColumnCount()) {
            return null;
        }
        List columns2 = this.myModel.getColumns();
        for (DataConsumer.Column column2 : columns2) {
            String nameFromColumn;
            String nameFromType = StringUtil.nullize((String)this.myTableType.getColumnName(column2.columnNum));
            if (StringUtil.equals((CharSequence)nameFromType, (CharSequence)(nameFromColumn = StringUtil.nullize((String)column2.name)))) continue;
            return null;
        }
        return this.myTableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class DatabaseLoader
    extends DataBusGridDataHookUp.DataBusLoader {
        private boolean myLastColumnIsRowId;

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns2, int firstRowNum) {
            boolean sameQuery;
            if (context == null) {
                DatabaseLoader.$$$reportNull$$$0(0);
            }
            DatabaseGridDataHookUp.this.myReadOnly = (sameQuery = Comparing.equal((String)this.getQueryText(), (String)context.getQuery())) ? DatabaseGridDataHookUp.this.myReadOnly : !DbSqlUtil.isResultEditable(context.request, DatabaseGridDataHookUp.this.myDatabaseTable);
            ConsoleDataRequest request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
            DatabaseGridDataHookUp.this.myTableType = request != null ? (SqlTableType)ObjectUtils.tryCast((Object)request.resultType, SqlTableType.class) : null;
            DatabaseGridDataHookUp.this.myMutator.clearPendingChanges();
            super.setColumns(context, resultSetIndex, columns2, firstRowNum);
        }

        @Override
        protected DataConsumer.Column[] prepareColumns(@NotNull DataConsumer.Column[] columns2) {
            if (columns2 == null) {
                DatabaseLoader.$$$reportNull$$$0(1);
            }
            for (int i2 = 0; i2 < columns2.length; ++i2) {
                DataConsumer.Column column2 = columns2[i2];
                DasColumn databaseColumn = DatabaseGridDataHookUp.this.getDatabaseColumn(column2);
                if (databaseColumn != null && (column2.type == 0 || column2.type == 1111)) {
                    columns2[column2.columnNum] = column2 = new DataConsumer.Column(column2.columnNum, column2.name, this.getJdbcType(databaseColumn), column2.typeName, column2.clazz);
                    continue;
                }
                if (i2 != columns2.length - 1 || !this.myLastColumnIsRowId) continue;
                columns2[i2] = DbImplUtil.makeRowId(column2);
            }
            return columns2;
        }

        @Override
        protected void setQueryText(@Nullable String query) {
            super.setQueryText(query);
            DatabaseGridDataHookUp.this.myPageModel.setTotalRowCountUpdateable(this.canCountRows(query));
        }

        protected boolean canCountRows(@Nullable String query) {
            return StringUtil.isNotEmpty((String)query) && DbImplUtil.createSelectCountQuery(DatabaseGridDataHookUp.this.getProject(), DatabaseGridDataHookUp.this.getDatabaseDialect(), query, null) != null;
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseLoader.$$$reportNull$$$0(2);
            }
            this.updateQueryText(null);
            if (!DatabaseGridDataHookUp.this.myPageModel.isTotalRowCountUpdateable()) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            DbDataSource system = DatabaseGridDataHookUp.this.getDataSource();
            String text = this.getQueryText();
            DatabaseDialectEx dialect = DatabaseGridDataHookUp.this.getDatabaseDialect();
            Project project = DatabaseGridDataHookUp.this.getProject();
            String alias = text == null ? "t" : DbImplUtil.findFreeAlias(project, dialect, text, "t");
            final String countQuery = DbImplUtil.createSelectCountQuery(project, dialect, text, system, alias);
            DataRequest.RawRequest request = new DataRequest.RawRequest(DatabaseGridDataHookUp.this){

                @Override
                public void processRaw(DataRequest.Context context, DatabaseConnection connection) throws Exception {
                    int count2 = DbImplUtil.getCount(connection, (String)ObjectUtils.assertNotNull((Object)countQuery));
                    DatabaseGridDataHookUp.this.myPageModel.setTotalRowCount(count2, true);
                }
            };
            DatabaseGridDataHookUp.this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.DO_NOT_RELOAD);
        }

        @Override
        protected boolean canUpdateQueryText() {
            return DatabaseGridDataHookUp.this.getDatabaseTable() != null && (this.getQueryText() == null || this.isQueryInvalidated());
        }

        @Override
        @Nullable
        protected String createQueryText(@Nullable Integer limit) {
            Pair<String, Boolean> pure2 = this.createQueryTextPure(limit);
            if (pure2 == null) {
                return null;
            }
            this.myLastColumnIsRowId = (Boolean)pure2.getSecond();
            return (String)pure2.getFirst();
        }

        @Nullable
        public Pair<String, Boolean> createQueryTextPure(@Nullable Integer limit) {
            DasTable dbTable = DatabaseGridDataHookUp.this.getDatabaseTable();
            if (dbTable == null) {
                return null;
            }
            DatabaseDialectEx dbDialect = DatabaseGridDataHookUp.this.getDatabaseDialect();
            boolean needId = this.needRowId(dbTable);
            DbDataSource source = DatabaseGridDataHookUp.this.getDataSource();
            DdlBuilder builder = limit != null ? dbDialect.sqlSelectAll(DbImplUtil.createBuilderForUIExec(dbDialect, (DasObject)dbTable), dbTable, (DatabaseSystem)source, this::appendWhereClause, (Consumer<DdlBuilder>)((Consumer)this::appendOrderByClause), needId, limit) : this.createUnlimitedBuilder(dbDialect, dbTable);
            return Pair.create((Object)builder.getStatement(), (Object)(needId && dbDialect.hasRowId((DatabaseSystem)source) ? 1 : 0));
        }

        @NotNull
        private DdlBuilder createUnlimitedBuilder(@NotNull DatabaseDialectEx dialect, @NotNull DasTable table) {
            if (dialect == null) {
                DatabaseLoader.$$$reportNull$$$0(3);
            }
            if (table == null) {
                DatabaseLoader.$$$reportNull$$$0(4);
            }
            DdlBuilder builder = DbImplUtil.createSelectAllQuery(table, dialect, (DatabaseSystem)DatabaseGridDataHookUp.this.getDataSource(), this.needRowId(table), -1);
            this.appendWhereClause(null, builder);
            this.appendOrderByClause(builder);
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                DatabaseLoader.$$$reportNull$$$0(5);
            }
            return ddlBuilder;
        }

        private int getJdbcType(@NotNull DasColumn column2) {
            PostgresTableColumn modelColumn;
            if (column2 == null) {
                DatabaseLoader.$$$reportNull$$$0(6);
            }
            PostgresSchema schema = (modelColumn = (PostgresTableColumn)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)column2), PostgresTableColumn.class)) == null ? null : modelColumn.getSchema();
            PostgresDatabase database = schema == null ? null : schema.getDatabase();
            PostgresDefType defType = database == null ? null : (PostgresDefType)ObjectUtils.tryCast((Object)database.findIdentifiedElement(modelColumn.getTypeId()), PostgresDefType.class);
            PostgresDataTypeSubKind kind = defType == null ? null : defType.getSubKind();
            return kind == PostgresDataTypeSubKind.ENUM ? 12 : column2.getDataType().jdbcType;
        }

        private boolean needRowId(@NotNull DasTable table) {
            if (table == null) {
                DatabaseLoader.$$$reportNull$$$0(7);
            }
            return table.getKind() == ObjectKind.TABLE && DasUtil.getPrimaryKey((DasTable)table) == null;
        }

        protected void appendOrderByClause(@NotNull DdlBuilder builder) {
            if (builder == null) {
                DatabaseLoader.$$$reportNull$$$0(8);
            }
        }

        protected void appendWhereClause(@Nullable String alias, @NotNull DdlBuilder builder) {
            if (builder == null) {
                DatabaseLoader.$$$reportNull$$$0(9);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUnlimitedBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareColumns";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateTotalRowCount";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createUnlimitedBuilder";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getJdbcType";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "needRowId";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "appendOrderByClause";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "appendWhereClause";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

