/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.Db2Dialect;
import com.intellij.database.dialects.DerbyDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dialects.H2Dialect;
import com.intellij.database.dialects.HsqldbDialect;
import com.intellij.database.dialects.MssqlDialect;
import com.intellij.database.dialects.MysqlDialect;
import com.intellij.database.dialects.OracleDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.dialects.RedshiftDialect;
import com.intellij.database.dialects.SqliteDialect;
import com.intellij.database.dialects.SybaseDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ImportManager {
    DEFAULT((DatabaseDialectEx)GenericDialect.INSTANCE, "CLOB", 1, false, false, false, false, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("NUMBER")),
    POSTGRES((DatabaseDialectEx)PostgresDialect.INSTANCE, "TEXT", 1, true, true, true, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("NUMERIC")}){

        @Override
        @NotNull
        public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
            if (info == null) {
                1.$$$reportNull$$$0(0);
            }
            List<String> list = this.getQueries(info, true);
            if (list == null) {
                1.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
            if (info == null) {
                1.$$$reportNull$$$0(2);
            }
            List<String> list = this.getQueries(info, false);
            if (list == null) {
                1.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        private List<String> getQueries(@NotNull ImportInfo info, boolean before) {
            if (info == null) {
                1.$$$reportNull$$$0(4);
            }
            List list = ContainerUtil.list((Object[])new String[]{this.triggers(this.alter(this.createBuilder(info.getContext()), "TABLE", info.getTable()).space(), !before).getStatement()});
            if (list == null) {
                1.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        private DdlBuilder triggers(@NotNull DdlBuilder builder, boolean enable) {
            if (builder == null) {
                1.$$$reportNull$$$0(6);
            }
            DdlBuilder ddlBuilder = builder.keyword(enable ? "ENABLE" : "DISABLE").space().keyword("TRIGGER").space().keyword("ALL");
            if (ddlBuilder == null) {
                1.$$$reportNull$$$0(7);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportManager$1";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportManager$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFastModeOnQueries";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFastModeOffQueries";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueries";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "triggers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFastModeOnQueries";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFastModeOffQueries";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getQueries";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "triggers";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    REDSHIFT((DatabaseDialectEx)RedshiftDialect.INSTANCE, "TEXT", 1, false, false, false, true, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("DOUBLE PRECISION")),
    ORACLE((DatabaseDialectEx)OracleDialect.INSTANCE, "CLOB", 1, true, true, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("NUMBER")}){

        @Override
        @NotNull
        public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
            if (info == null) {
                2.$$$reportNull$$$0(0);
            }
            List<String> queries = this.getQueries(info.getContext(), info.getTable(), true, "UNUSABLE");
            queries.add(this.getLockQuery(info));
            List<String> list = queries;
            if (list == null) {
                2.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
            if (info == null) {
                2.$$$reportNull$$$0(2);
            }
            List<String> list = this.getQueries(info.getContext(), info.getTable(), false, "REBUILD");
            if (list == null) {
                2.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        private List<String> getQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table, boolean isBeforeImport, @NotNull String whatToDoWithIndices) {
            if (context == null) {
                2.$$$reportNull$$$0(4);
            }
            if (table == null) {
                2.$$$reportNull$$$0(5);
            }
            if (whatToDoWithIndices == null) {
                2.$$$reportNull$$$0(6);
            }
            ArrayList result2 = ContainerUtil.newArrayList();
            result2.add(this.triggers(this.alter(this.createBuilder(context), "TABLE", table).space(), !isBeforeImport).getStatement());
            result2.add(this.skipUnusable(context, isBeforeImport));
            this.alterIndicies(context, table, result2, whatToDoWithIndices);
            ArrayList arrayList = result2;
            if (arrayList == null) {
                2.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private DdlBuilder triggers(@NotNull DdlBuilder builder, boolean enable) {
            if (builder == null) {
                2.$$$reportNull$$$0(8);
            }
            return builder.keyword(enable ? "ENABLE" : "DISABLE").space().keyword("ALL").space().keyword("TRIGGERS");
        }

        @Override
        @NotNull
        public String getInsertStatement(@NotNull ImportInfo info, int linesCount) {
            if (info == null) {
                2.$$$reportNull$$$0(9);
            }
            if (linesCount > 1) {
                throw new IllegalArgumentException("Lines count bigger than 1 not supported by oracle");
            }
            List params2 = ImportManager.getPlaceholders(OracleDialect.INSTANCE, info.getConsumersForInsert(), linesCount);
            DdlBuilder builder = this.createBuilder(info.getContext()).keyword("INSERT").space().literal("/*+append*/").space().keyword("INTO").space().qualifiedRef(info.getTable()).space().literal("(");
            DialectUtils.appendStringList(builder, JdbcEngine.getColumnNamesForInsert(info.getConsumersForInsert(), OracleDialect.INSTANCE));
            builder.literal(")").space().keyword("VALUES").literal("(");
            DialectUtils.appendCommaSeparated(builder, (Iterable)ContainerUtil.getFirstItem((List)params2));
            builder.literal(")");
            String string = builder.getStatement();
            if (string == null) {
                2.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Override
        @Nullable
        public String getLockQuery(@NotNull ImportInfo info) {
            if (info == null) {
                2.$$$reportNull$$$0(11);
            }
            return this.createBuilder(info.getContext()).space().keyword("LOCK").space().keyword("TABLE").space().qualifiedRef(info.getTable()).space().keyword("IN").space().keyword("EXCLUSIVE").space().keyword("MODE").getStatement();
        }

        private String skipUnusable(@NotNull DatabaseEditorContext context, boolean value) {
            if (context == null) {
                2.$$$reportNull$$$0(12);
            }
            return this.createBuilder(context).keyword("ALTER").space().keyword("SESSION").space().keyword("SET").space().literal("skip_unusable_indexes=").space().literal(String.valueOf(value).toLowerCase(Locale.US)).getStatement();
        }

        private void alterIndicies(@NotNull DatabaseEditorContext context, @NotNull DeTable table, @NotNull List<String> result2, @NotNull String whatToDo) {
            if (context == null) {
                2.$$$reportNull$$$0(13);
            }
            if (table == null) {
                2.$$$reportNull$$$0(14);
            }
            if (result2 == null) {
                2.$$$reportNull$$$0(15);
            }
            if (whatToDo == null) {
                2.$$$reportNull$$$0(16);
            }
            if (table.indices.isEmpty()) {
                return;
            }
            for (int i2 = 1; i2 < table.indices.size(); ++i2) {
                result2.add(this.alterIndex(context, table.indices.get(i2), whatToDo));
            }
        }

        private String alterIndex(@NotNull DatabaseEditorContext context, @NotNull DeIndex index, @NotNull String whatToDo) {
            if (context == null) {
                2.$$$reportNull$$$0(17);
            }
            if (index == null) {
                2.$$$reportNull$$$0(18);
            }
            if (whatToDo == null) {
                2.$$$reportNull$$$0(19);
            }
            return this.alter(this.createBuilder(context), "INDEX", index).space().keyword(whatToDo).getStatement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 7: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 7: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 3: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportManager$2";
                    break;
                }
                case 4: 
                case 12: 
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "whatToDoWithIndices";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "whatToDo";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportManager$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFastModeOnQueries";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFastModeOffQueries";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueries";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFastModeOnQueries";
                    break;
                }
                case 1: 
                case 3: 
                case 7: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFastModeOffQueries";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getQueries";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "triggers";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getInsertStatement";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getLockQuery";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "skipUnusable";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "alterIndicies";
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "alterIndex";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 7: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    MSSQL2005((DatabaseDialectEx)MssqlDialect.INSTANCE, "TEXT", 1, true, true, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT")}){

        @Override
        @NotNull
        public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
            if (info == null) {
                3.$$$reportNull$$$0(0);
            }
            ArrayList result2 = ContainerUtil.newArrayList(POSTGRES.getFastModeOnQueries(info));
            this.alterIndicies(info, result2, false);
            ArrayList arrayList = result2;
            if (arrayList == null) {
                3.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @Override
        @NotNull
        public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
            if (info == null) {
                3.$$$reportNull$$$0(2);
            }
            ArrayList result2 = ContainerUtil.newArrayList(POSTGRES.getFastModeOffQueries(info));
            this.alterIndicies(info, result2, true);
            ArrayList arrayList = result2;
            if (arrayList == null) {
                3.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private void alterIndicies(@NotNull ImportInfo info, @NotNull List<String> result2, boolean enable) {
            if (info == null) {
                3.$$$reportNull$$$0(4);
            }
            if (result2 == null) {
                3.$$$reportNull$$$0(5);
            }
            DeTable table = info.getTable();
            if (table.indices.isEmpty()) {
                return;
            }
            for (int i2 = 1; i2 < table.indices.size(); ++i2) {
                result2.add(this.alterIndex(info, table.indices.get(i2), enable));
            }
        }

        private String alterIndex(@NotNull ImportInfo info, @NotNull DeIndex index, boolean enable) {
            if (info == null) {
                3.$$$reportNull$$$0(6);
            }
            if (index == null) {
                3.$$$reportNull$$$0(7);
            }
            return this.alter(this.createBuilder(info.getContext()), "INDEX", index).space().keyword("ON").space().qualifiedRef(info.getTable()).space().keyword(enable ? "REBUILD" : "DISABLE").getStatement();
        }

        @Override
        boolean isSuitable(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
            if (dialect == null) {
                3.$$$reportNull$$$0(8);
            }
            return dialect == MssqlDialect.INSTANCE && (productVersion == null || !DataSourceUiUtil.isMsSql2008(productVersion));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportManager$3";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportManager$3";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFastModeOnQueries";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFastModeOffQueries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFastModeOnQueries";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFastModeOffQueries";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "alterIndicies";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "alterIndex";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuitable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    MSSQL2008((DatabaseDialectEx)MssqlDialect.INSTANCE, "TEXT", 1, true, true, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT")}){

        @Override
        @NotNull
        public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
            if (info == null) {
                4.$$$reportNull$$$0(0);
            }
            List<String> list = MSSQL2005.getFastModeOnQueries(info);
            if (list == null) {
                4.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
            if (info == null) {
                4.$$$reportNull$$$0(2);
            }
            List<String> list = MSSQL2005.getFastModeOffQueries(info);
            if (list == null) {
                4.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        boolean isSuitable(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
            if (dialect == null) {
                4.$$$reportNull$$$0(4);
            }
            return dialect == MssqlDialect.INSTANCE && productVersion != null && DataSourceUiUtil.isMsSql2008(productVersion);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportManager$4";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportManager$4";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFastModeOnQueries";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFastModeOffQueries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFastModeOnQueries";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFastModeOffQueries";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuitable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    DERBY((DatabaseDialectEx)DerbyDialect.INSTANCE, "CLOB", 1000, false, true, false, true, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("DOUBLE")),
    DB2((DatabaseDialectEx)Db2Dialect.INSTANCE, "CLOB", 1, false, false, true, true, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("DOUBLE")),
    H2((DatabaseDialectEx)H2Dialect.INSTANCE, "TEXT", 1000, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("DOUBLE")),
    HSQLDB((DatabaseDialectEx)HsqldbDialect.INSTANCE, "CLOB", 1, false, false, false, false, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("FLOAT")),
    SYBASE((DatabaseDialectEx)SybaseDialect.INSTANCE, "TEXT", 1, false, false, false, false, new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT")),
    MYSQL((DatabaseDialectEx)MysqlDialect.INSTANCE, "TEXT", 1000, new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("DOUBLE")),
    SQLITE((DatabaseDialectEx)SqliteDialect.INSTANCE, "TEXT", 1, false, true, true, true, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("REAL"));

    private final boolean myUseBatches;
    private final boolean myUseSavepoints;
    private final boolean myUseTransactions;
    private final TypeMerger[] myMergers;
    private final DatabaseDialectEx myDialect;
    private final TypeMerger.StringMerger myStringMerger;
    private final int myLinesPerStatement;
    private final boolean mySupportFastMode;

    private ImportManager(DatabaseDialectEx dialect, @NotNull String myTextType, int batchSize, TypeMerger ... mergers) {
        if (dialect == null) {
            ImportManager.$$$reportNull$$$0(0);
        }
        if (myTextType == null) {
            ImportManager.$$$reportNull$$$0(1);
        }
        if (mergers == null) {
            ImportManager.$$$reportNull$$$0(2);
        }
        this(dialect, myTextType, batchSize, false, true, true, true, mergers);
    }

    private ImportManager(DatabaseDialectEx dialect, String myTextType, int linesPerStatement, boolean supportFastMode, boolean useBatches, @NotNull boolean useSavepoints, boolean useTransactions, TypeMerger ... mergers) {
        if (dialect == null) {
            ImportManager.$$$reportNull$$$0(3);
        }
        if (myTextType == null) {
            ImportManager.$$$reportNull$$$0(4);
        }
        if (mergers == null) {
            ImportManager.$$$reportNull$$$0(5);
        }
        this.myDialect = dialect;
        this.myUseBatches = useBatches;
        this.myUseSavepoints = useSavepoints;
        this.myUseTransactions = useTransactions;
        this.myMergers = mergers;
        this.myStringMerger = new TypeMerger.StringMerger(myTextType);
        this.myLinesPerStatement = linesPerStatement;
        this.mySupportFastMode = supportFastMode;
        Arrays.sort(this.myMergers, Comparator.comparingInt(TypeMerger::getPriority));
    }

    public boolean shouldUseBatches() {
        return this.myUseBatches;
    }

    public boolean shouldUseSavepoints() {
        return this.myUseSavepoints;
    }

    public boolean shouldUseTransactions() {
        return this.myUseTransactions;
    }

    @NotNull
    public TypeMerger getType(String string) {
        for (TypeMerger merger : this.myMergers) {
            if (!merger.isSuitable(string)) continue;
            TypeMerger typeMerger = merger;
            if (typeMerger == null) {
                ImportManager.$$$reportNull$$$0(6);
            }
            return typeMerger;
        }
        TypeMerger.StringMerger stringMerger = this.myStringMerger;
        if (stringMerger == null) {
            ImportManager.$$$reportNull$$$0(7);
        }
        return stringMerger;
    }

    @NotNull
    public TypeMerger.StringMerger getStringMerger() {
        TypeMerger.StringMerger stringMerger = this.myStringMerger;
        if (stringMerger == null) {
            ImportManager.$$$reportNull$$$0(8);
        }
        return stringMerger;
    }

    @NotNull
    public String getInsertStatement(@NotNull ImportInfo info, int linesCount) {
        if (info == null) {
            ImportManager.$$$reportNull$$$0(9);
        }
        String string = AbstractDatabaseDialect.multiInsertStatement(this.createBuilder(info.getContext()), info.getTable(), JdbcEngine.getColumnNamesForInsert(info.getConsumersForInsert(), this.myDialect), this.myDialect, ImportManager.getPlaceholders(this.myDialect, info.getConsumersForInsert(), linesCount)).getStatement();
        if (string == null) {
            ImportManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    public int getLinesPerStatement() {
        return this.myLinesPerStatement;
    }

    @NotNull
    public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
        if (info == null) {
            ImportManager.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ImportManager.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
        if (info == null) {
            ImportManager.$$$reportNull$$$0(13);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ImportManager.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public String getLockQuery(@NotNull ImportInfo info) {
        if (info == null) {
            ImportManager.$$$reportNull$$$0(15);
        }
        return null;
    }

    public boolean isSupportFastMode() {
        return this.mySupportFastMode;
    }

    boolean isSuitable(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
        if (dialect == null) {
            ImportManager.$$$reportNull$$$0(16);
        }
        return this.myDialect == dialect;
    }

    @NotNull
    DdlBuilder createBuilder(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            ImportManager.$$$reportNull$$$0(17);
        }
        DdlBuilder ddlBuilder = ImportManager.createConfiguredBuilder(context);
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(18);
        }
        return ddlBuilder;
    }

    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            ImportManager.$$$reportNull$$$0(19);
        }
        return databaseDialectEx;
    }

    @NotNull
    DdlBuilder alter(@NotNull DdlBuilder builder, @NotNull String objectToAlter, @NotNull DasObject table) {
        if (builder == null) {
            ImportManager.$$$reportNull$$$0(20);
        }
        if (objectToAlter == null) {
            ImportManager.$$$reportNull$$$0(21);
        }
        if (table == null) {
            ImportManager.$$$reportNull$$$0(22);
        }
        DdlBuilder ddlBuilder = builder.keyword("ALTER").space().keyword(objectToAlter).space().qualifiedRef(table);
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    @NotNull
    public static ImportManager of(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
        if (dialect == null) {
            ImportManager.$$$reportNull$$$0(24);
        }
        for (ImportManager manager : ImportManager.values()) {
            if (!manager.isSuitable(dialect, productVersion)) continue;
            ImportManager importManager = manager;
            if (importManager == null) {
                ImportManager.$$$reportNull$$$0(25);
            }
            return importManager;
        }
        ImportManager importManager = DEFAULT;
        if (importManager == null) {
            ImportManager.$$$reportNull$$$0(26);
        }
        return importManager;
    }

    @NotNull
    public static DdlBuilder createConfiguredBuilder(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            ImportManager.$$$reportNull$$$0(27);
        }
        DdlBuilder ddlBuilder = DatabaseDialogsHelper.createDdlBuilder(context, false);
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(28);
        }
        return ddlBuilder;
    }

    @NotNull
    private static List<List<Consumer<DdlBuilder>>> getPlaceholders(@NotNull DatabaseDialectEx dialect, @NotNull Collection<? extends AutoValueDescriptor> columns2, int rows) {
        if (dialect == null) {
            ImportManager.$$$reportNull$$$0(29);
        }
        if (columns2 == null) {
            ImportManager.$$$reportNull$$$0(30);
        }
        List<List<Consumer<DdlBuilder>>> list = Collections.nCopies(rows, JdbcEngine.getPlaceholdersForInsert(columns2, dialect));
        if (list == null) {
            ImportManager.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myTextType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergers";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportManager";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectToAlter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringMerger";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOnQueries";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOffQueries";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "alter";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguredBuilder";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInsertStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOnQueries";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOffQueries";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLockQuery";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "alter";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguredBuilder";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

