/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectWrapper<T> {
    private final T myObject;
    private final HasherAndComparator<T> myHasher;

    public ObjectWrapper(@Nullable T object, @NotNull HasherAndComparator<T> hasher) {
        if (hasher == null) {
            ObjectWrapper.$$$reportNull$$$0(0);
        }
        this.myObject = object;
        this.myHasher = hasher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectWrapper)) {
            return false;
        }
        ObjectWrapper wrapper = (ObjectWrapper)o;
        return wrapper.myHasher.equals(this.myHasher) && this.myHasher.equals(this.myObject, this.doCast(wrapper.myObject));
    }

    public int hashCode() {
        return this.myHasher.hash(this.myObject);
    }

    @NotNull
    public static <T> List<ObjectWrapper> wrap(@NotNull List<T> objs, @NotNull HasherAndComparator<T> pred) {
        if (objs == null) {
            ObjectWrapper.$$$reportNull$$$0(1);
        }
        if (pred == null) {
            ObjectWrapper.$$$reportNull$$$0(2);
        }
        ArrayList res = ContainerUtil.newArrayListWithCapacity((int)objs.size());
        for (T obj : objs) {
            res.add(new ObjectWrapper<T>(obj, pred));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            ObjectWrapper.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<List<ObjectWrapper>> wrap2(@NotNull List<List<T>> objs, @NotNull HasherAndComparator<T> pred) {
        if (objs == null) {
            ObjectWrapper.$$$reportNull$$$0(4);
        }
        if (pred == null) {
            ObjectWrapper.$$$reportNull$$$0(5);
        }
        ArrayList res = ContainerUtil.newArrayListWithCapacity((int)objs.size());
        for (List<T> obj : objs) {
            res.add(ObjectWrapper.wrap(obj, pred));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            ObjectWrapper.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private T doCast(Object obj) {
        return (T)obj;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasher";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objs";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pred";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/ObjectWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/ObjectWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrap2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface HasherAndComparator<T> {
        public boolean equals(T var1, T var2);

        public int hash(T var1);
    }
}

