/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DiffAlgo;
import com.intellij.database.diff.TableDiffSettingsHolder;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableDiffBuilder {
    @NotNull
    private static List<Object> skip(@NotNull List<Object> list, @NotNull TIntArrayList skip) {
        if (list == null) {
            TableDiffBuilder.$$$reportNull$$$0(0);
        }
        if (skip == null) {
            TableDiffBuilder.$$$reportNull$$$0(1);
        }
        ArrayList cols = ContainerUtil.newArrayListWithCapacity((int)(list.size() - skip.size()));
        int k = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (k < skip.size() && i2 == skip.get(k)) {
                ++k;
                continue;
            }
            cols.add(list.get(i2));
        }
        ArrayList arrayList = cols;
        if (arrayList == null) {
            TableDiffBuilder.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static TableDiffResult process(@NotNull Data data) {
        if (data == null) {
            TableDiffBuilder.$$$reportNull$$$0(3);
        }
        TableDiffResult res = new TableDiffResult();
        if (data.table1.isEmpty() || data.table2.isEmpty()) {
            if (!data.table1.isEmpty() || !data.table2.isEmpty()) {
                res.rowDiff.add((Pair<RowDiffRange, Boolean>)Pair.create((Object)new RowDiffRange(0, data.table1.size(), 0, data.table2.size()), (Object)false));
            }
            TableDiffResult tableDiffResult = res;
            if (tableDiffResult == null) {
                TableDiffBuilder.$$$reportNull$$$0(4);
            }
            return tableDiffResult;
        }
        boolean skip = TableDiffBuilder.findColumnsToSkip(data, res.skippedCols1, res.skippedCols2);
        if (skip) {
            data = data.skipped(res.skippedCols1, res.skippedCols2);
        }
        assert (data.table1.get(0).size() == data.table2.get(0).size());
        TableDiffResult subRes = TableDiffBuilder.processSameCols(data);
        if (!skip) {
            TableDiffResult tableDiffResult = subRes;
            if (tableDiffResult == null) {
                TableDiffBuilder.$$$reportNull$$$0(5);
            }
            return tableDiffResult;
        }
        TableDiffResult tableDiffResult = res.apply(subRes);
        if (tableDiffResult == null) {
            TableDiffBuilder.$$$reportNull$$$0(6);
        }
        return tableDiffResult;
    }

    private static boolean findColumnsToSkip(@NotNull Data data, @NotNull TIntArrayList cols12, @NotNull TIntArrayList cols22) {
        if (data == null) {
            TableDiffBuilder.$$$reportNull$$$0(7);
        }
        if (cols12 == null) {
            TableDiffBuilder.$$$reportNull$$$0(8);
        }
        if (cols22 == null) {
            TableDiffBuilder.$$$reportNull$$$0(9);
        }
        if (data.table1.get(0).size() == data.table2.get(0).size()) {
            return false;
        }
        if (!data.settings.detectColumnInsertion) {
            int s2;
            int s1 = data.table1.get(0).size();
            if (s1 < (s2 = data.table2.get(0).size())) {
                for (int i2 = s1; i2 < s2; ++i2) {
                    cols22.add(i2);
                }
            } else {
                for (int i3 = s2; i3 < s1; ++i3) {
                    cols12.add(i3);
                }
            }
            return true;
        }
        int m = Math.min(data.table1.get(0).size(), data.table2.get(0).size());
        int shouldMatch = Math.max(1, m - data.settings.columnMismatchThreshold);
        List<List<Object>> fuzzy1 = data.table1.subList(0, Math.min(data.table1.size(), data.settings.columnDetectionSample));
        List<List<Object>> fuzzy2 = data.table2.subList(0, Math.min(data.table2.size(), data.settings.columnDetectionSample));
        DiffIterable diff = DiffAlgo.diff(fuzzy1, fuzzy2, (o1, o2) -> {
            if (data == null) {
                TableDiffBuilder.$$$reportNull$$$0(19);
            }
            FairDiffIterable diff1 = DiffIterableUtil.diff((List)o1, (List)o2, (ProgressIndicator)data.indicator);
            int matched = 0;
            Iterator unchanged = diff1.unchanged();
            while (unchanged.hasNext()) {
                Range range = (Range)unchanged.next();
                matched += range.end1 - range.start1;
            }
            return matched >= shouldMatch ? 0 : 1;
        });
        int[] changes1 = new int[data.table1.get(0).size()];
        int[] changes2 = new int[data.table2.get(0).size()];
        Iterator unchanged = diff.unchanged();
        while (unchanged.hasNext()) {
            Range range = (Range)unchanged.next();
            assert (range.end1 - range.start1 == range.end2 - range.start2);
            for (int i4 = 0; i4 < range.end1 - range.start1; ++i4) {
                FairDiffIterable columnsDiff = DiffIterableUtil.diff(fuzzy1.get(range.start1 + i4), fuzzy2.get(range.start2 + i4), (ProgressIndicator)data.indicator);
                Iterator changes = columnsDiff.changes();
                while (changes.hasNext()) {
                    Range columnsRange = (Range)changes.next();
                    int k = columnsRange.start1;
                    while (k < columnsRange.end1) {
                        int n = k++;
                        changes1[n] = changes1[n] + 1;
                    }
                    k = columnsRange.start2;
                    while (k < columnsRange.end2) {
                        int n = k++;
                        changes2[n] = changes2[n] + 1;
                    }
                }
            }
        }
        int d = data.table1.get(0).size() - data.table2.get(0).size();
        if (d < 0) {
            TableDiffBuilder.findNMax(changes2, -d, cols22);
        } else {
            TableDiffBuilder.findNMax(changes1, d, cols12);
        }
        return true;
    }

    private static void findNMax(@NotNull int[] data, int n, @NotNull TIntArrayList maxIds) {
        int i2;
        if (maxIds == null) {
            TableDiffBuilder.$$$reportNull$$$0(10);
        }
        if (data == null) {
            TableDiffBuilder.$$$reportNull$$$0(11);
        }
        boolean[] maxes = new boolean[data.length];
        for (i2 = 0; i2 < n; ++i2) {
            int max = Integer.MIN_VALUE;
            int maxi = -1;
            for (int j = 0; j < data.length; ++j) {
                if (maxes[j] || max >= data[j]) continue;
                max = data[j];
                maxi = j;
            }
            assert (maxi != -1);
            maxes[maxi] = true;
        }
        for (i2 = 0; i2 < maxes.length; ++i2) {
            if (!maxes[i2]) continue;
            maxIds.add(i2);
        }
    }

    private static TableDiffResult processSameCols(@NotNull Data data) {
        if (data == null) {
            TableDiffBuilder.$$$reportNull$$$0(12);
        }
        TableDiffResult result2 = new TableDiffResult();
        FairDiffIterable diff = DiffIterableUtil.diff(data.table1, data.table2, (ProgressIndicator)data.indicator);
        Iterator it = diff.changes();
        while (it.hasNext()) {
            if (data.settings.columnMismatchThreshold > 0) {
                TableDiffBuilder.appendFuzzyMatch((Range)it.next(), data, result2);
                continue;
            }
            TableDiffBuilder.appendUnmatched(0, 0, (Range)it.next(), false, result2);
        }
        return result2;
    }

    private static void appendUnmatched(int s1, int s2, @NotNull Range rg, boolean fuzzy, @NotNull TableDiffResult result2) {
        if (rg == null) {
            TableDiffBuilder.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            TableDiffBuilder.$$$reportNull$$$0(14);
        }
        result2.rowDiff.add((Pair<RowDiffRange, Boolean>)Pair.create((Object)new RowDiffRange(s1 + rg.start1, s1 + rg.end1, s2 + rg.start2, s2 + rg.end2), (Object)fuzzy));
    }

    private static void appendFuzzyMatch(@NotNull Range rg, @NotNull Data data, @NotNull TableDiffResult result2) {
        if (rg == null) {
            TableDiffBuilder.$$$reportNull$$$0(15);
        }
        if (data == null) {
            TableDiffBuilder.$$$reportNull$$$0(16);
        }
        if (result2 == null) {
            TableDiffBuilder.$$$reportNull$$$0(17);
        }
        DiffIterable fuzzyDiff = DiffAlgo.diff(data.table1.subList(rg.start1, rg.end1), data.table2.subList(rg.start2, rg.end2), (a, b) -> {
            if (data == null) {
                TableDiffBuilder.$$$reportNull$$$0(18);
            }
            if (a.size() != b.size()) {
                return -1;
            }
            int mismatches = 0;
            for (int i2 = 0; i2 < a.size(); ++i2) {
                if (!Comparing.equal(a.get(i2), b.get(i2))) {
                    ++mismatches;
                }
                if (mismatches <= data.settings.columnMismatchThreshold) continue;
                return -1;
            }
            return 0;
        });
        Iterator it2 = fuzzyDiff.changes();
        while (it2.hasNext()) {
            TableDiffBuilder.appendUnmatched(rg.start1, rg.start2, (Range)it2.next(), false, result2);
        }
        it2 = fuzzyDiff.unchanged();
        while (it2.hasNext()) {
            Range rg2 = (Range)it2.next();
            TableDiffBuilder.appendUnmatched(rg.start1, rg.start2, rg2, true, result2);
            assert (rg2.end1 - rg2.start1 == rg2.end2 - rg2.start2);
            for (int i2 = 0; i2 < rg2.end1 - rg2.start1; ++i2) {
                int row1 = rg.start1 + rg2.start1 + i2;
                int row2 = rg.start2 + rg2.start2 + i2;
                for (int j = 0; j < data.table1.get(row1).size(); ++j) {
                    if (Comparing.equal((Object)data.table1.get(row1).get(j), (Object)data.table2.get(row2).get(j))) continue;
                    result2.cellDiff.add(new CellDiff(row1, j, row2, j));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skip";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/TableDiffBuilder";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cols1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cols2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxIds";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rg";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/TableDiffBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "skip";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "skip";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findColumnsToSkip";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findNMax";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processSameCols";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendUnmatched";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendFuzzyMatch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendFuzzyMatch$1";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findColumnsToSkip$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TableDiffResult {
        public final TIntArrayList skippedCols1 = new TIntArrayList();
        public final TIntArrayList skippedCols2 = new TIntArrayList();
        public final TIntArrayList skippedRows1 = new TIntArrayList();
        public final TIntArrayList skippedRows2 = new TIntArrayList();
        public final List<Pair<RowDiffRange, Boolean>> rowDiff = ContainerUtil.newArrayList();
        public final List<CellDiff> cellDiff = ContainerUtil.newArrayList();

        public TableDiffResult apply(@NotNull TableDiffResult res) {
            int i2;
            if (res == null) {
                TableDiffResult.$$$reportNull$$$0(0);
            }
            int[] cmap1 = TableDiffResult.createMapping(this.skippedCols1);
            int[] cmap2 = TableDiffResult.createMapping(this.skippedCols2);
            int[] rmap1 = TableDiffResult.createMapping(this.skippedRows1);
            int[] rmap2 = TableDiffResult.createMapping(this.skippedRows2);
            for (i2 = 0; i2 < res.skippedCols1.size(); ++i2) {
                this.skippedCols1.add(TableDiffResult.map(cmap1, res.skippedCols1.get(i2)));
            }
            for (i2 = 0; i2 < res.skippedCols2.size(); ++i2) {
                this.skippedCols2.add(TableDiffResult.map(cmap2, res.skippedCols2.get(i2)));
            }
            for (i2 = 0; i2 < res.skippedRows1.size(); ++i2) {
                this.skippedRows1.add(TableDiffResult.map(rmap1, res.skippedRows1.get(i2)));
            }
            for (i2 = 0; i2 < res.skippedRows2.size(); ++i2) {
                this.skippedRows2.add(TableDiffResult.map(rmap2, res.skippedRows2.get(i2)));
            }
            this.skippedCols1.sort();
            this.skippedCols2.sort();
            this.skippedRows1.sort();
            this.skippedRows2.sort();
            for (Pair<RowDiffRange, Boolean> pair : res.rowDiff) {
                this.rowDiff.add((Pair<RowDiffRange, Boolean>)Pair.create((Object)new RowDiffRange(TableDiffResult.map(rmap1, ((RowDiffRange)pair.first).begin1), TableDiffResult.map(rmap1, ((RowDiffRange)pair.first).end1), TableDiffResult.map(rmap2, ((RowDiffRange)pair.first).begin2), TableDiffResult.map(rmap2, ((RowDiffRange)pair.first).end2)), (Object)pair.second));
            }
            for (CellDiff diff : res.cellDiff) {
                this.cellDiff.add(new CellDiff(TableDiffResult.map(rmap1, diff.row1), TableDiffResult.map(cmap1, diff.col1), TableDiffResult.map(rmap2, diff.row2), TableDiffResult.map(cmap2, diff.col2)));
            }
            return this;
        }

        private static int map(@Nullable int[] mapping, int idx) {
            if (mapping == null) {
                return idx;
            }
            if (idx < mapping.length) {
                return mapping[idx];
            }
            int last = mapping.length - 1;
            return idx - last + mapping[last];
        }

        @Nullable
        private static int[] createMapping(TIntArrayList skip) {
            if (skip.isEmpty()) {
                return null;
            }
            int end = skip.get(skip.size() - 1) + 1;
            int[] res = new int[end - skip.size() + 1];
            int s = 0;
            for (int i2 = 0; i2 <= end; ++i2) {
                if (s < skip.size() && i2 == skip.get(s)) {
                    ++s;
                    continue;
                }
                res[i2 - s] = i2;
            }
            return res;
        }

        public boolean isEqual() {
            return this.rowDiff.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "res", "com/intellij/database/diff/TableDiffBuilder$TableDiffResult", "apply"));
        }
    }

    public static class CellDiff {
        public final int row1;
        public final int col1;
        public final int row2;
        public final int col2;

        private CellDiff(int row1, int col1, int row2, int col2) {
            this.row1 = row1;
            this.col1 = col1;
            this.row2 = row2;
            this.col2 = col2;
        }
    }

    public static class RowDiffRange {
        public final int begin1;
        public final int end1;
        public final int begin2;
        public final int end2;

        private RowDiffRange(int begin1, int end1, int begin2, int end2) {
            this.begin1 = begin1;
            this.end1 = end1;
            this.begin2 = begin2;
            this.end2 = end2;
        }

        public DiffType getType() {
            if (this.begin1 == this.end1) {
                return DiffType.INSERT;
            }
            if (this.begin2 == this.end2) {
                return DiffType.REMOVE;
            }
            return DiffType.REPLACE;
        }
    }

    public static enum DiffType {
        INSERT,
        REMOVE,
        REPLACE;

    }

    public static class Data {
        public final List<List<Object>> table1;
        public final List<List<Object>> table2;
        public final TableDiffSettingsHolder.Settings settings;
        public final ProgressIndicator indicator;

        public Data(@NotNull List<List<Object>> table1, @NotNull List<List<Object>> table2, @NotNull TableDiffSettingsHolder.Settings settings, @NotNull ProgressIndicator indicator) {
            if (table1 == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (table2 == null) {
                Data.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                Data.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                Data.$$$reportNull$$$0(3);
            }
            this.table1 = table1;
            this.table2 = table2;
            this.settings = settings;
            this.indicator = indicator;
        }

        public Data skipped(@NotNull TIntArrayList col1, @NotNull TIntArrayList col2) {
            if (col1 == null) {
                Data.$$$reportNull$$$0(4);
            }
            if (col2 == null) {
                Data.$$$reportNull$$$0(5);
            }
            Data res = new Data(ContainerUtil.newArrayList(), ContainerUtil.newArrayList(), this.settings, this.indicator);
            if (!col1.isEmpty()) {
                for (List<Object> row : this.table1) {
                    res.table1.add(TableDiffBuilder.skip(row, col1));
                }
            } else {
                res.table1.addAll(this.table1);
            }
            if (!col2.isEmpty()) {
                for (List<Object> row : this.table2) {
                    res.table2.add(TableDiffBuilder.skip(row, col2));
                }
            } else {
                res.table2.addAll(this.table2);
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "col1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "col2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/diff/TableDiffBuilder$Data";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "skipped";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

