/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SequenceIdentity
implements Cloneable,
Serializable {
    @Nullable
    public final BigInteger min;
    @Nullable
    public final BigInteger next;
    @NotNull
    public final BigInteger increment;
    @Nullable
    public final BigInteger max;
    private static final Pattern SPECIFICATION_PATTERN = Pattern.compile("^\\s*([-+]?\\d+)\\s*(\\(\\s*([-+]?\\d+)\\s*\\)\\s*)?(([-+]\\d+)\\s*)?(\\.\\.([-+]?\\d+)\\s*)?$");

    @NotNull
    public static SequenceIdentity of(@NotNull String specification) {
        String s;
        Matcher m;
        if (specification == null) {
            SequenceIdentity.$$$reportNull$$$0(0);
        }
        if ((m = SPECIFICATION_PATTERN.matcher(s = specification.replace("null", "000"))).matches()) {
            int signum;
            BigInteger grpFrom = SequenceIdentity.grp(m, 1);
            BigInteger grpNext = SequenceIdentity.grp(m, 3);
            BigInteger grpInc = SequenceIdentity.grp(m, 5);
            BigInteger grpTill = SequenceIdentity.grp(m, 7);
            int n = signum = grpInc != null ? grpInc.signum() : 0;
            if (signum >= 0) {
                SequenceIdentity sequenceIdentity = SequenceIdentity.of(grpFrom, grpNext, grpInc, grpTill);
                if (sequenceIdentity == null) {
                    SequenceIdentity.$$$reportNull$$$0(1);
                }
                return sequenceIdentity;
            }
            SequenceIdentity sequenceIdentity = SequenceIdentity.of(grpTill, grpNext, grpInc, grpFrom);
            if (sequenceIdentity == null) {
                SequenceIdentity.$$$reportNull$$$0(2);
            }
            return sequenceIdentity;
        }
        throw new IllegalArgumentException("The string '" + specification + "' is not a valid sequence specification");
    }

    @Nullable
    private static BigInteger grp(Matcher matcher, int groupNr) {
        String s = matcher.group(groupNr);
        return s != null && !s.equalsIgnoreCase("000") ? new BigInteger(s) : null;
    }

    @NotNull
    public static SequenceIdentity of(@Nullable Long min, @Nullable Long next, @Nullable Long increment, @Nullable Long max) {
        SequenceIdentity sequenceIdentity = new SequenceIdentity(min == null ? null : BigInteger.valueOf(min), next == null ? null : BigInteger.valueOf(next), increment == null ? null : BigInteger.valueOf(increment), max == null ? null : BigInteger.valueOf(max));
        if (sequenceIdentity == null) {
            SequenceIdentity.$$$reportNull$$$0(3);
        }
        return sequenceIdentity;
    }

    @NotNull
    public static SequenceIdentity of(@Nullable BigInteger min, @Nullable BigInteger next, @Nullable BigInteger increment, @Nullable BigInteger max) {
        SequenceIdentity sequenceIdentity = new SequenceIdentity(min, next, increment, max);
        if (sequenceIdentity == null) {
            SequenceIdentity.$$$reportNull$$$0(4);
        }
        return sequenceIdentity;
    }

    private SequenceIdentity(@Nullable BigInteger min, @Nullable BigInteger next, @Nullable BigInteger increment, @Nullable BigInteger max) {
        this.min = min;
        this.next = next;
        this.increment = increment == null ? BigInteger.ONE : increment;
        this.max = max;
    }

    public final String getSpecification() {
        StringBuilder b = new StringBuilder(16);
        switch (this.increment.signum()) {
            case 1: {
                if (this.min != null) {
                    b.append(this.min);
                } else {
                    b.append("1");
                }
                if (!this.increment.equals(BigInteger.ONE)) {
                    b.append("+").append(this.increment);
                }
                if (this.max == null) break;
                b.append('.').append('.').append(this.max);
                break;
            }
            case -1: {
                b.append(this.max);
                b.append(this.increment);
                if (this.min == null) break;
                b.append('.').append('.').append(this.min);
                break;
            }
            default: {
                if (this.min != null) {
                    b.append(this.min);
                }
                b.append('.').append('.');
                if (this.max == null) break;
                b.append(this.max);
            }
        }
        return b.toString();
    }

    public String toString() {
        return this.getSpecification();
    }

    protected Object clone() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceIdentity that = (SequenceIdentity)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.next, that.next) && Objects.equals(this.increment, that.increment) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.next, this.increment, this.max);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specification";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/SequenceIdentity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/SequenceIdentity";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

