/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.exasol;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.exasol.ExasolDatabase;
import com.intellij.database.model.exasol.ExasolForeignTable;
import com.intellij.database.model.exasol.ExasolLikeSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ExasolVirtualSchema
extends ExasolLikeSchema {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.EXTERNAL_SCHEMA;
        if (objectKind == null) {
            ExasolVirtualSchema.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public ExasolDatabase getDatabase();

    @Override
    @Nullable
    default public ExasolDatabase getParent() {
        return this.getDatabase();
    }

    @Override
    default public @NotNull @Nullable NamingIdentifyingFamily<? extends ExasolVirtualSchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends ExasolForeignTable> getTables();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.FOREIGN_TABLE);
        if (list == null) {
            ExasolVirtualSchema.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull @NotNull List<? extends Family<? extends BasicElement>> getFamilies() {
        List<NamingIdentifyingFamily<? extends ExasolForeignTable>> list = Collections.singletonList(this.getTables());
        if (list == null) {
            ExasolVirtualSchema.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getIntrospectionTimestamp() {
        return null;
    }

    @Override
    default public boolean isCurrent() {
        return false;
    }

    @Override
    default public boolean isVisible() {
        return false;
    }

    @Override
    @Nullable
    default public String getOwner() {
        return null;
    }

    @NotNull
    default public List<NameValue> getProperties() {
        List<NameValue> list = Collections.emptyList();
        if (list == null) {
            ExasolVirtualSchema.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    default public String getAdapterSchema() {
        return null;
    }

    @Nullable
    default public String getAdapterName() {
        return null;
    }

    @Nullable
    default public Date getLastRefresh() {
        return null;
    }

    @Nullable
    default public String getLastRefreshBy() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String lastRefreshBy;
        Date lastRefresh;
        String adapterName;
        String adapterSchema;
        List<NameValue> properties;
        String owner;
        boolean visible;
        boolean current;
        Date introspectionTimestamp;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer == null) {
            ExasolVirtualSchema.$$$reportNull$$$0(4);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer.accept("IntrospectionTimestamp", PropertyConverter.export(introspectionTimestamp));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", PropertyConverter.export(current));
        }
        if (visible = this.isVisible()) {
            consumer.accept("Visible", PropertyConverter.export(visible));
        }
        if ((owner = this.getOwner()) != null) {
            consumer.accept("Owner", PropertyConverter.export(owner));
        }
        if (!(properties = this.getProperties()).isEmpty()) {
            consumer.accept("Properties", PropertyConverter.exportListOfNameValue(properties));
        }
        if ((adapterSchema = this.getAdapterSchema()) != null) {
            consumer.accept("AdapterSchema", PropertyConverter.export(adapterSchema));
        }
        if ((adapterName = this.getAdapterName()) != null) {
            consumer.accept("AdapterName", PropertyConverter.export(adapterName));
        }
        if ((lastRefresh = this.getLastRefresh()) != null) {
            consumer.accept("LastRefresh", PropertyConverter.export(lastRefresh));
        }
        if ((lastRefreshBy = this.getLastRefreshBy()) != null) {
            consumer.accept("LastRefreshBy", PropertyConverter.export(lastRefreshBy));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "IntrospectionTimestamp", "Current", "Visible", "Owner", "Properties", "AdapterSchema", "AdapterName", "LastRefresh", "LastRefreshBy");
        if (list == null) {
            ExasolVirtualSchema.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/exasol/ExasolVirtualSchema";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/exasol/ExasolVirtualSchema";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

