/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresRoot;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresRole
extends BasicScriptable,
BasicIdentifiedElement,
BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROLE;
        if (objectKind == null) {
            PostgresRole.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Nullable
    public PostgresRoot getRoot();

    @Override
    @Nullable
    default public PostgresRoot getParent() {
        return this.getRoot();
    }

    default public @NotNull @Nullable NamingIdentifyingFamily<? extends PostgresRole> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            PostgresRole.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull @NotNull List<? extends Family<? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            PostgresRole.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    default public boolean isSuperRole() {
        return false;
    }

    default public boolean isInherit() {
        return false;
    }

    default public boolean isCreateRole() {
        return false;
    }

    default public boolean isCreateDb() {
        return false;
    }

    default public boolean isCanLogin() {
        return false;
    }

    default public boolean isReplication() {
        return false;
    }

    default public long getConnectionLimit() {
        return 0L;
    }

    @Nullable
    default public String getValidUntil() {
        return null;
    }

    default public boolean isBypassRls() {
        return false;
    }

    @NotNull
    default public List<String> getConfig() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PostgresRole.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> config;
        boolean bypassRls;
        String validUntil;
        long connectionLimit;
        boolean replication;
        boolean canLogin;
        boolean createDb;
        boolean createRole;
        boolean inherit;
        boolean superRole;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer == null) {
            PostgresRole.$$$reportNull$$$0(4);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (superRole = this.isSuperRole()) {
            consumer.accept("SuperRole", PropertyConverter.export(superRole));
        }
        if (inherit = this.isInherit()) {
            consumer.accept("Inherit", PropertyConverter.export(inherit));
        }
        if (createRole = this.isCreateRole()) {
            consumer.accept("CreateRole", PropertyConverter.export(createRole));
        }
        if (createDb = this.isCreateDb()) {
            consumer.accept("CreateDb", PropertyConverter.export(createDb));
        }
        if (canLogin = this.isCanLogin()) {
            consumer.accept("CanLogin", PropertyConverter.export(canLogin));
        }
        if (replication = this.isReplication()) {
            consumer.accept("Replication", PropertyConverter.export(replication));
        }
        if ((connectionLimit = this.getConnectionLimit()) != 0L) {
            consumer.accept("ConnectionLimit", PropertyConverter.export(connectionLimit));
        }
        if ((validUntil = this.getValidUntil()) != null) {
            consumer.accept("ValidUntil", PropertyConverter.export(validUntil));
        }
        if (bypassRls = this.isBypassRls()) {
            consumer.accept("BypassRls", PropertyConverter.export(bypassRls));
        }
        if (!(config = this.getConfig()).isEmpty()) {
            consumer.accept("Config", PropertyConverter.exportListOfString(config));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "SuperRole", "Inherit", "CreateRole", "CreateDb", "CanLogin", "Replication", "ConnectionLimit", "ValidUntil", "BypassRls", "Config");
        if (list == null) {
            PostgresRole.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/postgres/PostgresRole";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/postgres/PostgresRole";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

