/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.RedshiftExternalTableStorageType;
import com.intellij.database.model.redshift.RedshiftExternalSchema;
import com.intellij.database.model.redshift.RedshiftExternalTableColumn;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftExternalTable
extends BasicTable,
BasicMajorObject,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_TABLE;
        if (objectKind == null) {
            RedshiftExternalTable.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public RedshiftExternalSchema getSchema();

    @Override
    @Nullable
    default public RedshiftExternalSchema getParent() {
        return this.getSchema();
    }

    default public @NotNull @Nullable NamingIdentifyingFamily<? extends RedshiftExternalTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull @NotNull PositioningNamingFamily<? extends RedshiftExternalTableColumn> getColumns();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.COLUMN);
        if (list == null) {
            RedshiftExternalTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull @NotNull List<? extends Family<? extends BasicElement>> getFamilies() {
        List<PositioningNamingFamily<? extends RedshiftExternalTableColumn>> list = Collections.singletonList(this.getColumns());
        if (list == null) {
            RedshiftExternalTable.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Nullable
    default public String getSerializationLib() {
        return null;
    }

    @Nullable
    default public String getInputFormat() {
        return null;
    }

    @Nullable
    default public String getOutputFormat() {
        return null;
    }

    @Nullable
    default public String getLocation() {
        return null;
    }

    @NotNull
    default public RedshiftExternalTableStorageType getStorageType() {
        RedshiftExternalTableStorageType redshiftExternalTableStorageType = RedshiftExternalTableStorageType.UNKNOWN;
        if (redshiftExternalTableStorageType == null) {
            RedshiftExternalTable.$$$reportNull$$$0(3);
        }
        return redshiftExternalTableStorageType;
    }

    @NotNull
    default public List<String> getSerdeProperties() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            RedshiftExternalTable.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    default public List<String> getProps() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            RedshiftExternalTable.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> props;
        List<String> serdeProperties;
        RedshiftExternalTableStorageType storageType;
        String location;
        String outputFormat;
        String inputFormat;
        String serializationLib;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer == null) {
            RedshiftExternalTable.$$$reportNull$$$0(6);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((serializationLib = this.getSerializationLib()) != null) {
            consumer.accept("SerializationLib", PropertyConverter.export(serializationLib));
        }
        if ((inputFormat = this.getInputFormat()) != null) {
            consumer.accept("InputFormat", PropertyConverter.export(inputFormat));
        }
        if ((outputFormat = this.getOutputFormat()) != null) {
            consumer.accept("OutputFormat", PropertyConverter.export(outputFormat));
        }
        if ((location = this.getLocation()) != null) {
            consumer.accept("Location", PropertyConverter.export(location));
        }
        if ((storageType = this.getStorageType()) != null && storageType != RedshiftExternalTableStorageType.UNKNOWN) {
            consumer.accept("StorageType", PropertyConverter.export(storageType));
        }
        if (!(serdeProperties = this.getSerdeProperties()).isEmpty()) {
            consumer.accept("SerdeProperties", PropertyConverter.exportListOfString(serdeProperties));
        }
        if (!(props = this.getProps()).isEmpty()) {
            consumer.accept("Props", PropertyConverter.exportListOfString(props));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "SerializationLib", "InputFormat", "OutputFormat", "Location", "StorageType", "SerdeProperties", "Props");
        if (list == null) {
            RedshiftExternalTable.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/redshift/RedshiftExternalTable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerdeProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProps";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/redshift/RedshiftExternalTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

