/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.run.ui.grid.ResizableCellEditorsSupport;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridTableCellEditor
extends AbstractTableCellEditor {
    public static final String TABLE_CELL_EDITOR_PROPERTY = "tableCellEditor";
    private final DataGrid myGrid;
    private final ModelIndex<DataConsumer.Row> myRowIdx;
    private final ModelIndex<DataConsumer.Column> myColumnIdx;
    private final GridCellEditorFactory myEditorFactory;
    private GridCellEditor myEditor = null;

    public GridTableCellEditor(DataGrid grid, ModelIndex<DataConsumer.Row> rowIdx, ModelIndex<DataConsumer.Column> columnIdx, GridCellEditorFactory editorFactory) {
        this.myGrid = grid;
        this.myRowIdx = rowIdx;
        this.myColumnIdx = columnIdx;
        this.myEditorFactory = editorFactory;
    }

    public GridCellEditor getEditor() {
        return this.myEditor;
    }

    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column2) {
        if (this.myEditorFactory == null) {
            return null;
        }
        if (this.myEditor == null) {
            EventObject e = (EventObject)UIUtil.getClientProperty((Object)table, TableResultView.EDITING_STARTER_CLIENT_PROPERTY_KEY);
            this.myEditor = this.myEditorFactory.createEditor(this.myGrid, this.myRowIdx, this.myColumnIdx, value, e);
            this.myEditor.setEditingListener((Consumer<Object>)((Consumer)object -> {
                this.myGrid.setCommonEditorValue(object);
                Rectangle r = GridTableCellEditor.calculateSelectedRect(table);
                if (r == null) {
                    return;
                }
                table.revalidate();
                table.repaint(r);
            }));
        }
        table.addPropertyChangeListener(TABLE_CELL_EDITOR_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() == GridTableCellEditor.this && evt.getNewValue() != GridTableCellEditor.this) {
                    Disposer.dispose((Disposable)GridTableCellEditor.this.myEditor);
                    table.removePropertyChangeListener(GridTableCellEditor.TABLE_CELL_EDITOR_PROPERTY, this);
                }
            }
        });
        JComponent editorComponent = this.myEditor.isColumnSpanAllowed() ? new GridCellEditorComponentWrapper(this.myEditor) : this.myEditor.getComponent();
        ResizableCellEditorsSupport.allowMaximizing(table, editorComponent, this.myEditor.isMaximizationAllowed());
        return editorComponent;
    }

    public Object getCellEditorValue() {
        return this.myEditor != null ? this.myEditor.getValue() : null;
    }

    public boolean isCellEditable(EventObject e) {
        if (this.myEditorFactory == null) {
            return false;
        }
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return true;
    }

    public boolean stopCellEditing() {
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        if (!this.myGrid.isEditable() && !model.allValuesEqualTo(ModelIndexSet.forRows(this.myGrid, this.myRowIdx.asInteger()), ModelIndexSet.forColumns(this.myGrid, this.myColumnIdx.asInteger()), this.getCellEditorValue())) {
            this.showCannotApplyCellEditorChangesDialog();
            return false;
        }
        return this.myEditor != null && this.myEditor.stop() && super.stopCellEditing();
    }

    public void cancelCellEditing() {
        if (this.myEditor != null) {
            this.myEditor.cancel();
        }
        super.cancelCellEditing();
    }

    @Nullable
    private static Rectangle calculateSelectedRect(@NotNull JTable table) {
        if (table == null) {
            GridTableCellEditor.$$$reportNull$$$0(0);
        }
        int[] rows = table.getSelectedRows();
        int[] columns2 = table.getSelectedColumns();
        Rectangle selected = null;
        for (int row : rows) {
            for (int column2 : columns2) {
                Rectangle rect = table.getCellRect(row, column2, true);
                selected = selected == null ? rect : selected.union(rect);
            }
        }
        return selected;
    }

    private void showCannotApplyCellEditorChangesDialog() {
        ModalityState currentModality;
        Application application = ApplicationManager.getApplication();
        ModalityState gridModality = application.getModalityStateForComponent((Component)this.myGrid.getComponent());
        if (Comparing.equal((Object)gridModality, (Object)(currentModality = application.getCurrentModalityState())) && this.myGrid.getComponent().isShowing()) {
            DataGridUtil.showCannotApplyCellEditorChanges(this.myGrid);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/GridTableCellEditor", "calculateSelectedRect"));
    }

    private static class GridCellEditorComponentWrapper
    extends JComponent
    implements ResizableCellEditorsSupport.ResizableCellEditor {
        private final GridCellEditor myEditor;
        private boolean myWidthChangeEnabled;
        private KeyEvent myCurrentEvent;

        public GridCellEditorComponentWrapper(@NotNull GridCellEditor editor) {
            if (editor == null) {
                GridCellEditorComponentWrapper.$$$reportNull$$$0(0);
            }
            this.myWidthChangeEnabled = true;
            this.myCurrentEvent = null;
            this.myEditor = editor;
            this.setLayout(new BorderLayout());
            this.add((Component)editor.getComponent(), "Center");
            this.setFocusable(false);
        }

        @Override
        public void setWidthChangeEnabled(boolean b) {
            this.myWidthChangeEnabled = b;
        }

        @Override
        @NotNull
        public ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection getHorizontalResizeDirection() {
            Editor editor;
            if (this.myEditor instanceof GridCellEditor.EditorBased && (editor = ((GridCellEditor.EditorBased)((Object)this.myEditor)).getEditor()) instanceof EditorImpl && ((EditorImpl)editor).isRightAligned()) {
                ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection horizontalResizeDirection = ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection.LEFT;
                if (horizontalResizeDirection == null) {
                    GridCellEditorComponentWrapper.$$$reportNull$$$0(1);
                }
                return horizontalResizeDirection;
            }
            ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection horizontalResizeDirection = ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection.RIGHT;
            if (horizontalResizeDirection == null) {
                GridCellEditorComponentWrapper.$$$reportNull$$$0(2);
            }
            return horizontalResizeDirection;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(this.myWidthChangeEnabled ? x : this.getX(), y, this.myWidthChangeEnabled ? width : this.getWidth(), height);
        }

        @Override
        public void requestFocus() {
            if (this.getComponentCount() == 1) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.getComponent(0), true));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (condition == 0 && this.myCurrentEvent != e && this.getComponentCount() == 1) {
                try {
                    this.myCurrentEvent = e;
                    this.getComponent(0).dispatchEvent(e);
                }
                finally {
                    this.myCurrentEvent = null;
                }
            }
            return e.isConsumed() || super.processKeyBinding(ks, e, condition, pressed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridTableCellEditor$GridCellEditorComponentWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridTableCellEditor$GridCellEditorComponentWrapper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHorizontalResizeDirection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

