/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMarkupModelImpl<Row, Column>
implements GridMarkupModel<Row, Column> {
    private final List<GridMarkupModel.CellHighlighting> myCellHighlightings = ContainerUtil.newArrayList();
    private final List<GridMarkupModel.HeaderHighlighting<Row>> myRowHeaderHighlightings = ContainerUtil.newArrayList();
    private final List<GridMarkupModel.HeaderHighlighting<Column>> myColumnHeaderHighlightings = ContainerUtil.newArrayList();
    private static final Comparator<GridMarkupModel.Highlighting> highlightingComparator = (o1, o2) -> {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null ? 0 : (o1 == null ? -1 : 1);
        }
        return Comparing.compare((int)o1.getLevel(), (int)o2.getLevel());
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CellAttributes getCellAttributes(@NotNull ModelIndex<Row> row, @NotNull ModelIndex<Column> column2, @NotNull GridColorsScheme scheme) {
        if (row == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(0);
        }
        if (column2 == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(1);
        }
        if (scheme == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(2);
        }
        List<GridMarkupModel.CellHighlighting> list = this.myCellHighlightings;
        synchronized (list) {
            CellAttributes res = null;
            ArrayList tmp = ContainerUtil.newArrayList();
            for (GridMarkupModel.CellHighlighting cellHighlighting : this.myCellHighlightings) {
                if (!cellHighlighting.contains(row.asInteger(), column2.asInteger())) continue;
                tmp.add(cellHighlighting);
            }
            Collections.sort(tmp, highlightingComparator);
            for (GridMarkupModel.Highlighting highlighting : tmp) {
                res = CellAttributes.merge(res, scheme.getAttributes(highlighting.getAttributes()));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CellAttributes getRowHeaderAttributes(@NotNull ModelIndex<Row> row, @NotNull GridColorsScheme scheme) {
        if (row == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(3);
        }
        if (scheme == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(4);
        }
        List<GridMarkupModel.HeaderHighlighting<Row>> list = this.myRowHeaderHighlightings;
        synchronized (list) {
            CellAttributes res = null;
            ArrayList tmp = ContainerUtil.newArrayList();
            for (GridMarkupModel.HeaderHighlighting<Row> headerHighlighting : this.myRowHeaderHighlightings) {
                if (!headerHighlighting.contains(row.asInteger())) continue;
                tmp.add(headerHighlighting);
            }
            Collections.sort(tmp, highlightingComparator);
            for (GridMarkupModel.Highlighting highlighting : tmp) {
                res = CellAttributes.merge(res, scheme.getAttributes(highlighting.getAttributes()));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public GridMarkupModel.CellHighlighting highlightCells(@NotNull ModelIndexSet<Row> rows, @NotNull ModelIndexSet<Column> columns2, @NotNull CellAttributesKey attributes, int level) {
        if (rows == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(5);
        }
        if (columns2 == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(6);
        }
        if (attributes == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(7);
        }
        List<GridMarkupModel.CellHighlighting> list = this.myCellHighlightings;
        // MONITORENTER : list
        CellHighlightingImpl res = new CellHighlightingImpl(rows, columns2, attributes, level);
        this.myCellHighlightings.add(res);
        CellHighlightingImpl cellHighlightingImpl = res;
        // MONITOREXIT : list
        if (cellHighlightingImpl != null) return cellHighlightingImpl;
        GridMarkupModelImpl.$$$reportNull$$$0(8);
        return cellHighlightingImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellHighlighting(@NotNull GridMarkupModel.CellHighlighting highlighting) {
        if (highlighting == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(9);
        }
        List<GridMarkupModel.CellHighlighting> list = this.myCellHighlightings;
        synchronized (list) {
            this.myCellHighlightings.remove(highlighting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllCellHighlightings(@NotNull Collection<GridMarkupModel.CellHighlighting> highlightings) {
        if (highlightings == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(10);
        }
        List<GridMarkupModel.CellHighlighting> list = this.myCellHighlightings;
        synchronized (list) {
            this.myCellHighlightings.removeAll(highlightings);
        }
    }

    @Override
    public void removeHighlighting(@NotNull GridMarkupModel.Highlighting highlighting) {
        if (highlighting == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(11);
        }
        if (highlighting instanceof GridMarkupModel.CellHighlighting) {
            this.removeCellHighlighting((GridMarkupModel.CellHighlighting)highlighting);
        } else if (highlighting instanceof GridMarkupModel.HeaderHighlighting) {
            this.removeRowHeaderHighlighting((GridMarkupModel.HeaderHighlighting)highlighting);
            this.removeColumnHeaderHighlighting((GridMarkupModel.HeaderHighlighting)highlighting);
        }
    }

    @Override
    public void removeAllHighlightings(@NotNull Collection<GridMarkupModel.Highlighting> highlightings) {
        if (highlightings == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(12);
        }
        for (GridMarkupModel.Highlighting highlighting : highlightings) {
            this.removeHighlighting(highlighting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public GridMarkupModel.HeaderHighlighting<Row> highlightRowHeaders(@NotNull ModelIndexSet<Row> rows, @NotNull CellAttributesKey attributes, int level) {
        if (rows == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(13);
        }
        if (attributes == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(14);
        }
        List<GridMarkupModel.HeaderHighlighting<Row>> list = this.myRowHeaderHighlightings;
        // MONITORENTER : list
        HeaderHighlightingImpl res = new HeaderHighlightingImpl(rows, attributes, level);
        this.myRowHeaderHighlightings.add(res);
        HeaderHighlightingImpl headerHighlightingImpl = res;
        // MONITOREXIT : list
        if (headerHighlightingImpl != null) return headerHighlightingImpl;
        GridMarkupModelImpl.$$$reportNull$$$0(15);
        return headerHighlightingImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRowHeaderHighlighting(@NotNull GridMarkupModel.HeaderHighlighting<Row> highlighting) {
        if (highlighting == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(16);
        }
        List<GridMarkupModel.HeaderHighlighting<Row>> list = this.myRowHeaderHighlightings;
        synchronized (list) {
            this.myRowHeaderHighlightings.remove(highlighting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllRowHeaderHighlightings(@NotNull Collection<GridMarkupModel.HeaderHighlighting<Row>> highlightings) {
        if (highlightings == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(17);
        }
        List<GridMarkupModel.HeaderHighlighting<Row>> list = this.myRowHeaderHighlightings;
        synchronized (list) {
            this.myRowHeaderHighlightings.removeAll(highlightings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CellAttributes getColumnHeaderAttributes(@NotNull ModelIndex<Column> column2, @NotNull GridColorsScheme scheme) {
        if (column2 == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(18);
        }
        if (scheme == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(19);
        }
        List<GridMarkupModel.HeaderHighlighting<Column>> list = this.myColumnHeaderHighlightings;
        synchronized (list) {
            CellAttributes res = null;
            ArrayList tmp = ContainerUtil.newArrayList();
            for (GridMarkupModel.HeaderHighlighting<Column> headerHighlighting : this.myColumnHeaderHighlightings) {
                if (!headerHighlighting.contains(column2.asInteger())) continue;
                tmp.add(headerHighlighting);
            }
            Collections.sort(tmp, highlightingComparator);
            for (GridMarkupModel.Highlighting highlighting : tmp) {
                res = CellAttributes.merge(res, scheme.getAttributes(highlighting.getAttributes()));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public GridMarkupModel.HeaderHighlighting<Column> highlightColumnHeaders(@NotNull ModelIndexSet<Column> columns2, @NotNull CellAttributesKey attributes, int level) {
        if (columns2 == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(20);
        }
        if (attributes == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(21);
        }
        List<GridMarkupModel.HeaderHighlighting<Column>> list = this.myColumnHeaderHighlightings;
        // MONITORENTER : list
        HeaderHighlightingImpl res = new HeaderHighlightingImpl(columns2, attributes, level);
        this.myColumnHeaderHighlightings.add(res);
        HeaderHighlightingImpl headerHighlightingImpl = res;
        // MONITOREXIT : list
        if (headerHighlightingImpl != null) return headerHighlightingImpl;
        GridMarkupModelImpl.$$$reportNull$$$0(22);
        return headerHighlightingImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeColumnHeaderHighlighting(@NotNull GridMarkupModel.HeaderHighlighting<Column> highlighting) {
        if (highlighting == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(23);
        }
        List<GridMarkupModel.HeaderHighlighting<Column>> list = this.myColumnHeaderHighlightings;
        synchronized (list) {
            this.myColumnHeaderHighlightings.remove(highlighting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllColumnHeaderHighlightings(@NotNull Collection<GridMarkupModel.HeaderHighlighting<Column>> highlightings) {
        if (highlightings == null) {
            GridMarkupModelImpl.$$$reportNull$$$0(24);
        }
        List<GridMarkupModel.HeaderHighlighting<Column>> list = this.myColumnHeaderHighlightings;
        synchronized (list) {
            this.myColumnHeaderHighlightings.removeAll(highlightings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<GridMarkupModel.Highlighting> list = this.myCellHighlightings;
        synchronized (list) {
            this.myCellHighlightings.clear();
        }
        list = this.myRowHeaderHighlightings;
        synchronized (list) {
            this.myRowHeaderHighlightings.clear();
        }
        list = this.myColumnHeaderHighlightings;
        synchronized (list) {
            this.myColumnHeaderHighlightings.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 15: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 15: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 7: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 8: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridMarkupModelImpl";
                break;
            }
            case 9: 
            case 11: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighting";
                break;
            }
            case 10: 
            case 12: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridMarkupModelImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightCells";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightRowHeaders";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightColumnHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCellAttributes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRowHeaderAttributes";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "highlightCells";
                break;
            }
            case 8: 
            case 15: 
            case 22: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeCellHighlighting";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeAllCellHighlightings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighting";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeAllHighlightings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "highlightRowHeaders";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeRowHeaderHighlighting";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRowHeaderHighlightings";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getColumnHeaderAttributes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "highlightColumnHeaders";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeColumnHeaderHighlighting";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeAllColumnHeaderHighlightings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 15: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HeaderHighlightingImpl<S>
    extends AbstractHighlighting
    implements GridMarkupModel.HeaderHighlighting<S> {
        private final TIntHashSet myRowOrCols;

        private HeaderHighlightingImpl(ModelIndexSet<S> rows, CellAttributesKey attributes, int level) {
            super(attributes, level);
            this.myRowOrCols = new TIntHashSet(rows.asArray());
        }

        @Override
        public boolean contains(int rowOrCol) {
            return this.myRowOrCols.contains(rowOrCol);
        }
    }

    private static class CellHighlightingImpl
    extends AbstractHighlighting
    implements GridMarkupModel.CellHighlighting {
        private final TIntHashSet myColumns;
        private final TIntHashSet myRows;

        private <Row, Column> CellHighlightingImpl(ModelIndexSet<Row> rows, ModelIndexSet<Column> columns2, CellAttributesKey attributes, int level) {
            super(attributes, level);
            this.myColumns = new TIntHashSet(columns2.asArray());
            this.myRows = new TIntHashSet(rows.asArray());
        }

        @Override
        public boolean contains(int row, int column2) {
            return this.myColumns.contains(column2) && this.myRows.contains(row);
        }
    }

    private static abstract class AbstractHighlighting
    implements GridMarkupModel.Highlighting {
        private final CellAttributesKey myAttributes;
        private final int myLevel;

        private AbstractHighlighting(CellAttributesKey attributes, int level) {
            this.myAttributes = attributes;
            this.myLevel = level;
        }

        @Override
        @NotNull
        public CellAttributesKey getAttributes() {
            CellAttributesKey cellAttributesKey = this.myAttributes;
            if (cellAttributesKey == null) {
                AbstractHighlighting.$$$reportNull$$$0(0);
            }
            return cellAttributesKey;
        }

        @Override
        public int getLevel() {
            return this.myLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMarkupModelImpl$AbstractHighlighting", "getAttributes"));
        }
    }
}

