/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeColumn
extends DeTableChild
implements DasColumn {
    @NotNull
    public String dataType;
    @Nullable
    public String defaultValue;
    @NotNull
    public final Set<Flag> flags;

    protected DeColumn(@NotNull DeModel model) {
        if (model == null) {
            DeColumn.$$$reportNull$$$0(0);
        }
        super(model);
        this.dataType = "int";
        this.defaultValue = null;
        this.flags = ContainerUtil.newHashSet();
    }

    public DeColumn(@NotNull String name, @NotNull DeTable parent, @NotNull DeModel model) {
        if (name == null) {
            DeColumn.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            DeColumn.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DeColumn.$$$reportNull$$$0(3);
        }
        super(name, parent, model);
        this.dataType = "int";
        this.defaultValue = null;
        this.flags = ContainerUtil.newHashSet();
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children, @NotNull Collection<? extends DasObject> otherChildren) {
        if (other == null) {
            DeColumn.$$$reportNull$$$0(4);
        }
        if (children == null) {
            DeColumn.$$$reportNull$$$0(5);
        }
        if (otherChildren == null) {
            DeColumn.$$$reportNull$$$0(6);
        }
        DeColumn otherColumn = (DeColumn)other;
        return !this.dataType.equals(otherColumn.dataType) || !Comparing.equal((String)this.defaultValue, (String)otherColumn.defaultValue) || !Comparing.haveEqualElements(this.flags, otherColumn.flags) || super.isAlteredIgnoringChild(other, children, otherChildren);
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            DeColumn.$$$reportNull$$$0(7);
        }
        DeColumn deColumn = new DeColumn(model);
        if (deColumn == null) {
            DeColumn.$$$reportNull$$$0(8);
        }
        return deColumn;
    }

    public boolean isInTable() {
        return this.table.columns.contains(this);
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            DeColumn.$$$reportNull$$$0(9);
        }
        if (copier == null) {
            DeColumn.$$$reportNull$$$0(10);
        }
        super.copyFrom(obj, withChildren, copier);
        DeColumn col = (DeColumn)obj;
        this.dataType = col.dataType;
        this.defaultValue = col.defaultValue;
        this.flags.clear();
        this.flags.addAll(col.flags);
        DeColumn deColumn = this;
        if (deColumn == null) {
            DeColumn.$$$reportNull$$$0(11);
        }
        return deColumn;
    }

    @NotNull
    public DataType getDataType() {
        DataType dataType;
        try {
            dataType = DataTypeFactory.of(this.dataType);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        if (dataType == null) {
            DeColumn.$$$reportNull$$$0(12);
        }
        return dataType;
    }

    public boolean isNotNull() {
        return this.flags.contains((Object)Flag.NOT_NULL);
    }

    @Nullable
    public String getDefault() {
        return this.defaultValue;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.COLUMN;
        if (objectKind == null) {
            DeColumn.$$$reportNull$$$0(13);
        }
        return objectKind;
    }

    public boolean isEnabled() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherChildren";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeColumn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeColumn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyClone";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAlteredIgnoringChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "emptyClone";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Flag {
        NOT_NULL,
        AUTO_INC;

    }
}

