/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.scripting.AbstractCodeGenerator$WhenMappings;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.Effect;
import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.NamingServices;
import com.intellij.database.scripting.Node;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.Producer;
import com.intellij.database.scripting.RequiredEffect;
import com.intellij.database.scripting.Scenario;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingHelper;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.database.scripting.SimpleProducer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u0000 x2\u00020\u0001:\u0003xyzB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\n\b\u0002\u00107\u001a\u0004\u0018\u00010'H\u0004J\u0016\u00108\u001a\u00020/2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\u0016\u0010<\u001a\u00020/2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0014J\b\u0010=\u001a\u000204H\u0002J\u0010\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020@H\u0014J,\u0010A\u001a\u0002042\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010B\u001a\u00020/2\f\u0010C\u001a\b\u0012\u0004\u0012\u0002040DH\u0004J\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020;0F2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020;0HH\u0014J\b\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010:H\u0002J\u0016\u0010L\u001a\u00020M2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J3\u0010N\u001a\u0002042\u0006\u0010O\u001a\u00020;2\u0006\u0010P\u001a\u00020;2\u0018\u0010Q\u001a\u0014\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002040RH\u0082\bJ\"\u0010S\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;0T2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020;0UH\u0002J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020W0:H\u0016J\b\u0010X\u001a\u00020!H\u0007J\b\u0010Y\u001a\u00020/H\u0014J\u0010\u0010Z\u001a\u00020;2\u0006\u0010[\u001a\u00020'H\u0002J\u0012\u0010\\\u001a\u0004\u0018\u00010;2\u0006\u0010?\u001a\u00020@H\u0017J\b\u0010]\u001a\u00020;H\u0002J\b\u0010^\u001a\u000204H\u0002J\u0010\u0010^\u001a\u0002042\u0006\u0010_\u001a\u00020`H\u0002J\b\u0010a\u001a\u00020/H\u0014J\b\u0010b\u001a\u000204H\u0002J\b\u0010c\u001a\u000204H&J(\u0010d\u001a\u0002042\f\u0010G\u001a\b\u0012\u0004\u0012\u00020;0U2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002040fJ\u0006\u0010g\u001a\u000204J\u0010\u0010g\u001a\u0002042\u0006\u0010h\u001a\u00020;H\u0016J\b\u0010i\u001a\u000204H\u0016J\u0010\u0010j\u001a\u00020'2\u0006\u0010k\u001a\u00020lH\u0014J\b\u0010m\u001a\u000204H\u0016J\u0012\u0010n\u001a\u00020/2\b\u0010o\u001a\u0004\u0018\u00010'H\u0014J/\u0010p\u001a\u000204*\u00020\b2\b\u0010q\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010r\u001a\u00020/2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020'0DH\u0084\bJ\u0018\u0010t\u001a\u00020'*\u00020@2\n\b\u0002\u00107\u001a\u0004\u0018\u00010'H\u0014J)\u0010u\u001a\u000204*\u00020\b2\u0016\u0010u\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010'0v\"\u0004\u0018\u00010'H\u0004\u00a2\u0006\u0002\u0010wR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0019\u0010&\u001a\u00020'*\u00020'8\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001f\u0010&\u001a\u00020'*\b\u0012\u0004\u0012\u00020'0*8\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010+R\u0018\u0010,\u001a\u00020'*\u00020'8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010)R\u0018\u0010.\u001a\u00020/*\u0002008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006{"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator;", "", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "builder", "Lcom/intellij/database/scripting/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/scripting/CodeTextBuilder;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "getCategory", "()Lcom/intellij/database/scripting/ScriptCategory;", "getContext", "()Lcom/intellij/database/scripting/ScriptingContext;", "helper", "Lcom/intellij/database/scripting/ScriptingHelper;", "getHelper", "()Lcom/intellij/database/scripting/ScriptingHelper;", "<set-?>", "Lcom/intellij/database/scripting/ScriptLocus;", "locus", "getLocus", "()Lcom/intellij/database/scripting/ScriptLocus;", "setLocus", "(Lcom/intellij/database/scripting/ScriptLocus;)V", "naming", "Lcom/intellij/database/scripting/NamingService;", "getNaming", "()Lcom/intellij/database/scripting/NamingService;", "scenario", "Lcom/intellij/database/scripting/Scenario;", "getScenario", "()Lcom/intellij/database/scripting/Scenario;", "getTask", "()Lcom/intellij/database/scripting/ScriptingTask;", "scr", "", "getScr", "(Ljava/lang/String;)Ljava/lang/String;", "", "(Ljava/lang/Iterable;)Ljava/lang/String;", "sqlString", "getSqlString", "useName", "", "Lcom/intellij/database/model/basic/BasicNamedElement;", "getUseName", "(Lcom/intellij/database/model/basic/BasicNamedElement;)Z", "alterTable", "", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "rename", "breakByEdge", "cycle", "", "Lcom/intellij/database/scripting/Operation;", "breakCycle", "breakCycles", "canQualify", "element", "Lcom/intellij/database/model/basic/BasicElement;", "coding", "indent", "block", "Lkotlin/Function0;", "createPreOrderComparator", "Ljava/util/Comparator;", "operations", "", "createRootProducer", "Lcom/intellij/database/scripting/Producer;", "findCycle", "findCycleMin", "", "forEachEdge", "op1", "op2", "action", "Lkotlin/Function2;", "generateSuccessors", "Lcom/intellij/util/containers/MultiMap;", "", "getEdgeFixers", "Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "getInternalScenario", "isNewCodeGen", "makeFileSink", "file", "makeOperation", "makeTextSink", "postStatement", "statement", "Lcom/intellij/database/scripting/CompositeText;", "preferForward", "prepareOutput", "prepareScenario", "processOperations", "processor", "Lkotlin/Function1;", "produce", "op", "resolve", "script", "d", "Lcom/intellij/database/model/DataType;", "transform", "useSchemaName", "schemaName", "appendOrErr", "text", "eoln", "error", "currentScopeName", "words", "", "(Lcom/intellij/database/scripting/CodeTextBuilder;[Ljava/lang/String;)V", "Companion", "EdgeFixer", "PreOrderComparator", "intellij.database.scripting"})
public abstract class AbstractCodeGenerator {
    @NotNull
    private final NamingService naming;
    @NotNull
    private final ScriptingHelper helper;
    @NotNull
    private final Scenario scenario;
    @NotNull
    private final CodeTextBuilder builder;
    @NotNull
    private ScriptLocus locus;
    @NotNull
    private final ScriptingContext context;
    @NotNull
    private final ScriptingTask task;
    @NotNull
    private static final OperationType ROOT;
    @NotNull
    private static final OperationType TEXT_SINK;
    @NotNull
    private static final OperationType FILE_SINK;
    public static final Companion Companion;

    @NotNull
    protected final ScriptCategory getCategory() {
        return this.getTask().getCategory();
    }

    @NotNull
    protected final NamingService getNaming() {
        return this.naming;
    }

    @NotNull
    protected final ScriptingHelper getHelper() {
        return this.helper;
    }

    @NotNull
    protected final Scenario getScenario() {
        return this.scenario;
    }

    @NotNull
    protected final CodeTextBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    protected final ScriptLocus getLocus() {
        return this.locus;
    }

    private final void setLocus(ScriptLocus scriptLocus) {
        this.locus = scriptLocus;
    }

    @NotNull
    protected Comparator<Operation> createPreOrderComparator(@NotNull Collection<Operation> operations) {
        Intrinsics.checkParameterIsNotNull(operations, (String)"operations");
        return new PreOrderComparator();
    }

    public abstract void prepareScenario();

    private final Producer createRootProducer() {
        return new SimpleProducer(Companion.getROOT(), (Function1<? super Producer, Unit>)((Function1)new Function1<Producer, Unit>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            public final void invoke(@NotNull Producer $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.processOperations($receiver.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)new Function1<Operation, Unit>(this.this$0){

                    public final void invoke(@NotNull Operation p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((AbstractCodeGenerator)this.receiver).produce(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractCodeGenerator.class);
                    }

                    public final String getName() {
                        return "produce";
                    }

                    public final String getSignature() {
                        return "produce(Lcom/intellij/database/scripting/Operation;)V";
                    }
                }));
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        }));
    }

    @Nullable
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return null;
    }

    public void resolve() {
        Operation it;
        JBIterable operations;
        LinkedHashMap<Effect, Operation> effects = new LinkedHashMap<Effect, Operation>();
        JBIterable jBIterable = operations = this.scenario.traverse().bfsTraversal();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"operations");
        Iterable $receiver$iv = (Iterable)jBIterable;
        for (Object element$iv : $receiver$iv) {
            it = (Operation)element$iv;
            Iterable $receiver$iv2 = it.getEffects();
            for (Object element$iv2 : $receiver$iv2) {
                boolean bl;
                Effect e = (Effect)element$iv2;
                Operation prev = effects.put(e, it);
                boolean bl2 = bl = prev == null;
                if (!_Assertions.ENABLED || bl) continue;
                String string = "Effect " + e + " provided by " + it + " and " + prev;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        $receiver$iv = (Iterable)operations;
        for (Object element$iv : $receiver$iv) {
            it = (Operation)element$iv;
            it.unlinkAll();
            JBIterable jBIterable2 = JBIterable.from((Iterable)it.getRequires()).flatten(new Function<E, Iterable<? extends T>>(effects){
                final /* synthetic */ LinkedHashMap $effects$inlined;
                {
                    this.$effects$inlined = linkedHashMap;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Operation> fun(RequiredEffect it) {
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    RequiredEffect requiredEffect = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)requiredEffect, (String)"it");
                    Set<K> set = this.$effects$inlined.keySet();
                    Intrinsics.checkExpressionValueIsNotNull(set, (String)"effects.keys");
                    Iterable iterable = (Iterable)ScenarioOperations.expand(requiredEffect, (Iterable<Effect>)set);
                    LinkedHashMap linkedHashMap = this.$effects$inlined;
                    void var4_4 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    void $receiver$iv$iv$iv = $receiver$iv$iv;
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        Operation operation;
                        T element$iv$iv = element$iv$iv$iv;
                        Effect p1 = (Effect)element$iv$iv;
                        if ((Operation)linkedHashMap.get(p1) == null) continue;
                        Operation it$iv$iv = operation;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"JBIterable.from(it.requi\u2026apNotNull(effects::get) }");
            it.link((Iterable)jBIterable2);
        }
    }

    public void transform() {
        this.breakCycles();
        this.prepareOutput();
    }

    private final void breakCycles() {
        List<Operation> cycle;
        do {
            if (this.findCycle() != null) continue;
            return;
        } while (this.breakCycle(cycle));
    }

    protected boolean breakCycle(@NotNull List<Operation> cycle) {
        Intrinsics.checkParameterIsNotNull(cycle, (String)"cycle");
        return this.breakByEdge(cycle);
    }

    protected boolean preferForward() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakByEdge(List<Operation> cycle) {
        int size;
        int s = this.findCycleMin(cycle);
        int i2 = size = cycle.size();
        Object t = ((Operation)CollectionsKt.first(cycle)).getParent();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        Operation root2 = (Operation)t;
        List<EdgeFixer> fixers = this.getEdgeFixers();
        if (fixers.isEmpty()) {
            return false;
        }
        while (i2 >= 0) {
            int p = s + i2 + size;
            Operation cur = cycle.get(p % size);
            Operation next = cycle.get((p + 1) % size);
            boolean fwOnly = i2 == 0;
            boolean bkOnly = i2 == size;
            AbstractCodeGenerator this_$iv = this;
            HashSet targets$iv = (HashSet)ScenarioOperations.traverse(cur).traverse().addAllTo((Collection)new HashSet());
            JBTreeTraverser<Operation> jBTreeTraverser = ScenarioOperations.traverse(next);
            Intrinsics.checkExpressionValueIsNotNull(jBTreeTraverser, (String)"op2.traverse()");
            Iterable $receiver$iv$iv = (Iterable)jBTreeTraverser;
            for (Object element$iv$iv : $receiver$iv$iv) {
                Operation so2$iv = (Operation)element$iv$iv;
                Iterable $receiver$iv$iv2 = so2$iv.getPreceders();
                for (Object element$iv$iv2 : $receiver$iv$iv2) {
                    Operation so1$iv = (Operation)element$iv$iv2;
                    if (!targets$iv.contains(so1$iv)) continue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)so2$iv, (String)"so2");
                    Operation so1 = so1$iv;
                    Iterable $receiver$iv = fixers;
                    for (Object element$iv : $receiver$iv) {
                        void so2;
                        EdgeFixer it = (EdgeFixer)element$iv;
                        if (fwOnly && it.isBackward() || bkOnly && !it.isBackward() || !it.fix(root2, so1, (Operation)so2)) continue;
                        if (it.requiresResolve()) {
                            this.resolve();
                        }
                        return true;
                    }
                }
            }
            --i2;
        }
        return false;
    }

    private final int findCycleMin(List<Operation> cycle) {
        Comparator<Operation> cmp = this.createPreOrderComparator((Collection<Operation>)cycle);
        int mini = 0;
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)1, (int)cycle.size());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            if (cmp.compare(cycle.get(mini), cycle.get(it)) <= 0) continue;
            mini = it;
        }
        return mini;
    }

    private final void forEachEdge(Operation op1, Operation op2, Function2<? super Operation, ? super Operation, Unit> action) {
        HashSet targets = (HashSet)ScenarioOperations.traverse(op1).traverse().addAllTo((Collection)new HashSet());
        JBTreeTraverser<Operation> jBTreeTraverser = ScenarioOperations.traverse(op2);
        Intrinsics.checkExpressionValueIsNotNull(jBTreeTraverser, (String)"op2.traverse()");
        Iterable $receiver$iv = (Iterable)jBTreeTraverser;
        for (Object element$iv : $receiver$iv) {
            Operation so2 = (Operation)element$iv;
            Iterable $receiver$iv2 = so2.getPreceders();
            for (Object element$iv2 : $receiver$iv2) {
                Operation so1 = (Operation)element$iv2;
                if (!targets.contains(so1)) continue;
                Operation operation = so2;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"so2");
                action.invoke((Object)so1, (Object)operation);
            }
        }
    }

    @NotNull
    public List<EdgeFixer> getEdgeFixers() {
        return CollectionsKt.emptyList();
    }

    private final List<Operation> findCycle() {
        HashSet<Operation> visited = new HashSet<Operation>();
        JBTreeTraverser traverser2 = (JBTreeTraverser)ScenarioOperations.traversePreceders().expandAndFilter((Condition)new Condition<Operation>(visited){
            final /* synthetic */ HashSet $visited;

            public final boolean value(Operation it) {
                return !this.$visited.contains(it);
            }
            {
                this.$visited = hashSet;
            }
        });
        JBIterable jBIterable = this.scenario.traverse().bfsTraversal().filter((Condition)new Condition<Operation>(visited){
            final /* synthetic */ HashSet $visited;

            public final boolean value(Operation it) {
                return !this.$visited.contains(it);
            }
            {
                this.$visited = hashSet;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"scenario.traverse().bfsT\u2026.filter{ it !in visited }");
        Iterable $receiver$iv = (Iterable)jBIterable;
        for (Object element$iv : $receiver$iv) {
            Operation root2 = (Operation)element$iv;
            TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)((JBTreeTraverser)traverser2.withRoot((Object)root2)).biOrderDfsTraversal().typedIterator();
            while (it.advance()) {
                Operation op;
                Operation operation = op = (Operation)it.current();
                int n = operation.getIncidence();
                TreeTraversal.TracingIt tracingIt = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)tracingIt, (String)"it");
                operation.setIncidence(n + (tracingIt.isDescending() ? 1 : -1));
                if (!it.isDescending()) {
                    visited.add(op);
                }
                if (op.getIncidence() < 2) continue;
                LinkedList<Operation> res = new LinkedList<Operation>();
                boolean add = true;
                JBIterable jBIterable2 = it.backtrace();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"it.backtrace()");
                Iterable $receiver$iv2 = (Iterable)jBIterable2;
                for (Object element$iv2 : $receiver$iv2) {
                    Operation it2 = (Operation)element$iv2;
                    it2.setIncidence(0);
                    if (add) {
                        boolean bl = add = res.isEmpty() || Intrinsics.areEqual((Object)it2, (Object)op) ^ true;
                    }
                    if (!add) continue;
                    res.add(it2);
                }
                return res;
            }
        }
        return null;
    }

    private final void prepareOutput() {
        Operation sink = this.makeTextSink();
        sink.stealChildrenFrom((Node)this.scenario.getRoot());
        sink.setParent((Node)this.scenario.getRoot());
    }

    public final void processOperations(@NotNull Set<Operation> operations, @NotNull Function1<? super Operation, Unit> processor) {
        Intrinsics.checkParameterIsNotNull(operations, (String)"operations");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Comparator<Operation> cmp = this.createPreOrderComparator((Collection<Operation>)operations);
        MultiMap<Operation, Operation> successors = this.generateSuccessors(operations);
        TreeSet<Operation> queue = new TreeSet<Operation>(cmp);
        Iterable $receiver$iv = operations;
        for (Object element$iv : $receiver$iv) {
            Operation it = (Operation)element$iv;
            if (it.getIncidence() != 0) continue;
            queue.add(it);
        }
        while (!queue.isEmpty()) {
            Operation op = queue.pollFirst();
            Collection rev = successors.remove((Object)op);
            if (rev == null) continue;
            Operation operation = op;
            Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"op");
            processor.invoke((Object)operation);
            Iterable $receiver$iv2 = rev;
            for (Object element$iv : $receiver$iv2) {
                Operation it;
                Operation operation2 = it = (Operation)element$iv;
                operation2.setIncidence(operation2.getIncidence() + -1);
                operation2.getIncidence();
                if (it.getIncidence() != 0) continue;
                queue.add(it);
            }
        }
        boolean bl = successors.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Found cycle";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private final MultiMap<Operation, Operation> generateSuccessors(Set<Operation> operations) {
        MultiMap successors = MultiMap.createSet();
        Iterable $receiver$iv = operations;
        for (Object element$iv : $receiver$iv) {
            Operation op = (Operation)element$iv;
            Set<Operation> flatPreceders = op.getFlatPreceders();
            successors.getModifiable((Object)op);
            Iterable $receiver$iv2 = flatPreceders;
            for (Object element$iv2 : $receiver$iv2) {
                Operation p = (Operation)element$iv2;
                successors.putValue((Object)p, (Object)op);
            }
            op.setIncidence(flatPreceders.size());
        }
        MultiMap multiMap = successors;
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"successors");
        return multiMap;
    }

    public void produce(@NotNull Operation op) {
        Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
        op.getProducer().produce();
    }

    public final void produce() {
        this.produce(this.scenario.getRoot());
    }

    private final Operation makeTextSink() {
        return new Operation(new SimpleProducer(Companion.getTEXT_SINK(), (Function1<? super Producer, Unit>)((Function1)new Function1<Producer, Unit>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            public final void invoke(@NotNull Producer $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.processOperations($receiver.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)new Function1<Operation, Unit>(this.this$0){

                    public final void invoke(@NotNull Operation p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((AbstractCodeGenerator)this.receiver).produce(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractCodeGenerator.class);
                    }

                    public final String getName() {
                        return "produce";
                    }

                    public final String getSignature() {
                        return "produce(Lcom/intellij/database/scripting/Operation;)V";
                    }
                }));
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        })));
    }

    private final Operation makeFileSink(String file) {
        return new Operation(new SimpleProducer(Companion.getFILE_SINK(), (Function1<? super Producer, Unit>)((Function1)new Function1<Producer, Unit>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            public final void invoke(@NotNull Producer $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.processOperations($receiver.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)new Function1<Operation, Unit>(this.this$0){

                    public final void invoke(@NotNull Operation p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((AbstractCodeGenerator)this.receiver).produce(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractCodeGenerator.class);
                    }

                    public final String getName() {
                        return "produce";
                    }

                    public final String getSignature() {
                        return "produce(Lcom/intellij/database/scripting/Operation;)V";
                    }
                }));
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        })));
    }

    protected boolean isNewCodeGen() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void coding(@Nullable ScriptLocus locus, boolean indent, @NotNull Function0<Unit> block) {
        boolean complete;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ScriptLocus oldContext = this.locus;
        ScriptLocus scriptLocus = locus;
        if (scriptLocus == null) {
            scriptLocus = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptLocus.OUTSIDE)) ? ScriptLocus.IN_STATEMENT : oldContext;
        }
        ScriptLocus newContext = scriptLocus;
        CodeTextBuilder.IndentationState savedIndentation = this.builder.getCurrentIndentationState();
        try {
            this.locus = newContext;
            if (indent) {
                CodeTextBuilder.indent$default(this.builder, null, 1, null);
            }
            block.invoke();
            this.builder.returnToIndentation(savedIndentation);
            this.locus = oldContext;
        }
        catch (Throwable throwable) {
            boolean complete2;
            this.builder.returnToIndentation(savedIndentation);
            this.locus = oldContext;
            boolean bl = complete2 = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptLocus.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptLocus.OUTSIDE)) ^ true && this.builder.isNotEmpty();
            if (complete2) {
                this.postStatement();
            }
            throw throwable;
        }
        boolean bl = complete = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptLocus.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptLocus.OUTSIDE)) ^ true && this.builder.isNotEmpty();
        if (complete) {
            this.postStatement();
        }
    }

    public static /* bridge */ /* synthetic */ void coding$default(AbstractCodeGenerator abstractCodeGenerator, ScriptLocus scriptLocus, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
        }
        if ((n & 1) != 0) {
            scriptLocus = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        abstractCodeGenerator.coding(scriptLocus, bl, (Function0<Unit>)function0);
    }

    private final void postStatement() {
        if (this.builder.isNotEmpty()) {
            this.postStatement(new SimpleCompositeText(this.builder));
        }
        this.builder.clearAll();
    }

    private final void postStatement(CompositeText statement) {
        this.context.getScript().add(statement);
    }

    @NotNull
    protected final String getScr(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.naming.nameToScript($receiver);
    }

    @NotNull
    protected final String getScr(@NotNull Iterable<String> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.joinToString$default($receiver, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String $receiver$iv = it;
                AbstractCodeGenerator this_$iv = this.this$0;
                return AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        }), (int)31, null);
    }

    protected final boolean getUseName(@NotNull BasicNamedElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getName(), (Object)ModelConsts.NO_NAME) ^ true && (!$receiver.isNameSurrogate() || this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES) != false);
    }

    protected boolean canQualify(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String currentScopeName(@NotNull BasicElement $receiver, @Nullable String rename) {
        String string;
        String name;
        block14: {
            String string2;
            block13: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                String string3 = rename;
                if (string3 == null) {
                    string3 = string2 = $receiver.getRealName();
                }
                if (string3 == null) break block13;
                String string4 = string2;
                AbstractCodeGenerator this_$iv = this;
                string2 = this_$iv.naming.nameToScript((String)$receiver$iv);
                if (string2 != null) break block14;
            }
            string2 = name = "???";
        }
        if (!this.canQualify($receiver)) {
            return name;
        }
        BasicElement basicElement = $receiver;
        if (basicElement instanceof BasicSchemaObject) {
            String string5;
            String schemaName = ((BasicSchemaObject)$receiver).getSchemaName();
            if (schemaName != null && this.useSchemaName(schemaName)) {
                void $receiver$iv2;
                void this_$iv;
                String string6 = schemaName;
                AbstractCodeGenerator abstractCodeGenerator = this;
                StringBuilder stringBuilder = new StringBuilder();
                String string7 = ((AbstractCodeGenerator)this_$iv).naming.nameToScript((String)$receiver$iv2);
                string5 = stringBuilder.append(string7).append(".").toString();
            } else {
                string5 = "";
            }
            String prefix = string5;
            string = prefix + name;
        } else if (basicElement instanceof BasicMinorObject) {
            String string8;
            String schemaName;
            BasicMajorObject majorObject;
            BasicMajorObject basicMajorObject = majorObject = ((BasicMinorObject)$receiver).getMajorObject();
            String string9 = schemaName = basicMajorObject != null ? basicMajorObject.getSchemaName() : null;
            if (schemaName != null && this.useSchemaName(schemaName)) {
                void $receiver$iv;
                void this_$iv;
                String $i$f$getScr = schemaName;
                AbstractCodeGenerator $receiver$iv2 = this;
                StringBuilder stringBuilder = new StringBuilder();
                String string10 = ((AbstractCodeGenerator)this_$iv).naming.nameToScript((String)$receiver$iv);
                string8 = stringBuilder.append(string10).append(".").toString();
            } else {
                string8 = "";
            }
            String prefix = string8;
            string = prefix + name;
        } else {
            string = name;
        }
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String currentScopeName$default(AbstractCodeGenerator abstractCodeGenerator, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: currentScopeName");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return abstractCodeGenerator.currentScopeName(basicElement, string);
    }

    protected final void words(@NotNull CodeTextBuilder $receiver, String ... words) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)words, (String)"words");
        CodeTextBuilder.append$default($receiver, ScriptingUtilsKt.phrase(Arrays.copyOf(words, words.length)), null, false, null, 10, null);
    }

    protected final void appendOrErr(@NotNull CodeTextBuilder $receiver, @Nullable String text, boolean eoln, @NotNull Function0<String> error2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(error2, (String)"error");
        if (text == null) {
            CodeTextBuilder.append$default($receiver, "???", null, eoln, (String)error2.invoke(), 2, null);
        } else {
            CodeTextBuilder.append$default($receiver, text, null, eoln, null, 10, null);
        }
    }

    public static /* bridge */ /* synthetic */ void appendOrErr$default(AbstractCodeGenerator this_, CodeTextBuilder $receiver, String text, boolean eoln, Function0 error2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: appendOrErr");
        }
        if ((n & 2) != 0) {
            eoln = true;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)error2, (String)"error");
        if (text == null) {
            CodeTextBuilder.append$default($receiver, "???", null, eoln, (String)error2.invoke(), 2, null);
        } else {
            CodeTextBuilder.append$default($receiver, text, null, eoln, null, 10, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean useSchemaName(@Nullable String schemaName) {
        boolean bl;
        if (schemaName == null) return false;
        switch (AbstractCodeGenerator$WhenMappings.$EnumSwitchMapping$0[this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SCHEMA_NAME).ordinal()]) {
            case 1: {
                BasicSchema basicSchema = this.context.getCurrentSchema();
                bl = Intrinsics.areEqual((Object)schemaName, (Object)(basicSchema != null ? basicSchema.getRealName() : null)) ^ true;
                break;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!bl) return false;
        return true;
    }

    @NotNull
    protected String script(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return this.helper.script(d, this.context.getOptions());
    }

    @NotNull
    protected final String getSqlString(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    @NotNull
    public final Scenario getInternalScenario() {
        return this.scenario;
    }

    /*
     * WARNING - void declaration
     */
    protected final void alterTable(@Nullable BasicLikeTable table, @Nullable String rename) {
        void $receiver$iv;
        void text$iv;
        this.words(this.builder, "alter table ");
        CodeTextBuilder codeTextBuilder = this.builder;
        AbstractCodeGenerator abstractCodeGenerator = this;
        BasicLikeTable basicLikeTable = table;
        String string = basicLikeTable != null ? this.currentScopeName(basicLikeTable, rename) : null;
        boolean eoln$iv = false;
        if (text$iv == null) {
            boolean bl = eoln$iv;
            CompositeText.Kind kind = null;
            CharSequence charSequence = "???";
            void var9_10 = $receiver$iv;
            String string2 = "table is unknown";
            CodeTextBuilder.append$default((CodeTextBuilder)var9_10, charSequence, kind, bl, string2, 2, null);
        } else {
            CodeTextBuilder.append$default((CodeTextBuilder)$receiver$iv, (CharSequence)text$iv, null, eoln$iv, null, 10, null);
        }
    }

    public static /* bridge */ /* synthetic */ void alterTable$default(AbstractCodeGenerator abstractCodeGenerator, BasicLikeTable basicLikeTable, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: alterTable");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        abstractCodeGenerator.alterTable(basicLikeTable, string);
    }

    @NotNull
    protected final ScriptingContext getContext() {
        return this.context;
    }

    @NotNull
    protected ScriptingTask getTask() {
        return this.task;
    }

    public AbstractCodeGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.context = context;
        this.task = task;
        this.naming = NamingServices.INSTANCE.getNamingService(this.context.getModel(), this.context.getCurrentDatabase());
        this.helper = ScriptingHelper.Companion.get(this.context.getRdbms());
        this.scenario = new Scenario(this.createRootProducer());
        this.builder = new CodeTextBuilder(0, 1, null);
        this.locus = ScriptLocus.OUTSIDE;
    }

    static {
        Companion = new Companion(null);
        ROOT = new OperationType("root");
        TEXT_SINK = new OperationType("text sink");
        FILE_SINK = new OperationType("file sink");
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0002H\u0016RO\u0010\u0004\u001a@\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006*\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator$PreOrderComparator;", "Ljava/util/Comparator;", "Lcom/intellij/database/scripting/Operation;", "()V", "cache", "", "kotlin.jvm.PlatformType", "", "", "getCache", "()Ljava/util/Map;", "compare", "", "o1", "o2", "getPreliminaryOrder", "op", "intellij.database.scripting"})
    protected static class PreOrderComparator
    implements Comparator<Operation> {
        @NotNull
        private final Map<Operation, String> cache = FactoryMap.create((Function)new Function<K, V>(this){
            final /* synthetic */ PreOrderComparator this$0;

            @NotNull
            public final String fun(Operation it) {
                Operation operation = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"it");
                return this.this$0.getPreliminaryOrder(operation);
            }
            {
                this.this$0 = preOrderComparator;
            }
        });

        @NotNull
        public final Map<Operation, String> getCache() {
            return this.cache;
        }

        @Override
        public int compare(@Nullable Operation o1, @Nullable Operation o2) {
            int res = Comparing.compare((Comparable)((Comparable)((Object)this.cache.get(o1))), (Comparable)((Comparable)((Object)this.cache.get(o2))));
            if (res != 0) {
                return res;
            }
            return Comparing.compare((int)Comparing.hashcode((Object)o1), (int)Comparing.hashcode((Object)o2));
        }

        @NotNull
        public String getPreliminaryOrder(@NotNull Operation op) {
            Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
            return op.getProducer().getPreliminaryOrder();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H&J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "", "()V", "fix", "", "root", "Lcom/intellij/database/scripting/Operation;", "op1", "op2", "isBackward", "requiresResolve", "intellij.database.scripting"})
    public static abstract class EdgeFixer {
        public abstract boolean fix(@NotNull Operation var1, @NotNull Operation var2, @NotNull Operation var3);

        public boolean isBackward() {
            return false;
        }

        public boolean requiresResolve() {
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator$Companion;", "", "()V", "FILE_SINK", "Lcom/intellij/database/scripting/OperationType;", "getFILE_SINK", "()Lcom/intellij/database/scripting/OperationType;", "ROOT", "getROOT", "TEXT_SINK", "getTEXT_SINK", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        protected final OperationType getROOT() {
            return ROOT;
        }

        @NotNull
        protected final OperationType getTEXT_SINK() {
            return TEXT_SINK;
        }

        @NotNull
        protected final OperationType getFILE_SINK() {
            return FILE_SINK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

