/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService$WhenMappings;
import com.intellij.database.scripting.AbstractTransitionCodeGenerator;
import com.intellij.database.scripting.BaseAlterGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.BaseEnableDisableGenerator;
import com.intellij.database.scripting.BaseNativeDefinitionsGenerator;
import com.intellij.database.scripting.BaseRefreshMatViewGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingAlterTask;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingNativeDefinitionTask;
import com.intellij.database.scripting.ScriptingResult;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingTaskKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u000267B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0014J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0014J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0014J\u001d\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b!J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020#H\u0014J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0014J&\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020)0*H&J,\u0010+\u001a\u00020,2\u0018\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020/0.0*2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0010\u00102\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020\u001bH\u0016J\u0010\u00103\u001a\u0002042\u0006\u0010(\u001a\u00020)H\u0016J\b\u00105\u001a\u00020\u0010H\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/scripting/ScriptingService;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "(Lorg/jetbrains/dekaf/Rdbms;)V", "VERSION", "Lcom/intellij/database/model/PerObjectVersion;", "getVERSION", "()Lcom/intellij/database/model/PerObjectVersion;", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "createAlterGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingAlterTask;", "createCreatingGenerator", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "Lcom/intellij/database/scripting/ScriptingTask;", "createDropGenerator", "Lcom/intellij/database/scripting/BaseDropGenerator;", "createEnableDisableGenerator", "createExecuteGenerator", "createGenerator", "createGenerator$intellij_database_scripting", "createNativeDefinitionsGenerator", "Lcom/intellij/database/scripting/ScriptingNativeDefinitionTask;", "createRefreshingGenerator", "isSupported", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "kind", "Lcom/intellij/database/model/ObjectKind;", "", "makeRefactoringScript", "Lcom/intellij/database/scripting/ScriptingResult;", "elementPairsToProcess", "Lkotlin/Pair;", "Lcom/intellij/database/model/basic/BasicElement;", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "makeScript", "scriptingVersion", "", "toString", "ScriptingResultImpl", "StupidGenerator", "intellij.database.scripting"})
public abstract class AbstractScriptingService
implements ScriptingService {
    @NotNull
    private final Rdbms rdbms;

    @NotNull
    protected abstract PerObjectVersion getVERSION();

    @Override
    @NotNull
    public ScriptingResult makeScript(@NotNull ScriptingTask task) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        boolean bl2 = bl = Intrinsics.areEqual((Object)this.rdbms, (Object)UnknownDatabase.RDBMS) || Intrinsics.areEqual((Object)ScriptingTaskKt.getRdbms(task), (Object)this.rdbms);
        if (_Assertions.ENABLED && !bl) {
            String string = "wrong model";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ScriptingContext context = new ScriptingContext(task);
        AbstractCodeGenerator generator = this.createGenerator$intellij_database_scripting(context, task);
        if (!(generator instanceof AbstractTransitionCodeGenerator)) {
            generator.prepareScenario();
            generator.resolve();
            generator.transform();
            generator.produce();
        } else {
            ((AbstractTransitionCodeGenerator)generator).generate();
        }
        return new ScriptingResultImpl(context.getScript());
    }

    @NotNull
    public AbstractCodeGenerator createGenerator$intellij_database_scripting(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        AbstractCodeGenerator abstractCodeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        switch (AbstractScriptingService$WhenMappings.$EnumSwitchMapping$0[task.getCategory().ordinal()]) {
            case 1: 
            case 2: {
                abstractCodeGenerator = this.createCreatingGenerator(context, task);
                break;
            }
            case 3: {
                abstractCodeGenerator = this.createNativeDefinitionsGenerator(context, (ScriptingNativeDefinitionTask)task);
                break;
            }
            case 4: 
            case 5: {
                abstractCodeGenerator = this.createEnableDisableGenerator(context, task);
                break;
            }
            case 6: {
                abstractCodeGenerator = this.createRefreshingGenerator(context, task);
                break;
            }
            case 7: {
                abstractCodeGenerator = this.createExecuteGenerator(context, task);
                break;
            }
            case 8: {
                abstractCodeGenerator = this.createAlterGenerator(context, (ScriptingAlterTask)task);
                break;
            }
            case 9: {
                abstractCodeGenerator = this.createDropGenerator(context, task);
                break;
            }
            default: {
                abstractCodeGenerator = new StupidGenerator(context, task);
            }
        }
        return abstractCodeGenerator;
    }

    @NotNull
    protected BaseCreatingGenerator createCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new BaseCreatingGenerator(context, task);
    }

    @NotNull
    protected AbstractCodeGenerator createNativeDefinitionsGenerator(@NotNull ScriptingContext context, @NotNull ScriptingNativeDefinitionTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new BaseNativeDefinitionsGenerator(context, task);
    }

    @NotNull
    protected AbstractCodeGenerator createEnableDisableGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new BaseEnableDisableGenerator(context, task);
    }

    @NotNull
    protected AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new BaseRefreshMatViewGenerator(context, task);
    }

    @NotNull
    protected AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new StupidGenerator(context, task);
    }

    @NotNull
    protected BaseDropGenerator createDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new BaseDropGenerator(context, task);
    }

    @NotNull
    protected AbstractCodeGenerator createAlterGenerator(@NotNull ScriptingContext context, @NotNull ScriptingAlterTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new BaseAlterGenerator(this, context, task, context, task){
            @NotNull
            private final BaseCreatingGenerator creator;
            @NotNull
            private final BaseDropGenerator dropper;
            final /* synthetic */ AbstractScriptingService this$0;
            final /* synthetic */ ScriptingContext $context;
            final /* synthetic */ ScriptingAlterTask $task;

            @NotNull
            protected BaseCreatingGenerator getCreator() {
                return this.creator;
            }

            @NotNull
            protected BaseDropGenerator getDropper() {
                return this.dropper;
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
                this.$task = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
                this.creator = $outer.createCreatingGenerator($captured_local_variable$1, $captured_local_variable$2);
                this.dropper = $outer.createDropGenerator($captured_local_variable$1, $captured_local_variable$2);
            }
        };
    }

    @NotNull
    public String getStatementDelimiterStr() {
        return ";";
    }

    public boolean getStatementDelimiterOwnsLine() {
        return false;
    }

    @NotNull
    public String toString() {
        return "ScriptingService for " + this.rdbms + '.';
    }

    @Override
    @NotNull
    public ScriptingResult makeRefactoringScript(@NotNull Iterable<? extends Pair<? extends BasicElement, ? extends BasicElement>> elementPairsToProcess, @Nullable BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull(elementPairsToProcess, (String)"elementPairsToProcess");
        return new ScriptingResultImpl(CollectionsKt.emptyList());
    }

    public int scriptingVersion(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return this.getVERSION().get(kind);
    }

    public abstract boolean isSupported(@NotNull ScriptCategory var1, @NotNull ObjectKind var2, @NotNull Iterable<? extends ObjectKind> var3);

    @NotNull
    public final Rdbms getRdbms() {
        return this.rdbms;
    }

    public AbstractScriptingService(@NotNull Rdbms rdbms) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        this.rdbms = rdbms;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$StupidGenerator;", "Lcom/intellij/database/scripting/AbstractTransitionCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "prepareScenario", "intellij.database.scripting"})
    protected final class StupidGenerator
    extends AbstractTransitionCodeGenerator {
        @Override
        public void prepareScenario() {
        }

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ StupidGenerator this$0;
                final /* synthetic */ BasicElement $element;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- " + this.$element.getKind().code() + ' ' + this.$element.getName(), null, false, null, 14, null);
                }
                {
                    this.this$0 = stupidGenerator;
                    this.$element = basicElement;
                    super(0);
                }
            }, 3, null);
        }

        public StupidGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super(context, task);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(){

                public final void invoke() {
                    CodeTextBuilder.append$default(this.getBuilder(), "-- We don't know how to generate " + this.getCategory().name() + " :(", null, false, null, 14, null);
                }
            }, 3, null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$ScriptingResultImpl;", "Lcom/intellij/database/scripting/ScriptingResult;", "script", "", "Lcom/intellij/database/scripting/CompositeText;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Ljava/util/List;)V", "getScript", "getScriptStatements", "", "", "()[Ljava/lang/String;", "getScriptText", "getStatementDelimiter", "stmt", "intellij.database.scripting"})
    public final class ScriptingResultImpl
    implements ScriptingResult {
        private final List<CompositeText> script;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String[] getScriptStatements() {
            void var2_2;
            int size$iv = this.script.size();
            String[] result$iv = new String[size$iv];
            int n = 0;
            int n2 = result$iv.length;
            while (n < n2) {
                void i2;
                String string;
                void i$iv;
                void var5_5 = i$iv;
                void var9_7 = i$iv++;
                String[] stringArray = result$iv;
                stringArray[var9_7] = string = ((Object)this.script.get((int)i2).getText()).toString();
            }
            return var2_2;
        }

        @Override
        @NotNull
        public String getScriptText() {
            return ((Object)this.getScript().getText()).toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public CompositeText getScript() {
            void $receiver$iv;
            int initial$iv;
            Iterable iterable = this.script;
            int accumulator$iv = initial$iv = 0;
            for (Object element$iv : $receiver$iv) {
                void t;
                CompositeText compositeText = (CompositeText)element$iv;
                int x = accumulator$iv;
                accumulator$iv = x + t.getText().length();
            }
            int capacity = accumulator$iv + 8 * this.script.size();
            CodeTextBuilder b = new CodeTextBuilder(capacity);
            for (CompositeText stmt : this.script) {
                for (CompositeText.Fragment f : stmt.getFragments()) {
                    b.append(f);
                }
                boolean hasDelimiter = b.endsWithIgnoreSpace(AbstractScriptingService.this.getStatementDelimiterStr());
                if (!hasDelimiter) {
                    if (AbstractScriptingService.this.getStatementDelimiterOwnsLine()) {
                        b.ensureEoln(CompositeText.Kind.SQL_DELIMITER);
                    }
                    CodeTextBuilder.append$default(b, AbstractScriptingService.this.getStatementDelimiterStr(), CompositeText.Kind.SQL_DELIMITER, false, null, 12, null);
                }
                b.ensureBlankLine(CompositeText.Kind.SQL_DELIMITER);
            }
            return b;
        }

        private final String getStatementDelimiter(CompositeText stmt) {
            CompositeText.Fragment fragment = (CompositeText.Fragment)CollectionsKt.lastOrNull(stmt.getFragments());
            return Intrinsics.areEqual((Object)((Object)(fragment != null ? fragment.getKind() : null)), (Object)((Object)CompositeText.Kind.SQL_DELIMITER)) ^ true ? "" + AbstractScriptingService.this.getStatementDelimiterStr() + "\n\n" : "\n\n";
        }

        public ScriptingResultImpl(List<? extends CompositeText> script) {
            Intrinsics.checkParameterIsNotNull(script, (String)"script");
            this.script = script;
        }
    }
}

