/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.EffectType;
import com.intellij.database.scripting.ElementProducer;
import com.intellij.database.scripting.Node;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingSingleModelTask;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0016\u0018\u0000 )2\u00020\u0001:\u000f)*+,-./01234567B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0004J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0004J\u0018\u0010\u0015\u001a\n\u0012\u0002\b\u00030\u0016R\u00020\u00002\u0006\u0010\u0017\u001a\u00020\tH\u0014J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\tJ\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u001dH\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0013H\u0004J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\tH\u0017J$\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010%\u001a\u00020\u000eH\u0016J\b\u0010&\u001a\u00020\u0019H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0013H\u0004J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\tH\u0004R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00068"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "prepared", "Ljava/util/LinkedHashMap;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/Operation;", "getPrepared", "()Ljava/util/LinkedHashMap;", "breakDropFkEdge", "", "root", "opFk", "opTgt", "cascade", "", "cascadeConstraints", "createDropProducer", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "element", "fillDependencies", "", "fillDropDependants", "e", "generateUnspecifiedMajorObject", "Lcom/intellij/database/model/basic/BasicMajorObject;", "getEdgeFixers", "", "Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "ifExists", "makeDropOperation", "makeOperation", "prepareElement", "forceRoot", "prepareScenario", "restrictCascade", "unknownHowToDrop", "Companion", "DropDatabase", "DropForeignKey", "DropIndex", "DropKey", "DropProducer", "DropRoutine", "DropSchema", "DropSequence", "DropSynonym", "DropTable", "DropTableColumn", "DropTrigger", "DropUnknown", "DropView", "intellij.database.scripting"})
public class BaseDropGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final LinkedHashMap<BasicElement, Operation> prepared;
    @NotNull
    private static final OperationType DROP;
    private static final Companion.DROP_FK_FIXER.1 DROP_FK_FIXER;
    @NotNull
    private static final List<AbstractCodeGenerator.EdgeFixer> DROP_FIXERS;
    public static final Companion Companion;

    @NotNull
    protected final LinkedHashMap<BasicElement, Operation> getPrepared() {
        return this.prepared;
    }

    @Override
    @Nullable
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Operation res = this.makeDropOperation(element, this.getScenario().getRoot());
        JBTreeTraverser<BasicElement> jBTreeTraverser = element.getModel();
        if (jBTreeTraverser != null && (jBTreeTraverser = jBTreeTraverser.traverser(true)) != null) {
            Iterable $receiver$iv = (Iterable)jBTreeTraverser;
            for (Object element$iv : $receiver$iv) {
                BasicElement it;
                BasicElement basicElement = it = (BasicElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                this.fillDropDependants(basicElement);
            }
        }
        return res;
    }

    @Override
    public void prepareScenario() {
        ScriptingTask scriptingTask = this.getTask();
        if (scriptingTask == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.scripting.ScriptingSingleModelTask");
        }
        ScriptingSingleModelTask task = (ScriptingSingleModelTask)scriptingTask;
        Iterable $receiver$iv = task.getElements();
        for (Object element$iv : $receiver$iv) {
            BasicElement it = (BasicElement)element$iv;
            BaseDropGenerator.prepareElement$default(this, it, this.getScenario().getRoot(), false, 4, null);
        }
        this.fillDependencies();
    }

    public final void fillDependencies() {
        Set<BasicElement> set = this.prepared.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"prepared.keys");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            BasicElement it;
            BasicElement basicElement = it = (BasicElement)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
            this.fillDropDependants(basicElement);
        }
    }

    public final void fillDropDependants(@NotNull BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Iterable<? extends BasicElement> iterable = e.getPredecessors();
        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"e.predecessors");
        Iterable<? extends BasicElement> $receiver$iv = iterable;
        Iterator<? extends BasicElement> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement element$iv;
            BasicElement it = element$iv = iterator.next();
            Operation operation = this.prepared.get(it);
            if (operation == null) continue;
            ScenarioOperations.requires(operation, ScenarioOperations.matches$default(EffectType.Unexistent, e, null, 2, null));
        }
    }

    @Nullable
    public Operation prepareElement(@NotNull BasicElement element, @NotNull Operation root2, boolean forceRoot) {
        Operation operation;
        block5: {
            block4: {
                Operation operation2;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                operation = this.prepared.get(element);
                if (operation == null) break block4;
                Operation $receiver = operation2 = operation;
                if (forceRoot) {
                    $receiver.setParent((Node)root2);
                }
                if ((operation = operation2) != null) break block5;
            }
            operation = this.makeDropOperation(element, root2);
        }
        return operation;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Operation prepareElement$default(BaseDropGenerator baseDropGenerator, BasicElement basicElement, Operation operation, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return baseDropGenerator.prepareElement(basicElement, operation, bl);
    }

    @NotNull
    protected DropProducer<?> createDropProducer(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return new DropUnknown(element);
    }

    @NotNull
    public Operation makeDropOperation(@NotNull BasicElement element, @NotNull Operation root2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        return this.createDropProducer(element).register(root2);
    }

    @Override
    @NotNull
    public List<AbstractCodeGenerator.EdgeFixer> getEdgeFixers() {
        return Companion.getDROP_FIXERS$intellij_database_scripting();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakDropFkEdge(Operation root2, Operation opFk, Operation opTgt) {
        BasicForeignKey basicForeignKey;
        void $receiver$iv;
        BasicLikeTable basicLikeTable;
        void $receiver$iv2;
        if (Intrinsics.areEqual((Object)((Operation)opFk.getParent()), (Object)root2)) {
            return false;
        }
        Operation operation = opTgt;
        Object t$iv = Companion.getDROP();
        if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv2), (Object)t$iv)) {
            BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv2);
            if (!(basicElement instanceof BasicLikeTable)) {
                basicElement = null;
            }
            basicLikeTable = (BasicLikeTable)basicElement;
        } else {
            basicLikeTable = null;
        }
        if (basicLikeTable == null) {
            return false;
        }
        BasicLikeTable tgt = basicLikeTable;
        t$iv = opFk;
        OperationType t$iv2 = Companion.getDROP();
        if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv), (Object)t$iv2)) {
            BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv);
            if (!(basicElement instanceof BasicForeignKey)) {
                basicElement = null;
            }
            basicForeignKey = (BasicForeignKey)basicElement;
        } else {
            basicForeignKey = null;
        }
        if (basicForeignKey == null) {
            return false;
        }
        BasicForeignKey fk = basicForeignKey;
        if (Intrinsics.areEqual((Object)fk.getRefTable(), (Object)tgt) ^ true) {
            return false;
        }
        opFk.setParent((Node)root2);
        return true;
    }

    protected void generateUnspecifiedMajorObject(@NotNull BasicMajorObject element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String kindName = StringUtil.toLowerCase((String)element.getKind().name());
        String objectName = AbstractCodeGenerator.currentScopeName$default(this, element, null, 1, null);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, kindName, objectName){
            final /* synthetic */ BaseDropGenerator this$0;
            final /* synthetic */ String $kindName;
            final /* synthetic */ String $objectName;

            public final void invoke() {
                this.this$0.getBuilder().phrase("drop", this.$kindName, this.$objectName);
            }
            {
                this.this$0 = baseDropGenerator;
                this.$kindName = string;
                this.$objectName = string2;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    protected final void unknownHowToDrop(@NotNull BasicElement element) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String kindName = element.getKind().name();
        String string = element.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name");
        String string2 = string;
        BaseDropGenerator this_$iv = this;
        String elementName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, kindName, elementName){
            final /* synthetic */ BaseDropGenerator this$0;
            final /* synthetic */ String $kindName;
            final /* synthetic */ String $elementName;

            public final void invoke() {
                this.this$0.getBuilder().appendErrorComment("unknown how to drop " + this.$kindName + ' ' + this.$elementName + " :(");
            }
            {
                this.this$0 = baseDropGenerator;
                this.$kindName = string;
                this.$elementName = string2;
                super(0);
            }
        }, 3, null);
    }

    @Nullable
    protected final String ifExists() {
        return this.getContext().getOptions().get(ScriptingOptionStatic.IF_EXISTS) != false ? "if exists" : null;
    }

    @Nullable
    protected final String cascade() {
        return this.getContext().getOptions().get(ScriptingOptionStatic.DROP_CASCADE) != false ? "cascade" : null;
    }

    @Nullable
    protected final String restrictCascade() {
        return this.cascade();
    }

    @Nullable
    protected final String cascadeConstraints() {
        String string;
        String string2 = this.cascade();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            string = "cascade constraints";
        } else {
            string = null;
        }
        return string;
    }

    public BaseDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
        this.prepared = new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        DROP = new OperationType("drop");
        DROP_FK_FIXER = new AbstractCodeGenerator.EdgeFixer(){

            /*
             * WARNING - void declaration
             */
            public boolean fix(@NotNull Operation root2, @NotNull Operation op1, @NotNull Operation op2) {
                BasicForeignKey basicForeignKey;
                void $receiver$iv;
                BasicLikeTable basicLikeTable;
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Intrinsics.checkParameterIsNotNull((Object)op1, (String)"op1");
                Intrinsics.checkParameterIsNotNull((Object)op2, (String)"op2");
                if (Intrinsics.areEqual((Object)((Operation)op1.getParent()), (Object)root2)) {
                    return false;
                }
                Operation operation = op2;
                Object t$iv = BaseDropGenerator.Companion.getDROP();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv2), (Object)t$iv)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv2);
                    if (!(basicElement instanceof BasicLikeTable)) {
                        basicElement = null;
                    }
                    basicLikeTable = (BasicLikeTable)basicElement;
                } else {
                    basicLikeTable = null;
                }
                if (basicLikeTable == null) {
                    return false;
                }
                BasicLikeTable tgt = basicLikeTable;
                t$iv = op1;
                OperationType t$iv2 = BaseDropGenerator.Companion.getDROP();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv), (Object)t$iv2)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv);
                    if (!(basicElement instanceof BasicForeignKey)) {
                        basicElement = null;
                    }
                    basicForeignKey = (BasicForeignKey)basicElement;
                } else {
                    basicForeignKey = null;
                }
                if (basicForeignKey == null) {
                    return false;
                }
                BasicForeignKey fk = basicForeignKey;
                if (Intrinsics.areEqual((Object)fk.getRefTable(), (Object)tgt) ^ true) {
                    return false;
                }
                op1.setParent((Node)root2);
                return true;
            }

            public boolean isBackward() {
                return true;
            }
        };
        DROP_FIXERS = CollectionsKt.listOf((Object)BaseDropGenerator.Companion.getDROP_FK_FIXER());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/ElementProducer;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicElement;)V", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    protected static class DropProducer<T extends BasicElement>
    extends ElementProducer<T> {
        final /* synthetic */ BaseDropGenerator this$0;

        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = new Operation(this);
            $receiver.setParent((Node)root2);
            Map map = this.this$0.getPrepared();
            Object t = this.getElement();
            Operation operation2 = $receiver;
            map.put(t, operation2);
            ScenarioOperations.requires($receiver, ScenarioOperations.children(EffectType.Unexistent, this.getElement()));
            ScenarioOperations.provides($receiver, ScenarioOperations.invoke(EffectType.Unexistent, this.getElement()));
            return operation;
        }

        public DropProducer(T element) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super(Companion.getDROP(), (BasicElement)element, null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropDatabase;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicDatabase;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicDatabase;)V", "intellij.database.scripting"})
    protected class DropDatabase
    extends DropProducer<BasicDatabase> {
        public DropDatabase(BasicDatabase element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropIndex;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicIndex;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicIndex;)V", "intellij.database.scripting"})
    protected class DropIndex
    extends DropProducer<BasicIndex> {
        public DropIndex(BasicIndex element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropSequence;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicSequence;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicSequence;)V", "intellij.database.scripting"})
    protected class DropSequence
    extends DropProducer<BasicSequence> {
        public DropSequence(BasicSequence element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropSynonym;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicSynonym;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicSynonym;)V", "intellij.database.scripting"})
    protected class DropSynonym
    extends DropProducer<BasicSynonym> {
        public DropSynonym(BasicSynonym element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropTrigger;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicTrigger;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicTrigger;)V", "intellij.database.scripting"})
    protected class DropTrigger
    extends DropProducer<BasicTrigger> {
        public DropTrigger(BasicTrigger element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropTable;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicTable;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicTable;)V", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    protected class DropTable
    extends DropProducer<BasicTable> {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = super.register(root2);
            JBIterable<? extends BasicElement> jBIterable = ((BasicTable)this.getElement()).getChildren();
            Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"element.children");
            Iterable $receiver$iv = (Iterable)jBIterable;
            for (Object element$iv : $receiver$iv) {
                BasicElement it;
                BasicElement basicElement = it = (BasicElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                BaseDropGenerator.prepareElement$default(BaseDropGenerator.this, basicElement, $receiver, false, 4, null);
            }
            return operation;
        }

        public DropTable(BasicTable element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropSchema;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicSchema;)V", "intellij.database.scripting"})
    protected class DropSchema
    extends DropProducer<BasicSchema> {
        public DropSchema(BasicSchema element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropView;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicView;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicView;)V", "intellij.database.scripting"})
    protected class DropView
    extends DropProducer<BasicView> {
        public DropView(BasicView element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropRoutine;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicRoutine;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicRoutine;)V", "intellij.database.scripting"})
    protected class DropRoutine
    extends DropProducer<BasicRoutine> {
        public DropRoutine(BasicRoutine element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropTableColumn;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicTableColumn;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicTableColumn;)V", "intellij.database.scripting"})
    protected class DropTableColumn
    extends DropProducer<BasicTableColumn> {
        public DropTableColumn(BasicTableColumn element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropKey;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicKey;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicKey;)V", "intellij.database.scripting"})
    protected class DropKey
    extends DropProducer<BasicKey> {
        public DropKey(BasicKey element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropForeignKey;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicForeignKey;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicForeignKey;)V", "intellij.database.scripting"})
    protected class DropForeignKey
    extends DropProducer<BasicForeignKey> {
        public DropForeignKey(BasicForeignKey element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0084\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropUnknown;", "Lcom/intellij/database/scripting/BaseDropGenerator$DropProducer;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "element", "(Lcom/intellij/database/scripting/BaseDropGenerator;Lcom/intellij/database/model/basic/BasicElement;)V", "produce", "", "intellij.database.scripting"})
    protected final class DropUnknown
    extends DropProducer<BasicElement> {
        @Override
        public void produce() {
            BaseDropGenerator.this.unknownHowToDrop((BasicElement)this.getElement());
        }

        public DropUnknown(BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseDropGenerator.this, element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0005*\u0001\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$Companion;", "", "()V", "DROP", "Lcom/intellij/database/scripting/OperationType;", "getDROP", "()Lcom/intellij/database/scripting/OperationType;", "DROP_FIXERS", "", "Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "getDROP_FIXERS$intellij_database_scripting", "()Ljava/util/List;", "DROP_FK_FIXER", "com/intellij/database/scripting/BaseDropGenerator$Companion$DROP_FK_FIXER$1", "getDROP_FK_FIXER", "()Lcom/intellij/database/scripting/BaseDropGenerator$Companion$DROP_FK_FIXER$1;", "Lcom/intellij/database/scripting/BaseDropGenerator$Companion$DROP_FK_FIXER$1;", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        public final OperationType getDROP() {
            return DROP;
        }

        private final DROP_FK_FIXER.1 getDROP_FK_FIXER() {
            return DROP_FK_FIXER;
        }

        @NotNull
        public final List<AbstractCodeGenerator.EdgeFixer> getDROP_FIXERS$intellij_database_scripting() {
            return DROP_FIXERS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

