/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.db2.Db2Model;
import com.intellij.database.model.derby.DerbyModel;
import com.intellij.database.model.exasol.ExasolModel;
import com.intellij.database.model.h2.H2Model;
import com.intellij.database.model.hsql.HsqlModel;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsModel;
import com.intellij.database.model.mssql.MsRoot;
import com.intellij.database.model.mysql.MysqlModel;
import com.intellij.database.model.oracle.OraModel;
import com.intellij.database.model.postgres.PostgresModel;
import com.intellij.database.model.redshift.RedshiftModel;
import com.intellij.database.model.sqlite.SqliteModel;
import com.intellij.database.model.sybase.SybaseDatabase;
import com.intellij.database.model.sybase.SybaseModel;
import com.intellij.database.model.sybase.SybaseRoot;
import com.intellij.database.scripting.AbstractNamingService;
import com.intellij.database.scripting.NamingServices$WhenMappings;
import com.intellij.database.scripting.db2.Db2NamingService;
import com.intellij.database.scripting.derby.DerbyNamingService;
import com.intellij.database.scripting.exasol.ExasolNamingService;
import com.intellij.database.scripting.generic.GenericLowerCaseNamingService;
import com.intellij.database.scripting.generic.GenericMixedCaseNamingService;
import com.intellij.database.scripting.generic.GenericUpperCaseNamingService;
import com.intellij.database.scripting.h2.H2NamingService;
import com.intellij.database.scripting.hsql.HsqlNamingService;
import com.intellij.database.scripting.mssql.TsqlNamingService;
import com.intellij.database.scripting.mysql.MysqlNamingService;
import com.intellij.database.scripting.oracle.OraNamingService;
import com.intellij.database.scripting.postgres.PostgresNamingService;
import com.intellij.database.scripting.redshift.RedshiftNamingService;
import com.intellij.database.scripting.sqlite.SqliteNamingService;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/scripting/NamingServices;", "", "()V", "tsqlCI", "Lcom/intellij/database/scripting/mssql/TsqlNamingService;", "tsqlCS", "getGenericNamingService", "Lcom/intellij/database/scripting/AbstractNamingService;", "case", "Lcom/intellij/database/util/Case;", "getNamingService", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "getTsqlNamingService", "cs", "", "intellij.database.scripting"})
public final class NamingServices {
    private static final TsqlNamingService tsqlCS;
    private static final TsqlNamingService tsqlCI;
    public static final NamingServices INSTANCE;

    @NotNull
    public final AbstractNamingService getNamingService(@NotNull BasicModel model, @Nullable BasicDatabase database) {
        AbstractNamingService abstractNamingService;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicModel basicModel = model;
        if (basicModel instanceof OraModel) {
            abstractNamingService = OraNamingService.INSTANCE;
        } else if (basicModel instanceof PostgresModel) {
            abstractNamingService = PostgresNamingService.INSTANCE;
        } else if (basicModel instanceof RedshiftModel) {
            abstractNamingService = RedshiftNamingService.INSTANCE;
        } else if (basicModel instanceof MysqlModel) {
            abstractNamingService = MysqlNamingService.INSTANCE;
        } else if (basicModel instanceof SqliteModel) {
            abstractNamingService = SqliteNamingService.INSTANCE;
        } else if (basicModel instanceof ExasolModel) {
            abstractNamingService = ExasolNamingService.INSTANCE;
        } else if (basicModel instanceof Db2Model) {
            abstractNamingService = Db2NamingService.INSTANCE;
        } else if (basicModel instanceof DerbyModel) {
            abstractNamingService = DerbyNamingService.INSTANCE;
        } else if (basicModel instanceof H2Model) {
            abstractNamingService = H2NamingService.INSTANCE;
        } else if (basicModel instanceof HsqlModel) {
            abstractNamingService = HsqlNamingService.INSTANCE;
        } else if (basicModel instanceof MsModel) {
            MsDatabase msDatabase;
            BasicDatabase basicDatabase = database;
            if (!(basicDatabase instanceof MsDatabase)) {
                basicDatabase = null;
            }
            if ((msDatabase = (MsDatabase)basicDatabase) == null || (msDatabase = msDatabase.getCasing()) == null) {
                MsRoot msRoot = ((MsModel)model).getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)msRoot, (String)"model.root");
                msDatabase = msRoot.getDefaultCasing();
            }
            abstractNamingService = this.getTsqlNamingService(((Casing)msDatabase).plain.sensitive);
        } else if (basicModel instanceof SybaseModel) {
            SybaseDatabase sybaseDatabase;
            BasicDatabase basicDatabase = database;
            if (!(basicDatabase instanceof SybaseDatabase)) {
                basicDatabase = null;
            }
            if ((sybaseDatabase = (SybaseDatabase)basicDatabase) == null || (sybaseDatabase = sybaseDatabase.getCasing()) == null) {
                SybaseRoot sybaseRoot = ((SybaseModel)model).getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)sybaseRoot, (String)"model.root");
                sybaseDatabase = sybaseRoot.getDefaultCasing();
            }
            abstractNamingService = this.getTsqlNamingService(((Casing)sybaseDatabase).plain.sensitive);
        } else {
            BasicRoot basicRoot = model.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicRoot, (String)"model.root");
            Case case_ = basicRoot.getDefaultCasing().plain;
            Intrinsics.checkExpressionValueIsNotNull((Object)case_, (String)"model.root.defaultCasing.plain");
            abstractNamingService = this.getGenericNamingService(case_);
        }
        return abstractNamingService;
    }

    private final TsqlNamingService getTsqlNamingService(boolean cs) {
        return cs ? tsqlCS : tsqlCI;
    }

    private final AbstractNamingService getGenericNamingService(Case case_) {
        AbstractNamingService abstractNamingService;
        switch (NamingServices$WhenMappings.$EnumSwitchMapping$0[case_.ordinal()]) {
            case 1: {
                abstractNamingService = GenericLowerCaseNamingService.INSTANCE;
                break;
            }
            case 2: {
                abstractNamingService = GenericUpperCaseNamingService.INSTANCE;
                break;
            }
            default: {
                abstractNamingService = GenericMixedCaseNamingService.INSTANCE;
            }
        }
        return abstractNamingService;
    }

    private NamingServices() {
    }

    static {
        NamingServices namingServices;
        INSTANCE = namingServices = new NamingServices();
        tsqlCS = new TsqlNamingService(true);
        tsqlCI = new TsqlNamingService(false);
    }
}

