/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingFactoryImplKt;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.postgres.PostgresScriptingService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/scripting/ScriptingFactoryImpl;", "Lcom/intellij/database/scripting/ScriptingFactory;", "()V", "createScriptingService", "Lcom/intellij/database/scripting/ScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "getCurrentScriptingVersion", "", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "kind", "Lcom/intellij/database/model/ObjectKind;", "isRefactoringSupported", "", "isSupported", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "context", "", "intellij.database.scripting"})
public final class ScriptingFactoryImpl
implements ScriptingFactory {
    @Override
    public boolean isSupported(@NotNull ScriptCategory category, @NotNull Rdbms rdbms, @NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        return ScriptingFactoryImplKt.access$getScriptingService(rdbms).isSupported(category, kind, context);
    }

    @Override
    public boolean isRefactoringSupported(@NotNull Rdbms rdbms, @NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Rdbms rdbms2 = rdbms;
        return Intrinsics.areEqual((Object)rdbms2, (Object)Postgres.RDBMS) ? PostgresScriptingService.INSTANCE.isRefactoringSupported(kind) : false;
    }

    @Override
    public int getCurrentScriptingVersion(@NotNull Rdbms rdbms, @NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return ScriptingFactoryImplKt.access$getScriptingService(rdbms).scriptingVersion(kind);
    }

    @Override
    @NotNull
    public ScriptingService createScriptingService(@NotNull BasicModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Rdbms rdbms = model.getRdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"model.rdbms");
        return ScriptingFactoryImplKt.access$getScriptingService(rdbms);
    }
}

