/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingAlterTask;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingNativeDefinitionTask;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.oracle.OraAlterGenerator;
import com.intellij.database.scripting.oracle.OraCreatingGenerator;
import com.intellij.database.scripting.oracle.OraDropGenerator;
import com.intellij.database.scripting.oracle.OraExecuteGenerator;
import com.intellij.database.scripting.oracle.OraNativeDefinitionsGenerator;
import com.intellij.database.scripting.oracle.OraRefreshMatViewGenerator;
import com.intellij.database.scripting.oracle.OraScriptingService$WhenMappings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0014J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0014J&\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020#0$H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/intellij/database/scripting/oracle/OraScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "()V", "VERSION", "Lcom/intellij/database/model/PerObjectVersion;", "getVERSION", "()Lcom/intellij/database/model/PerObjectVersion;", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "createAlterGenerator", "Lcom/intellij/database/scripting/oracle/OraAlterGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingAlterTask;", "createCreatingGenerator", "Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;", "Lcom/intellij/database/scripting/ScriptingTask;", "createDropGenerator", "Lcom/intellij/database/scripting/oracle/OraDropGenerator;", "createExecuteGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "createNativeDefinitionsGenerator", "Lcom/intellij/database/scripting/ScriptingNativeDefinitionTask;", "createRefreshingGenerator", "isSupported", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "kind", "Lcom/intellij/database/model/ObjectKind;", "", "intellij.database.scripting"})
public final class OraScriptingService
extends AbstractScriptingService {
    @NotNull
    private static final PerObjectVersion VERSION;
    @NotNull
    private static final String statementDelimiterStr = "/";
    private static final boolean statementDelimiterOwnsLine = true;
    public static final OraScriptingService INSTANCE;

    @Override
    @NotNull
    protected PerObjectVersion getVERSION() {
        return VERSION;
    }

    @Override
    @NotNull
    public String getStatementDelimiterStr() {
        return statementDelimiterStr;
    }

    @Override
    public boolean getStatementDelimiterOwnsLine() {
        return statementDelimiterOwnsLine;
    }

    @Override
    @NotNull
    protected OraCreatingGenerator createCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraCreatingGenerator(context, task);
    }

    @Override
    @NotNull
    protected OraDropGenerator createDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraDropGenerator(context, task);
    }

    @Override
    @NotNull
    protected OraAlterGenerator createAlterGenerator(@NotNull ScriptingContext context, @NotNull ScriptingAlterTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraAlterGenerator(context, task, this.createCreatingGenerator(context, task), this.createDropGenerator(context, task));
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createNativeDefinitionsGenerator(@NotNull ScriptingContext context, @NotNull ScriptingNativeDefinitionTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraNativeDefinitionsGenerator(context, task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraRefreshMatViewGenerator(context, task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraExecuteGenerator(context, task);
    }

    @Override
    public boolean isSupported(@NotNull ScriptCategory category, @NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        switch (OraScriptingService$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
            case 1: {
                bl = OraDropGenerator.Companion.canDrop(kind, context);
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private OraScriptingService() {
        Rdbms rdbms = Oracle.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Oracle.RDBMS");
        super(rdbms);
    }

    static {
        OraScriptingService oraScriptingService;
        INSTANCE = oraScriptingService = new OraScriptingService();
        VERSION = new PerObjectVersion();
        statementDelimiterStr = statementDelimiterStr;
        statementDelimiterOwnsLine = true;
    }
}

