/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresCollation;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresDefTypeCheck;
import com.intellij.database.model.postgres.PostgresForeignDataWrapper;
import com.intellij.database.model.postgres.PostgresForeignServer;
import com.intellij.database.model.postgres.PostgresForeignTable;
import com.intellij.database.model.postgres.PostgresForeignTableColumn;
import com.intellij.database.model.postgres.PostgresLocalTableColumn;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresRole;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.postgres.PostgresUserMapping;
import com.intellij.database.model.postgres.PostgresView;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.postgresbase.PostgresBaseView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.PostgresRoutineConcurrencyKind;
import com.intellij.database.model.properties.PostgresVolatilityKind;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.postgres.PostgresBaseCreatingGenerator;
import com.intellij.database.scripting.postgres.PostgresCreatingGenerator;
import com.intellij.database.scripting.postgres.PostgresCreatingGenerator$PgCreateDefType$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001:\u000b789:;<=>?@AB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\n\u0012\u0002\b\u00030\u0013R\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u001e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001fH\u0014J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0014\u0010'\u001a\u0004\u0018\u00010\u000b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0014J\u0012\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010+\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\u001a\u00101\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u00010\u000b2\u0006\u00103\u001a\u00020\u000bH\u0002J\u001e\u00104\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u00105\u001a\u000206H\u0002\u00a8\u0006B"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;", "Lcom/intellij/database/scripting/postgres/PostgresBaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "appendOptions", "", "options", "", "", "appendRoutineAttributes", "f", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "appendViewOptions", "view", "Lcom/intellij/database/model/postgresbase/PostgresBaseView;", "createProducer", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "elementKindNameForCreate", "floatAttributeName", "", "s", "gatherSequenceIdentityParameters", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "parameters", "", "generalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generatePostgresTrigger", "trigger", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "getVolatilityKind", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeNormalColumnSpecification", "makeSerialColumnSpecification", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "table", "Lcom/intellij/database/model/basic/BasicTable;", "maybeQualified", "schemaName", "name", "optionsToString", "wrap", "", "PgCreateCollation", "PgCreateDefType", "PgCreateDefTypeCheck", "PgCreateForeignDataWrapper", "PgCreateForeignServer", "PgCreateLikeColumn", "PgCreateOperator", "PgCreateRole", "PgCreateSequence", "PgCreateTrigger", "PgCreateUserMapping", "intellij.database.scripting"})
public final class PostgresCreatingGenerator
extends PostgresBaseCreatingGenerator {
    @Override
    @NotNull
    protected BaseCreatingGenerator.CreateProducer<?> createProducer(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof PostgresRole ? (BaseCreatingGenerator.CreateProducer)new PgCreateRole((PostgresRole)element) : (basicElement instanceof PostgresDefType ? (BaseCreatingGenerator.CreateProducer)new PgCreateDefType((PostgresDefType)element) : (basicElement instanceof PostgresOperator ? (BaseCreatingGenerator.CreateProducer)new PgCreateOperator((PostgresOperator)element) : (basicElement instanceof PostgresDefTypeCheck ? (BaseCreatingGenerator.CreateProducer)new PgCreateDefTypeCheck((PostgresDefTypeCheck)element) : (basicElement instanceof PostgresCollation ? (BaseCreatingGenerator.CreateProducer)new PgCreateCollation((PostgresCollation)element) : (basicElement instanceof PostgresForeignDataWrapper ? (BaseCreatingGenerator.CreateProducer)new PgCreateForeignDataWrapper((PostgresForeignDataWrapper)element) : (basicElement instanceof PostgresForeignServer ? (BaseCreatingGenerator.CreateProducer)new PgCreateForeignServer((PostgresForeignServer)element) : (basicElement instanceof PostgresUserMapping ? (BaseCreatingGenerator.CreateProducer)new PgCreateUserMapping((PostgresUserMapping)element) : (basicElement instanceof BasicLikeColumn ? (BaseCreatingGenerator.CreateProducer)new PgCreateLikeColumn((BasicLikeColumn)element) : (basicElement instanceof BasicTrigger ? (BaseCreatingGenerator.CreateProducer)new PgCreateTrigger((BasicTrigger)element) : (basicElement instanceof BasicSequence ? (BaseCreatingGenerator.CreateProducer)new PgCreateSequence((BasicSequence)element) : super.createProducer(element)))))))))));
    }

    @Override
    protected void appendViewOptions(@NotNull PostgresBaseView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (!(view instanceof PostgresView) || Intrinsics.areEqual((Object)((Object)((PostgresView)view).getCheckOption()), (Object)((Object)PostgresCheckOption.NONE))) {
            return;
        }
        CodeTextBuilder.ensureEoln$default(this.getBuilder(), null, 1, null);
        String string = ((PostgresView)view).getCheckOption().name();
        StringBuilder stringBuilder = new StringBuilder().append("with ");
        CodeTextBuilder codeTextBuilder = this.getBuilder();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string4).append(" check option").toString(), null, false, null, 14, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void appendOptions(List<String> options) {
        if (options.isEmpty()) {
            return;
        }
        CodeTextBuilder this_$iv = this.getBuilder();
        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
        try {
            CodeTextBuilder.append$default(this.getBuilder(), "options (", null, false, null, 10, null);
        }
        finally {
            this_$iv.unindent();
        }
        Iterable $receiver$iv = options;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void option;
            int n = index$iv++;
            String string = (String)item$iv;
            int idx = n;
            List keyValue = StringsKt.split$default((CharSequence)((CharSequence)option), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            CodeTextBuilder.append$default(this.getBuilder(), (CharSequence)CollectionsKt.first((List)keyValue), null, false, null, 10, null);
            CodeTextBuilder.append$default(this.getBuilder(), " ", null, false, null, 10, null);
            CodeTextBuilder.append$default(this.getBuilder(), '\'' + (String)CollectionsKt.last((List)keyValue) + '\'', null, false, null, 10, null);
            if (idx == options.size() - 1) continue;
            CodeTextBuilder.append$default(this.getBuilder(), ", ", null, false, null, 10, null);
        }
        CodeTextBuilder.append$default(this.getBuilder(), ")", null, false, null, 14, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String optionsToString(List<String> options, boolean wrap) {
        if (options.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(wrap ? "\n" : " ");
        sb.append("options (");
        Iterable $receiver$iv = options;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void option;
            int n = index$iv++;
            String string = (String)item$iv;
            int idx = n;
            List keyValue = StringsKt.split$default((CharSequence)((CharSequence)option), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            sb.append((String)CollectionsKt.first((List)keyValue));
            sb.append(" ");
            sb.append('\'' + (String)CollectionsKt.last((List)keyValue) + '\'');
            if (idx == options.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String maybeQualified(String schemaName, String name) {
        String string;
        String string2;
        String $receiver$iv;
        PostgresCreatingGenerator this_$iv;
        StringBuilder stringBuilder;
        if (this.useSchemaName(schemaName)) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = schemaName;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            String string4 = string3;
            PostgresCreatingGenerator postgresCreatingGenerator = this;
            stringBuilder = stringBuilder2;
            string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            string = stringBuilder.append(string2).append(".").toString();
        } else {
            string = "";
        }
        String schema = string;
        $receiver$iv = name;
        this_$iv = this;
        stringBuilder = new StringBuilder().append(schema);
        string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
        return stringBuilder.append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendRoutineAttributes(@NotNull PostgresBaseRoutine f) {
        Object it;
        Object this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        super.appendRoutineAttributes(f);
        PostgresRoutine postgresRoutine = (PostgresRoutine)f;
        if (postgresRoutine.isLeakproof()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "leakproof", null, false, null, 14, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        if (postgresRoutine.isWindow()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "window", null, false, null, 14, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        if (postgresRoutine.isStrict()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "strict", null, false, null, 14, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        if (postgresRoutine.isSecurityDefiner()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "security definer", null, false, null, 14, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        PostgresRoutineConcurrencyKind postgresRoutineConcurrencyKind = postgresRoutine.getConcurrencyKind();
        if (postgresRoutineConcurrencyKind != null && Intrinsics.areEqual((Object)(it = (this_$iv = postgresRoutineConcurrencyKind)), (Object)((Object)PostgresRoutineConcurrencyKind.UNSAFE)) ^ true) {
            CodeTextBuilder this_$iv2 = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv2, null, 1, null);
            try {
                CodeTextBuilder codeTextBuilder = this.getBuilder();
                StringBuilder stringBuilder = new StringBuilder().append("parallel ");
                Object object = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(((PostgresRoutineConcurrencyKind)((Object)object)).getModifier()).toString(), null, false, null, 14, null);
            }
            finally {
                this_$iv2.unindent();
            }
        }
        if (PostgresModelFun.isCostDefined(postgresRoutine)) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "" + this.floatAttributeName(postgresRoutine.getCost(), "cost") + ' ' + PostgresModelFun.costAsString(postgresRoutine), null, false, null, 14, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        if (PostgresModelFun.isRowsDefined(postgresRoutine)) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "" + this.floatAttributeName(postgresRoutine.getRows(), "rows") + ' ' + PostgresModelFun.rowsAsString(postgresRoutine), null, false, null, 14, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        List<String> configurationParameters = postgresRoutine.getConfigurationParameters();
        for (String configurationParameter : configurationParameters) {
            CodeTextBuilder this_$iv3 = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv3, null, 1, null);
            try {
                this.getBuilder().phrase("SET", configurationParameter);
            }
            finally {
                this_$iv3.unindent();
            }
        }
    }

    private final String floatAttributeName(float f, String s) {
        float f2 = f;
        StringBuilder stringBuilder = new StringBuilder().append("");
        boolean bl = Float.isInfinite(f2);
        return stringBuilder.append(bl ? "--" : "").append("").append(s).toString();
    }

    @Override
    @Nullable
    protected String getVolatilityKind(@NotNull PostgresBaseRoutine f) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        if (Intrinsics.areEqual((Object)((Object)f.getVolatilityKind()), (Object)((Object)PostgresVolatilityKind.VOLATILE))) {
            string = null;
        } else {
            Object object = f.getVolatilityKind();
            if (object != null && (object = object.name()) != null) {
                Object object2;
                Object object3 = object2 = object;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object3).toLowerCase();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            } else {
                string = null;
            }
        }
        return string;
    }

    @Override
    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "foreign table" : super.elementKindNameForCreate(element);
    }

    @Override
    protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
        block5: {
            PostgresSequence postgresSequence;
            PostgresSequence $receiver;
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            BasicSequence basicSequence = sequence;
            if (!(basicSequence instanceof PostgresSequence)) {
                basicSequence = null;
            }
            PostgresSequence postgresSequence2 = (PostgresSequence)basicSequence;
            if (postgresSequence2 != null && !PostgresModelFun.hasDefaultType($receiver = (postgresSequence = postgresSequence2))) {
                parameters.add("as " + $receiver.getDataType());
            }
            super.gatherSequenceIdentityParameters(sequence, parameters);
            BasicSequence basicSequence2 = sequence;
            if (!(basicSequence2 instanceof PostgresSequence)) {
                basicSequence2 = null;
            }
            PostgresSequence postgresSequence3 = (PostgresSequence)basicSequence2;
            if (postgresSequence3 == null) break block5;
            postgresSequence = postgresSequence3;
            $receiver = postgresSequence;
            if (!PostgresModelFun.hasDefaultCacheSize($receiver)) {
                parameters.add("cache " + $receiver.getCacheSize());
            }
            if ($receiver.isCycled()) {
                parameters.add("cycle");
            }
        }
    }

    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        HeaderFooter hf = super.makeTableHeaderFooter(table);
        BasicTable basicTable = table;
        if (!(basicTable instanceof PostgresTable)) {
            basicTable = null;
        }
        PostgresTable postgresTable = (PostgresTable)basicTable;
        if (postgresTable == null) {
            return hf;
        }
        PostgresTable t = postgresTable;
        String footer = null;
        List<Long> list = t.getAncestorIds();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"t.ancestorIds");
        Collection collection = list;
        if (!collection.isEmpty()) {
            List<PostgresTable> ancestors = PostgresModelFun.getAncestors(t);
            footer = "inherits (" + CollectionsKt.joinToString$default((Iterable)ancestors, null, null, null, (int)0, null, (Function1)((Function1)new Function1<PostgresTable, String>(this){
                final /* synthetic */ PostgresCreatingGenerator this$0;

                @NotNull
                public final String invoke(@NotNull PostgresTable it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return AbstractCodeGenerator.currentScopeName$default(this.this$0, it, null, 1, null);
                }
                {
                    this.this$0 = postgresCreatingGenerator;
                    super(1);
                }
            }), (int)31, null) + ")";
        }
        if (t instanceof PostgresForeignTable) {
            if (footer != null) {
                footer = footer + "\n";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = footer;
            if (string == null) {
                string = "";
            }
            StringBuilder stringBuilder2 = stringBuilder.append(string).append("server ").append(((PostgresForeignTable)t).getServer()).append("");
            List<String> list2 = ((PostgresForeignTable)t).getOptions();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"t.options");
            footer = stringBuilder2.append(this.optionsToString(list2, true)).toString();
        }
        return footer == null ? hf : new HeaderFooter(hf.getHeader(), footer);
    }

    @Override
    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return column2 instanceof PostgresLocalTableColumn && ((PostgresLocalTableColumn)column2).getSequenceName() != null ? this.makeSerialColumnSpecification((PostgresTableColumn)column2) : super.makeNormalColumnSpecification(column2);
    }

    @Override
    @NotNull
    protected String generalColumnSpecification(@NotNull BasicLikeColumn column2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        StringBuilder stringBuilder = new StringBuilder().append(super.generalColumnSpecification(column2));
        if (column2 instanceof PostgresForeignTableColumn) {
            List<String> list = ((PostgresForeignTableColumn)column2).getOptions();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"column.options");
            string = this.optionsToString(list, false);
        } else {
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    private final String makeSerialColumnSpecification(PostgresTableColumn column2) {
        String specification;
        String string;
        DataType dt = column2.getDataType();
        String string2 = dt.typeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dt.typeName");
        if (StringsKt.startsWith$default((String)string2, (String)"small", (boolean)false, (int)2, null)) {
            string = "smallserial";
        } else {
            String string3 = dt.typeName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dt.typeName");
            string = specification = StringsKt.startsWith$default((String)string3, (String)"big", (boolean)false, (int)2, null) ? "bigserial" : "serial";
        }
        if (column2.isNotNull()) {
            specification = specification + " not null";
        }
        return specification;
    }

    private final void generatePostgresTrigger(PostgresTrigger trigger) {
        PostgresRoutine postgresRoutine = PostgresModelFun.getCallRoutine(trigger);
        if (postgresRoutine == null) {
            return;
        }
        PostgresRoutine routine = postgresRoutine;
        String triggerName = AbstractCodeGenerator.currentScopeName$default(this, trigger, null, 1, null);
        Object object = trigger.getLikeTable();
        if (object == null || (object = AbstractCodeGenerator.currentScopeName$default(this, (BasicElement)object, null, 1, null)) == null) {
            return;
        }
        Object tableName = object;
        String routineName = AbstractCodeGenerator.currentScopeName$default(this, routine, null, 1, null);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, trigger, (String)tableName, routineName){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ String $triggerName;
            final /* synthetic */ PostgresTrigger $trigger;
            final /* synthetic */ String $tableName;
            final /* synthetic */ String $routineName;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("create trigger", this.$triggerName);
                CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    String ev = ScriptingUtilsKt.makeTriggerEventString(this.$trigger);
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), ev, null, false, null, 14, null);
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "on " + this.$tableName, null, false, null, 14, null);
                    TrigTurn turn = this.$trigger.getTurn();
                    if (Intrinsics.areEqual((Object)turn, (Object)TrigTurn.BEFORE_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.AFTER_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.INSTEAD_OF)) {
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "for each row", null, false, null, 14, null);
                    }
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "execute procedure " + this.$routineName + "()", null, false, null, 14, null);
                }
                finally {
                    this_$iv.unindent();
                }
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$triggerName = string;
                this.$trigger = postgresTrigger;
                this.$tableName = string2;
                this.$routineName = string3;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @Nullable
    protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
        return rule != null && Intrinsics.areEqual((Object)((Object)rule), (Object)((Object)CascadeRule.no_action)) ^ true ? rule.keyWord : null;
    }

    public PostgresCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    @NotNull
    public static final /* synthetic */ String access$getSqlString$p(PostgresCreatingGenerator $this, @NotNull String $receiver) {
        return $this.getSqlString($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$maybeQualified(PostgresCreatingGenerator $this, @Nullable String schemaName, @NotNull String name) {
        return $this.maybeQualified(schemaName, name);
    }

    public static final /* synthetic */ void access$appendOptions(PostgresCreatingGenerator $this, @NotNull List options) {
        $this.appendOptions(options);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateRole;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresRole;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresRole;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateRole
    extends BaseCreatingGenerator.CreateProducer<PostgresRole> {
        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateRole this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    StringBuilder stringBuilder = new StringBuilder().append("create ").append(((PostgresRole)this.this$0.getElement()).isCanLogin() ? "user" : "role").append(' ');
                    PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                    String string = ((PostgresRole)this.this$0.getElement()).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name");
                    CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(PostgresCreatingGenerator.access$getScr$p(postgresCreatingGenerator, string)).toString(), null, false, null, 14, null);
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (((PostgresRole)this.this$0.getElement()).isSuperRole()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "superuser", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).isCreateDb()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "createdb", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).isCreateRole()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "createrole", null, false, null, 14, null);
                        }
                        if (!((PostgresRole)this.this$0.getElement()).isInherit()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "noinherit", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).isReplication()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "replication", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).isBypassRls()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "bypassrls", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).getConnectionLimit() >= 0L) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "connection limit " + ((PostgresRole)this.this$0.getElement()).getConnectionLimit(), null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).getValidUntil() != null) {
                            CodeTextBuilder codeTextBuilder2 = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                            StringBuilder stringBuilder2 = new StringBuilder().append("valid until ");
                            PostgresCreatingGenerator postgresCreatingGenerator2 = this.this$0.PostgresCreatingGenerator.this;
                            String string2 = ((PostgresRole)this.this$0.getElement()).getValidUntil();
                            if (string2 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.validUntil!!");
                            CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(PostgresCreatingGenerator.access$getSqlString$p(postgresCreatingGenerator2, string2)).toString(), null, false, null, 14, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = pgCreateRole;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateRole(PostgresRole element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateDefType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresDefType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresDefType;)V", "generateComposite", "", "generateDomain", "generateEnum", "produce", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class PgCreateDefType
    extends BaseCreatingGenerator.CreateProducer<PostgresDefType> {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = super.register(root2);
            NamingIdentifyingFamily<? extends PostgresDefTypeCheck> namingIdentifyingFamily = ((PostgresDefType)this.getElement()).getChecks();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"element.checks");
            Iterable $receiver$iv = namingIdentifyingFamily;
            for (Object element$iv : $receiver$iv) {
                PostgresDefTypeCheck it;
                PostgresDefTypeCheck postgresDefTypeCheck = it = (PostgresDefTypeCheck)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)postgresDefTypeCheck, (String)"it");
                PostgresCreatingGenerator.this.prepareElement(postgresDefTypeCheck, $receiver, true);
            }
            return operation;
        }

        @Override
        public void produce() {
            switch (PostgresCreatingGenerator$PgCreateDefType$WhenMappings.$EnumSwitchMapping$0[((PostgresDefType)this.getElement()).getSubKind().ordinal()]) {
                case 1: {
                    this.generateEnum();
                    break;
                }
                case 2: {
                    this.generateDomain();
                    break;
                }
                case 3: {
                    this.generateComposite();
                }
            }
        }

        private final void generateEnum() {
            PostgresDefType e = (PostgresDefType)this.getElement();
            String name = AbstractCodeGenerator.currentScopeName$default(PostgresCreatingGenerator.this, e, null, 1, null);
            List<String> list = e.getLabels();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"e.labels");
            String labels2 = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)generateEnum.labels.1.INSTANCE, (int)31, null);
            String cmd = "create type " + name + " as enum (" + labels2 + ')';
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, cmd){
                final /* synthetic */ PgCreateDefType this$0;
                final /* synthetic */ String $cmd;

                public final void invoke() {
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), this.$cmd, null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateDefType;
                    this.$cmd = string;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateDomain() {
            PostgresDefType d = (PostgresDefType)this.getElement();
            String name = AbstractCodeGenerator.currentScopeName$default(PostgresCreatingGenerator.this, d, null, 1, null);
            String def2 = d.getDefinition();
            String cmd = "create domain " + name + " as " + def2 + (d.isNotNull() ? " not null" : "");
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, cmd, d){
                final /* synthetic */ PgCreateDefType this$0;
                final /* synthetic */ String $cmd;
                final /* synthetic */ PostgresDefType $d;

                public final void invoke() {
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), this.$cmd, null, false, null, 14, null);
                    AbstractCodeGenerator.coding$default(this.this$0.PostgresCreatingGenerator.this, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateDomain.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            void $receiver$iv;
                            if (this.this$0.$d.getDefaultExpression() != null) {
                                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.this$0.PostgresCreatingGenerator.this), "default " + this.this$0.$d.getDefaultExpression(), null, false, null, 14, null);
                            }
                            Iterable iterable = this.this$0.this$0.getNestedOperations();
                            PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.this$0.PostgresCreatingGenerator.this;
                            for (T element$iv : $receiver$iv) {
                                Operation p1 = (Operation)element$iv;
                                postgresCreatingGenerator.produce(p1);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                }
                {
                    this.this$0 = pgCreateDefType;
                    this.$cmd = string;
                    this.$d = postgresDefType;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateComposite() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateDefType this$0;

                public final void invoke() {
                    String name = AbstractCodeGenerator.currentScopeName$default(this.this$0.PostgresCreatingGenerator.this, this.this$0.getElement(), null, 1, null);
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "create type " + name + " as", null, false, null, 14, null);
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "(", null, false, null, 14, null);
                    CodeTextBuilder.indent$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), null, 1, null);
                    for (PostgresDefTypeAttribute postgresDefTypeAttribute : ((PostgresDefType)this.this$0.getElement()).getAttributes()) {
                        PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                        PostgresDefTypeAttribute postgresDefTypeAttribute2 = postgresDefTypeAttribute;
                        Intrinsics.checkExpressionValueIsNotNull((Object)postgresDefTypeAttribute2, (String)"a");
                        String string = postgresDefTypeAttribute2.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.name");
                        String n = PostgresCreatingGenerator.access$getScr$p(postgresCreatingGenerator, string);
                        DataType t = postgresDefTypeAttribute.getDataType();
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "" + n + ' ' + t + ',', null, false, null, 14, null);
                    }
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).removeSuffixFromTheLastLine(',');
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).unindent();
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), ")", null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateDefType;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateDefType(PostgresDefType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateOperator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresOperator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresOperator;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateOperator
    extends BaseCreatingGenerator.CreateProducer<PostgresOperator> {
        @Override
        public void produce() {
            PostgresOperator op = (PostgresOperator)this.getElement();
            ArrayList<String> props = new ArrayList<String>(4);
            if (op.getCallRoutineName() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("procedure = ");
                String string = op.getCallRoutineName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"op.callRoutineName!!");
                props.add(stringBuilder.append(PostgresCreatingGenerator.this.getScr(string)).toString());
            }
            if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
                StringBuilder stringBuilder = new StringBuilder().append("leftarg = ");
                DataType dataType = op.getLeftType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"op.leftType");
                props.add(stringBuilder.append(dataType.getSpecification()).toString());
            }
            if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
                StringBuilder stringBuilder = new StringBuilder().append("rightarg = ");
                DataType dataType = op.getRightType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"op.rightType");
                props.add(stringBuilder.append(dataType.getSpecification()).toString());
            }
            String specification = CollectionsKt.joinToString$default((Iterable)props, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String cmd = "create operator " + op.getName() + " (" + specification + ')';
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, cmd){
                final /* synthetic */ PgCreateOperator this$0;
                final /* synthetic */ String $cmd;

                public final void invoke() {
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), this.$cmd, null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateOperator;
                    this.$cmd = string;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateOperator(PostgresOperator element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateDefTypeCheck;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresDefTypeCheck;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresDefTypeCheck;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateDefTypeCheck
    extends BaseCreatingGenerator.CreateProducer<PostgresDefTypeCheck> {
        @Override
        public void produce() {
            String string = ((PostgresDefTypeCheck)this.getElement()).getNaturalName();
            String name = string != null ? PostgresCreatingGenerator.this.getScr(string) : null;
            String string2 = ((PostgresDefTypeCheck)this.getElement()).getPredicate();
            if (string2 == null) {
                return;
            }
            String predicate = string2;
            String txt = (name != null ? "constraint " + name + ' ' : "") + "check " + predicate;
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, txt){
                final /* synthetic */ PgCreateDefTypeCheck this$0;
                final /* synthetic */ String $txt;

                public final void invoke() {
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), this.$txt, null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateDefTypeCheck;
                    this.$txt = string;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateDefTypeCheck(PostgresDefTypeCheck element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateCollation;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresCollation;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresCollation;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateCollation
    extends BaseCreatingGenerator.CreateProducer<PostgresCollation> {
        @Override
        public void produce() {
            String string = ((PostgresCollation)this.getElement()).getCType();
            if (string == null) {
                return;
            }
            String cType = string;
            String string2 = ((PostgresCollation)this.getElement()).getCollate();
            if (string2 == null) {
                return;
            }
            String collate = string2;
            boolean useLocale = Intrinsics.areEqual((Object)cType, (Object)collate);
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, useLocale, cType, collate){
                final /* synthetic */ PgCreateCollation this$0;
                final /* synthetic */ boolean $useLocale;
                final /* synthetic */ String $cType;
                final /* synthetic */ String $collate;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CharSequence[] charSequenceArray = new CharSequence[4];
                    charSequenceArray[0] = "create collation";
                    PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                    ObjectKind objectKind = ObjectKind.COLLATION;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.COLLATION");
                    charSequenceArray[1] = postgresCreatingGenerator.ifNotExists(objectKind);
                    charSequenceArray[2] = AbstractCodeGenerator.currentScopeName$default(this.this$0.PostgresCreatingGenerator.this, this.this$0.getElement(), null, 1, null);
                    charSequenceArray[3] = "(";
                    codeTextBuilder.phrase(charSequenceArray);
                    if (this.$useLocale) {
                        CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("locale", "=", '\'' + this.$cType + '\'');
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("lc_collate", "=", '\'' + this.$collate + '\'');
                        PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).addSuffixToTheLastLine(',');
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("lc_ctype", "=", '\'' + this.$cType + '\'');
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), ")", null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateCollation;
                    this.$useLocale = bl;
                    this.$cType = string;
                    this.$collate = string2;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateCollation(PostgresCollation element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateForeignDataWrapper;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresForeignDataWrapper;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresForeignDataWrapper;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateForeignDataWrapper
    extends BaseCreatingGenerator.CreateProducer<PostgresForeignDataWrapper> {
        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateForeignDataWrapper this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CharSequence[] charSequenceArray = new CharSequence[2];
                    charSequenceArray[0] = "create foreign data wrapper";
                    PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                    String string = ((PostgresForeignDataWrapper)this.this$0.getElement()).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name");
                    charSequenceArray[1] = PostgresCreatingGenerator.access$getScr$p(postgresCreatingGenerator, string);
                    codeTextBuilder.phrase(charSequenceArray);
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (((PostgresForeignDataWrapper)this.this$0.getElement()).getHandler() != null) {
                            CodeTextBuilder codeTextBuilder2 = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                            CharSequence[] charSequenceArray2 = new CharSequence[2];
                            charSequenceArray2[0] = "handler";
                            PostgresCreatingGenerator postgresCreatingGenerator2 = this.this$0.PostgresCreatingGenerator.this;
                            String string2 = ((PostgresForeignDataWrapper)this.this$0.getElement()).getHandlerSchema();
                            String string3 = ((PostgresForeignDataWrapper)this.this$0.getElement()).getHandler();
                            if (string3 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.handler!!");
                            charSequenceArray2[1] = PostgresCreatingGenerator.access$maybeQualified(postgresCreatingGenerator2, string2, string3);
                            codeTextBuilder2.phrase(charSequenceArray2);
                        }
                        if (((PostgresForeignDataWrapper)this.this$0.getElement()).getValidator() != null) {
                            CodeTextBuilder codeTextBuilder3 = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                            CharSequence[] charSequenceArray3 = new CharSequence[2];
                            charSequenceArray3[0] = "validator";
                            PostgresCreatingGenerator postgresCreatingGenerator3 = this.this$0.PostgresCreatingGenerator.this;
                            String string4 = ((PostgresForeignDataWrapper)this.this$0.getElement()).getValidatorSchema();
                            String string5 = ((PostgresForeignDataWrapper)this.this$0.getElement()).getValidator();
                            if (string5 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"element.validator!!");
                            charSequenceArray3[1] = PostgresCreatingGenerator.access$maybeQualified(postgresCreatingGenerator3, string4, string5);
                            codeTextBuilder3.phrase(charSequenceArray3);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    PostgresCreatingGenerator postgresCreatingGenerator4 = this.this$0.PostgresCreatingGenerator.this;
                    List<String> list = ((PostgresForeignDataWrapper)this.this$0.getElement()).getOptions();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                    PostgresCreatingGenerator.access$appendOptions(postgresCreatingGenerator4, list);
                }
                {
                    this.this$0 = pgCreateForeignDataWrapper;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateForeignDataWrapper(PostgresForeignDataWrapper element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateForeignServer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresForeignServer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresForeignServer;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateForeignServer
    extends BaseCreatingGenerator.CreateProducer<PostgresForeignServer> {
        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateForeignServer this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CharSequence[] charSequenceArray = new CharSequence[2];
                    charSequenceArray[0] = "create server";
                    PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                    String string = ((PostgresForeignServer)this.this$0.getElement()).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name");
                    charSequenceArray[1] = PostgresCreatingGenerator.access$getScr$p(postgresCreatingGenerator, string);
                    codeTextBuilder.phrase(charSequenceArray);
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (((PostgresForeignServer)this.this$0.getElement()).getType() != null) {
                            PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("type", '\'' + ((PostgresForeignServer)this.this$0.getElement()).getType() + '\'');
                        }
                        if (((PostgresForeignServer)this.this$0.getElement()).getVersion() != null) {
                            PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("version", '\'' + ((PostgresForeignServer)this.this$0.getElement()).getVersion() + '\'');
                        }
                        CodeTextBuilder codeTextBuilder2 = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                        CharSequence[] charSequenceArray2 = new CharSequence[2];
                        charSequenceArray2[0] = "foreign data wrapper";
                        PostgresCreatingGenerator postgresCreatingGenerator2 = this.this$0.PostgresCreatingGenerator.this;
                        BasicElement basicElement = ((PostgresForeignServer)this.this$0.getElement()).getDasParent();
                        if (basicElement == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element.dasParent!!");
                        String string2 = basicElement.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.dasParent!!.name");
                        charSequenceArray2[1] = PostgresCreatingGenerator.access$getScr$p(postgresCreatingGenerator2, string2);
                        codeTextBuilder2.phrase(charSequenceArray2);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    PostgresCreatingGenerator postgresCreatingGenerator3 = this.this$0.PostgresCreatingGenerator.this;
                    List<String> list = ((PostgresForeignServer)this.this$0.getElement()).getOptions();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                    PostgresCreatingGenerator.access$appendOptions(postgresCreatingGenerator3, list);
                }
                {
                    this.this$0 = pgCreateForeignServer;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateForeignServer(PostgresForeignServer element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateUserMapping;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresUserMapping;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresUserMapping;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateUserMapping
    extends BaseCreatingGenerator.CreateProducer<PostgresUserMapping> {
        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateUserMapping this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    String string;
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("create user mapping for", (string = ((PostgresUserMapping)this.this$0.getElement()).getUser()) != null && (string = PostgresCreatingGenerator.access$getScr$p(this.this$0.PostgresCreatingGenerator.this, string)) != null ? (CharSequence)string : (CharSequence)"public");
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                        CharSequence[] charSequenceArray = new CharSequence[2];
                        charSequenceArray[0] = "server";
                        PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                        BasicElement basicElement = ((PostgresUserMapping)this.this$0.getElement()).getDasParent();
                        if (basicElement == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element.dasParent!!");
                        String string2 = basicElement.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.dasParent!!.name");
                        charSequenceArray[1] = PostgresCreatingGenerator.access$getScr$p(postgresCreatingGenerator, string2);
                        codeTextBuilder.phrase(charSequenceArray);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                    List<String> list = ((PostgresUserMapping)this.this$0.getElement()).getOptions();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                    PostgresCreatingGenerator.access$appendOptions(postgresCreatingGenerator, list);
                }
                {
                    this.this$0 = pgCreateUserMapping;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateUserMapping(PostgresUserMapping element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateLikeColumn;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateLikeColumn;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/basic/BasicLikeColumn;)V", "produce", "", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class PgCreateLikeColumn
    extends BaseCreatingGenerator.CreateLikeColumn {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Operation $receiver = operation = super.register(root2);
                if (!(this.getElement() instanceof PostgresLocalTableColumn) || ((PostgresLocalTableColumn)this.getElement()).getSequenceName() == null) break block3;
                BasicNode basicNode = ((PostgresLocalTableColumn)this.getElement()).getSchema();
                if (basicNode != null && (basicNode = basicNode.getSequences()) != null) {
                    String string = ((PostgresLocalTableColumn)this.getElement()).getSequenceName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((basicNode = (PostgresSequence)basicNode.get(string)) != null) {
                        BasicNode basicNode2;
                        BasicNode it = basicNode2 = basicNode;
                        PostgresCreatingGenerator.this.prepareElement((BasicElement)it, $receiver, true);
                    }
                }
            }
            return operation;
        }

        @Override
        public void produce() {
            if (!(this.getElement() instanceof PostgresTableColumn) || !((PostgresTableColumn)this.getElement()).isInherited()) {
                super.produce();
            }
        }

        public PgCreateLikeColumn(BasicLikeColumn element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "Lcom/intellij/database/model/basic/BasicTrigger;", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/basic/BasicTrigger;)V", "produce", "", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class PgCreateTrigger
    extends BaseCreatingGenerator.CreateTrigger {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Operation $receiver = operation = super.register(root2);
                if (!(this.getElement() instanceof PostgresTrigger)) break block2;
                PostgresRoutine callRoutine = PostgresModelFun.getCallRoutine((PostgresTrigger)this.getElement());
                if (Intrinsics.areEqual((Object)((Object)PostgresCreatingGenerator.this.getCategory()), (Object)((Object)ScriptCategory.CREATE_DEFINITION)) ^ true) {
                    PostgresRoutine postgresRoutine = callRoutine;
                    if (postgresRoutine != null) {
                        PostgresRoutine postgresRoutine2;
                        PostgresRoutine it = postgresRoutine2 = postgresRoutine;
                        BaseCreatingGenerator.prepareElement$default(PostgresCreatingGenerator.this, it, root2, false, 4, null);
                    }
                }
            }
            return operation;
        }

        @Override
        public void produce() {
            if (this.getElement() instanceof PostgresTrigger) {
                PostgresCreatingGenerator.this.generatePostgresTrigger((PostgresTrigger)this.getElement());
            } else if (this.getElement() instanceof BasicSourceAware) {
                PostgresCreatingGenerator.this.generateUnspecificSourceAwareElement((BasicSourceAware)this.getElement());
            }
        }

        public PgCreateTrigger(BasicTrigger element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateSequence;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateSequence;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "Lcom/intellij/database/model/basic/BasicSequence;", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/basic/BasicSequence;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateSequence
    extends BaseCreatingGenerator.CreateSequence {
        @Override
        public void produce() {
            if (!(this.getElement() instanceof PostgresSequence) || !((PostgresSequence)this.getElement()).isBelongsToColumn()) {
                super.produce();
            }
        }

        public PgCreateSequence(BasicSequence element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(element);
        }
    }
}

