/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseEnableDisableGenerator;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.postgres.PgEnableDisableGenerator;
import com.intellij.database.scripting.postgres.PostgresBaseExecuteGenerator;
import com.intellij.database.scripting.postgres.PostgresBaseScriptingService;
import com.intellij.database.scripting.postgres.PostgresCreatingGenerator;
import com.intellij.database.scripting.postgres.PostgresDropGenerator;
import com.intellij.database.scripting.postgres.PostgresScriptingService$WhenMappings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresScriptingService;", "Lcom/intellij/database/scripting/postgres/PostgresBaseScriptingService;", "()V", "VERSION", "Lcom/intellij/database/model/PerObjectVersion;", "getVERSION", "()Lcom/intellij/database/model/PerObjectVersion;", "createCreatingGenerator", "Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createDropGenerator", "Lcom/intellij/database/scripting/postgres/PostgresDropGenerator;", "createEnableDisableGenerator", "Lcom/intellij/database/scripting/BaseEnableDisableGenerator;", "createExecuteGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "isRefactoringSupported", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isSupported", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "", "intellij.database.scripting"})
public final class PostgresScriptingService
extends PostgresBaseScriptingService {
    @NotNull
    private static final PerObjectVersion VERSION;
    public static final PostgresScriptingService INSTANCE;

    @Override
    @NotNull
    protected PerObjectVersion getVERSION() {
        return VERSION;
    }

    @Override
    @NotNull
    protected PostgresCreatingGenerator createCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new PostgresCreatingGenerator(context, task);
    }

    @Override
    @NotNull
    protected BaseEnableDisableGenerator createEnableDisableGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new PgEnableDisableGenerator(context, task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new PostgresBaseExecuteGenerator(context, task);
    }

    @Override
    @NotNull
    protected PostgresDropGenerator createDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new PostgresDropGenerator(context, task);
    }

    public final boolean isRefactoringSupported(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ROUTINE);
    }

    @Override
    public boolean isSupported(@NotNull ScriptCategory category, @NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        switch (PostgresScriptingService$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
            case 1: {
                bl = PostgresDropGenerator.Companion.canDrop(kind, context);
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private PostgresScriptingService() {
        Rdbms rdbms = Postgres.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Postgres.RDBMS");
        super(rdbms);
    }

    static {
        PostgresScriptingService postgresScriptingService;
        INSTANCE = postgresScriptingService = new PostgresScriptingService();
        VERSION = new PerObjectVersion();
    }
}

