/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAltNamesProvider;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameChecker {
    public final String sourceText;
    public final boolean sourcePlain;
    @Nullable
    public final SqlLanguageDialect dialect;
    public final CasingProvider casingProvider;
    public final String[] actualCache;

    public NameChecker(@NotNull String name, boolean quoted, @NotNull CasingProvider provider, @Nullable SqlLanguageDialect dialect) {
        if (name == null) {
            NameChecker.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            NameChecker.$$$reportNull$$$0(1);
        }
        this.actualCache = new String[2];
        this.dialect = dialect;
        this.sourcePlain = !quoted;
        this.sourceText = name;
        this.casingProvider = provider;
    }

    public NameChecker(@NotNull DasObject object, @NotNull SqlLanguageDialect dialect) {
        if (object == null) {
            NameChecker.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            NameChecker.$$$reportNull$$$0(3);
        }
        this(object.getName(), DbSqlUtil.isQuoted(object), (CasingProvider)dialect, dialect);
    }

    public NameChecker(@NotNull SqlReferenceExpression ref, @NotNull SqlLanguageDialect dialect, CasingProvider provider) {
        if (ref == null) {
            NameChecker.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            NameChecker.$$$reportNull$$$0(5);
        }
        this(ref.getName(), DbSqlUtil.isQuoted((SqlNameElement)ref), provider, dialect);
    }

    @Nullable
    private static DasObject getDasContext(@Nullable SqlExpression qualifier) {
        PsiReference reference = qualifier == null ? null : qualifier.getReference();
        PsiElement target = reference == null ? null : reference.resolve();
        return target instanceof DasObject ? (DasObject)target : null;
    }

    @Nullable
    private static String getName(@NotNull Object target) {
        if (target == null) {
            NameChecker.$$$reportNull$$$0(6);
        }
        if (target instanceof DasObject) {
            return ((DasObject)target).getName();
        }
        if (target instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)target).getName();
        }
        return null;
    }

    private static boolean isQuoted(@NotNull Object target) {
        if (target == null) {
            NameChecker.$$$reportNull$$$0(7);
        }
        if (target instanceof DasObject) {
            return DbSqlUtil.isQuoted((DasObject)target);
        }
        if (target instanceof SqlReferenceExpression) {
            return DbSqlUtil.isQuoted((SqlNameElement)((SqlReferenceExpression)target));
        }
        return false;
    }

    public boolean checkName(@Nullable Object target, @Nullable Boolean forcedCaseSens) {
        boolean caseSensitive;
        if (target == null) {
            return false;
        }
        String name = NameChecker.getName(target);
        if (name == null) {
            throw new IllegalArgumentException(target.getClass().getName());
        }
        if (!Comparing.strEqual((String)name, (String)this.sourceText, (boolean)false) && (name = this.getAltName(target)) == null) {
            return false;
        }
        boolean isBuiltInFunction = target instanceof BuiltinFunction;
        if (this.dialect != null) {
            DatabaseDialect databaseDialect = this.dialect.getDatabaseDialect();
            if (isBuiltInFunction && databaseDialect.getFamilyId().isSybase()) {
                return true;
            }
            if (isBuiltInFunction && databaseDialect.getFamilyId().isTransactSql() && ((BuiltinFunction)target).getPostfixType() == null) {
                return this.sourcePlain;
            }
        }
        boolean targetIsPlain = !NameChecker.isQuoted(target);
        Casing inPlaceCasing = NameChecker.getCasing(target, this.casingProvider);
        Case targetCase = inPlaceCasing.choose(targetIsPlain);
        Case sourceCase = inPlaceCasing.choose(this.sourcePlain);
        String targetActual = NameChecker.getActualName(target, name, targetIsPlain, this.casingProvider);
        if (forcedCaseSens != null) {
            return this.compareWithSource(targetActual, sourceCase, forcedCaseSens == Boolean.TRUE);
        }
        if (isBuiltInFunction) {
            return this.compareWithSource(targetActual, sourceCase, sourceCase == Case.EXACT && !this.sourcePlain);
        }
        boolean targetCaseSensitive = targetCase != Case.MIXED;
        boolean sourceCaseSensitive = sourceCase != Case.MIXED;
        boolean bl = caseSensitive = sourceCaseSensitive && targetCaseSensitive;
        return this.compareWithSource(targetActual, sourceCase, caseSensitive);
    }

    @Nullable
    protected String getAltName(@NotNull Object target) {
        SqlAltNamesProvider altNames;
        if (target == null) {
            NameChecker.$$$reportNull$$$0(8);
        }
        if ((altNames = (SqlAltNamesProvider)ObjectUtils.tryCast((Object)target, SqlAltNamesProvider.class)) == null) {
            return null;
        }
        for (String text : altNames.getAltNames()) {
            if (!Comparing.strEqual((String)text, (String)this.sourceText, (boolean)false)) continue;
            return text;
        }
        return null;
    }

    @NotNull
    private static Casing getCasing(@NotNull Object target, CasingProvider casingProvider) {
        DasObject object;
        if (target == null) {
            NameChecker.$$$reportNull$$$0(9);
        }
        if ((object = (DasObject)ObjectUtils.tryCast((Object)target, DasObject.class)) != null) {
            Casing casing = casingProvider.getCasing(object.getKind(), object);
            if (casing == null) {
                NameChecker.$$$reportNull$$$0(10);
            }
            return casing;
        }
        ObjectKind kind = ((SqlReferenceExpression)target).getReferenceElementType().getTargetKind();
        DasObject context = NameChecker.getDasContext(((SqlReferenceExpression)target).getQualifierExpression());
        Casing casing = casingProvider.getCasing(kind, context);
        if (casing == null) {
            NameChecker.$$$reportNull$$$0(11);
        }
        return casing;
    }

    private boolean compareWithSource(String targetActual, Case sourceCase, boolean caseSensitive) {
        if (!caseSensitive) {
            return Comparing.strEqual((String)targetActual, (String)this.sourceText, (boolean)false);
        }
        return Comparing.strEqual((String)targetActual, (String)this.getSourceActual(sourceCase), (boolean)true);
    }

    private String getSourceActual(Case sourceCase) {
        if (sourceCase == Case.EXACT || sourceCase == Case.MIXED) {
            return this.sourceText;
        }
        int i2 = sourceCase == Case.LOWER ? 0 : 1;
        return this.actualCache[i2] == null ? sourceCase.apply(this.sourceText) : this.actualCache[i2];
    }

    @Nullable
    private static String getActualName(Object o, @Nullable String name, boolean isPlain, @NotNull CasingProvider casing) {
        ObjectKind kind;
        if (casing == null) {
            NameChecker.$$$reportNull$$$0(12);
        }
        if (name == null || name == DasUtil.NO_NAME) {
            return null;
        }
        ObjectKind objectKind = o instanceof DasObject ? ((DasObject)o).getKind() : (kind = o instanceof SqlReferenceExpression ? ((SqlReferenceExpression)o).getReferenceElementType().getTargetKind() : ObjectKind.TABLE);
        if (kind == ObjectKind.SCHEMA && StringUtil.isEmpty((String)name) && o instanceof DbElement) {
            return QNameUtil.getQualifiedName((DbElement)o);
        }
        Casing casing1 = casing.getCasing(kind, (DasObject)ObjectUtils.tryCast((Object)o, DasObject.class));
        return casing1.choose(isPlain).apply(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/NameChecker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/NameChecker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isQuoted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAltName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getActualName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

