/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vendors.db2.Db2DefinitionProvider;
import com.intellij.database.vendors.derby.DerbyDefinitionProvider;
import com.intellij.database.vendors.exasol.ExasolDefinitionProvider;
import com.intellij.database.vendors.h2.H2DefinitionProvider;
import com.intellij.database.vendors.hsql.HsqlDefinitionProvider;
import com.intellij.database.vendors.mssql.MsDefinitionProvider;
import com.intellij.database.vendors.mysql.MysqlDefinitionProvider;
import com.intellij.database.vendors.oracle.OracleDefinitionProvider;
import com.intellij.database.vendors.sqlite.SqliteDefinitionProvider;
import com.intellij.database.vendors.sybase.SybaseDefinitionProvider;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefinitionProviderImpl
implements DefinitionProvider {
    @Override
    @NotNull
    public Iterable<DasObject> load(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull StringBuilder sink) throws Exception {
        if (objects == null) {
            DefinitionProviderImpl.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            DefinitionProviderImpl.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            DefinitionProviderImpl.$$$reportNull$$$0(2);
        }
        this.fetchSources(objects, connection, (PairConsumer<DasObject, Object>)((PairConsumer)(o, s) -> {
            if (sink == null) {
                DefinitionProviderImpl.$$$reportNull$$$0(5);
            }
            if (s instanceof String) {
                sink.append(s).append("\n\n");
            }
            if (s instanceof Throwable) {
                sink.append("-- ").append(o.getName()).append("\n-- ").append(((Throwable)s).getMessage());
            }
        }));
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            DefinitionProviderImpl.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    protected abstract void fetchSources(@NotNull Iterable<? extends DasObject> var1, @NotNull DatabaseConnection var2, @NotNull PairConsumer<DasObject, Object> var3) throws Exception;

    @Nullable
    public static DefinitionProvider find(@NotNull LocalDataSource dataSource) {
        DatabaseFamilyId familyId;
        if (dataSource == null) {
            DefinitionProviderImpl.$$$reportNull$$$0(4);
        }
        if ((familyId = DbImplUtil.getDatabaseDialect(dataSource).getFamilyId()).isMicrosoft()) {
            return MsDefinitionProvider.INSTANCE;
        }
        if (familyId.isMysql()) {
            return MysqlDefinitionProvider.INSTANCE;
        }
        if (familyId.isSqlite()) {
            return SqliteDefinitionProvider.INSTANCE;
        }
        if (familyId.isDerby()) {
            return DerbyDefinitionProvider.INSTANCE;
        }
        if (familyId.isH2()) {
            return H2DefinitionProvider.INSTANCE;
        }
        if (familyId.isHsqldb()) {
            return HsqlDefinitionProvider.INSTANCE;
        }
        if (familyId.isDb2()) {
            return Db2DefinitionProvider.INSTANCE;
        }
        if (familyId.isOracle()) {
            return OracleDefinitionProvider.INSTANCE;
        }
        if (familyId.isSybase()) {
            return SybaseDefinitionProvider.INSTANCE;
        }
        if (familyId.isExasol()) {
            return ExasolDefinitionProvider.INSTANCE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vendors/DefinitionProviderImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vendors/DefinitionProviderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$load$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Tsql
    extends DefinitionProviderImpl {
        @Override
        @NotNull
        public Iterable<DasObject> load(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull StringBuilder sink) throws Exception {
            if (objects == null) {
                Tsql.$$$reportNull$$$0(0);
            }
            if (connection == null) {
                Tsql.$$$reportNull$$$0(1);
            }
            if (sink == null) {
                Tsql.$$$reportNull$$$0(2);
            }
            this.fetchSourcesByDb(objects, connection, (PairConsumer<DasObject, Object>)((PairConsumer)(o, s) -> {
                if (sink == null) {
                    Tsql.$$$reportNull$$$0(7);
                }
                if (s instanceof String) {
                    sink.append(s).append("\nGO\n\n");
                }
                if (s instanceof Throwable) {
                    sink.append("-- ").append(o.getName()).append("\n-- ").append(((Throwable)s).getMessage());
                }
            }));
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                Tsql.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fetchSourcesByDb(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
            if (objects == null) {
                Tsql.$$$reportNull$$$0(4);
            }
            if (connection == null) {
                Tsql.$$$reportNull$$$0(5);
            }
            if (consumer == null) {
                Tsql.$$$reportNull$$$0(6);
            }
            MultiMap map = MultiMap.create();
            for (DasObject dasObject : objects) {
                map.putValue((Object)DasUtil.getCatalog((DasObject)dasObject), (Object)dasObject);
            }
            String currentDb = this.getCurrentDb(connection);
            Collection collection = map.remove((Object)currentDb);
            if (collection != null) {
                this.fetchSources(collection, connection, consumer);
            }
            if (!map.isEmpty()) {
                try (PreparedStatement statement = connection.prepareStatement("use ?");){
                    try {
                        for (Map.Entry entry : map.entrySet()) {
                            statement.setString(1, (String)entry.getKey());
                            statement.execute();
                            this.fetchSources((Iterable)entry.getValue(), connection, consumer);
                        }
                    }
                    finally {
                        if (currentDb != null) {
                            statement.setString(1, currentDb);
                            statement.execute();
                        }
                    }
                }
            }
        }

        @Nullable
        protected abstract String getCurrentDb(@NotNull DatabaseConnection var1) throws SQLException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/vendors/DefinitionProviderImpl$Tsql";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/vendors/DefinitionProviderImpl$Tsql";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "load";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fetchSourcesByDb";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$load$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

